/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import javax.script.Namespace;
import javax.script.ScriptContext;
import javax.script.SimpleNamespace;

public class GenericScriptContext
implements ScriptContext {
    protected Writer writer;
    protected Writer errorWriter;
    protected Reader reader;
    protected Namespace engineScope = new SimpleNamespace();
    protected Namespace globalScope = null;

    public GenericScriptContext() {
        this.reader = new InputStreamReader(System.in);
        this.writer = new PrintWriter(System.out, true);
        this.errorWriter = new PrintWriter(System.err, true);
    }

    public void setNamespace(Namespace namespace, int scope) {
        switch (scope) {
            case 100: {
                if (namespace == null) {
                    throw new NullPointerException("Engine scope cannot be null.");
                }
                this.engineScope = namespace;
                break;
            }
            case 200: {
                this.globalScope = namespace;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope value.");
            }
        }
    }

    public Object getAttribute(String name) {
        Object ret = this.getAttribute(name, 100);
        if (null != ret) {
            return ret;
        }
        ret = this.getAttribute(name, 200);
        if (null != ret) {
            return ret;
        }
        return null;
    }

    public Object getAttribute(String name, int scope) {
        switch (scope) {
            case 100: {
                return this.engineScope.get(name);
            }
            case 200: {
                if (this.globalScope != null) {
                    return this.globalScope.get(name);
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Illegal scope value.");
    }

    public Object removeAttribute(String name, int scope) {
        switch (scope) {
            case 100: {
                if (this.getNamespace(100) != null) {
                    return this.getNamespace(100).remove(name);
                }
                return null;
            }
            case 200: {
                if (this.getNamespace(200) != null) {
                    return this.getNamespace(200).remove(name);
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Illegal scope value.");
    }

    public void setAttribute(String name, Object value, int scope) {
        switch (scope) {
            case 100: {
                this.engineScope.put(name, value);
                return;
            }
            case 200: {
                if (this.globalScope != null) {
                    this.globalScope.put(name, value);
                }
                return;
            }
        }
        throw new IllegalArgumentException("Illegal scope value.");
    }

    public Writer getWriter() {
        return this.writer;
    }

    public Reader getReader() {
        return this.reader;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getErrorWriter() {
        return this.errorWriter;
    }

    public void setErrorWriter(Writer writer) {
        this.errorWriter = writer;
    }

    public int getAttributesScope(String name) {
        if (this.getAttribute(name, 100) != null) {
            return 100;
        }
        if (this.globalScope != null && this.getAttribute(name, 200) != null) {
            return 200;
        }
        return 0;
    }

    public Namespace getNamespace(int scope) {
        if (scope == 100) {
            return this.engineScope;
        }
        if (scope == 200) {
            return this.globalScope;
        }
        throw new IllegalArgumentException("Illegal scope value.");
    }
}

