/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.io.Reader;
import javax.script.GenericScriptContext;
import javax.script.Namespace;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public abstract class GenericScriptEngine
implements ScriptEngine {
    protected ScriptContext context = new GenericScriptContext();

    public GenericScriptEngine() {
    }

    public GenericScriptEngine(Namespace n) {
        this();
        this.context.setNamespace(n, 100);
    }

    public void setContext(ScriptContext ctxt) {
        this.context = ctxt;
    }

    public ScriptContext getContext() {
        return this.context;
    }

    public Namespace getNamespace(int scope) {
        if (scope == 200) {
            return this.context.getNamespace(200);
        }
        if (scope == 100) {
            return this.context.getNamespace(100);
        }
        throw new IllegalArgumentException("Invalid scope value.");
    }

    public void setNamespace(Namespace namespace, int scope) {
        if (scope == 200) {
            this.context.setNamespace(namespace, 200);
        } else if (scope == 100) {
            this.context.setNamespace(namespace, 100);
        } else {
            throw new IllegalArgumentException("Invalid scope value.");
        }
    }

    public void put(String key, Object value) {
        Namespace nn = this.getNamespace(100);
        if (nn != null) {
            nn.put(key, value);
        }
    }

    public Object get(String key) {
        Namespace nn = this.getNamespace(100);
        if (nn != null) {
            return nn.get(key);
        }
        return null;
    }

    public Object eval(Reader reader, Namespace namespace) throws ScriptException {
        ScriptContext ctxt = this.getScriptContext(namespace);
        return this.eval(reader, ctxt);
    }

    public Object eval(String script, Namespace namespace) throws ScriptException {
        ScriptContext ctxt = this.getScriptContext(namespace);
        return this.eval(script, ctxt);
    }

    public Object eval(Reader reader) throws ScriptException {
        return this.eval(reader, this.context);
    }

    public Object eval(String script) throws ScriptException {
        return this.eval(script, this.context);
    }

    protected ScriptContext getScriptContext(Namespace nn) {
        GenericScriptContext ctxt = new GenericScriptContext();
        Namespace gs = this.getNamespace(200);
        if (gs != null) {
            ctxt.setNamespace(gs, 200);
        }
        if (nn == null) {
            throw new NullPointerException("Engine scope Namespace may not be null.");
        }
        ctxt.setNamespace(nn, 100);
        ctxt.setReader(this.context.getReader());
        ctxt.setWriter(this.context.getWriter());
        ctxt.setErrorWriter(this.context.getErrorWriter());
        return ctxt;
    }
}

