/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.script.Namespace;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.SimpleNamespace;

public class ScriptEngineManager {
    protected HashSet engineSpis;
    protected HashMap nameAssociations;
    protected HashMap extensionAssociations;
    protected HashMap mimeTypeAssociations;
    protected Namespace globalScope = new SimpleNamespace();
    static /* synthetic */ Class class$javax$script$ScriptEngineFactory;

    public ScriptEngineManager() {
        try {
            this.engineSpis = new HashSet();
            this.nameAssociations = new HashMap();
            this.extensionAssociations = new HashMap();
            this.mimeTypeAssociations = new HashMap();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            String resourceName = "META-INF/services/javax.script.ScriptEngineFactory";
            Enumeration<URL> enumResources = loader.getResources(resourceName);
            while (enumResources.hasMoreElements()) {
                URL url = enumResources.nextElement();
                InputStream stream = url.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                String line = null;
                while (null != (line = reader.readLine())) {
                    this.addSpi(line);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setNamespace(Namespace namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException("Global scope cannot be null.");
        }
        this.globalScope = namespace;
    }

    public Namespace getNamespace() {
        return this.globalScope;
    }

    public void put(String key, Object value) {
        this.globalScope.put(key, value);
    }

    public Object get(String key) {
        return this.globalScope.get(key);
    }

    public ScriptEngine getEngineByName(String shortName) {
        Object obj = this.nameAssociations.get(shortName);
        if (null != obj) {
            ScriptEngineFactory spi = (ScriptEngineFactory)obj;
            ScriptEngine engine = spi.getScriptEngine();
            engine.setNamespace(this.getNamespace(), 200);
            return engine;
        }
        Iterator it = this.engineSpis.iterator();
        while (it.hasNext()) {
            ScriptEngineFactory spi = (ScriptEngineFactory)it.next();
            String[] names = spi.getNames();
            if (names == null) continue;
            int len = names.length;
            for (int i = 0; i < len; ++i) {
                if (!shortName.equals(names[i])) continue;
                ScriptEngine engine = spi.getScriptEngine();
                engine.setNamespace(this.getNamespace(), 200);
                return engine;
            }
        }
        return null;
    }

    public ScriptEngine getEngineByExtension(String extension) {
        Object obj = this.extensionAssociations.get(extension);
        if (null != obj) {
            ScriptEngineFactory spi = (ScriptEngineFactory)obj;
            ScriptEngine engine = spi.getScriptEngine();
            engine.setNamespace(this.getNamespace(), 200);
            return engine;
        }
        Iterator it = this.engineSpis.iterator();
        while (it.hasNext()) {
            ScriptEngineFactory spi = (ScriptEngineFactory)it.next();
            String[] exts = spi.getExtensions();
            int len = exts.length;
            for (int i = 0; i < len; ++i) {
                if (!exts[i].equals(extension)) continue;
                ScriptEngine engine = spi.getScriptEngine();
                engine.setNamespace(this.getNamespace(), 200);
                return engine;
            }
        }
        return null;
    }

    public ScriptEngine getEngineByMimeType(String mimeType) {
        Object obj = this.mimeTypeAssociations.get(mimeType);
        if (null != obj) {
            ScriptEngineFactory spi = (ScriptEngineFactory)obj;
            ScriptEngine engine = spi.getScriptEngine();
            engine.setNamespace(this.getNamespace(), 200);
            return engine;
        }
        Iterator it = this.engineSpis.iterator();
        while (it.hasNext()) {
            ScriptEngineFactory spi = (ScriptEngineFactory)it.next();
            String[] types = spi.getMimeTypes();
            int len = types.length;
            for (int i = 0; i < len; ++i) {
                if (!types[i].equals(mimeType)) continue;
                ScriptEngine engine = spi.getScriptEngine();
                engine.setNamespace(this.getNamespace(), 200);
                return engine;
            }
        }
        return null;
    }

    public ScriptEngineFactory[] getEngineFactories() {
        Iterator it = this.engineSpis.iterator();
        int len = this.engineSpis.size();
        ScriptEngineFactory[] ret = new ScriptEngineFactory[len];
        int i = 0;
        while (it.hasNext()) {
            ret[i++] = (ScriptEngineFactory)it.next();
        }
        return ret;
    }

    public void registerEngineName(String name, Class factory) {
        if (!(class$javax$script$ScriptEngineFactory == null ? (class$javax$script$ScriptEngineFactory = ScriptEngineManager.class$("javax.script.ScriptEngineFactory")) : class$javax$script$ScriptEngineFactory).isAssignableFrom(factory.getClass())) {
            throw new IllegalArgumentException();
        }
        this.nameAssociations.put(name, factory);
    }

    public void registerEngineMimeType(String type, Class factory) {
        if (!(class$javax$script$ScriptEngineFactory == null ? (class$javax$script$ScriptEngineFactory = ScriptEngineManager.class$("javax.script.ScriptEngineFactory")) : class$javax$script$ScriptEngineFactory).isAssignableFrom(factory.getClass())) {
            throw new IllegalArgumentException();
        }
        this.mimeTypeAssociations.put(type, factory);
    }

    public void registerEngineExtension(String extension, Class factory) {
        if (!(class$javax$script$ScriptEngineFactory == null ? (class$javax$script$ScriptEngineFactory = ScriptEngineManager.class$("javax.script.ScriptEngineFactory")) : class$javax$script$ScriptEngineFactory).isAssignableFrom(factory.getClass())) {
            throw new IllegalArgumentException();
        }
        this.extensionAssociations.put(extension, factory);
    }

    private void addSpi(String line) {
        String trimmedLine;
        int hash = line.indexOf(35);
        if (hash != -1) {
            line = line.substring(0, hash);
        }
        if (!(trimmedLine = line.trim()).equals("")) {
            String mungedName = null;
            try {
                mungedName = trimmedLine.replace('/', '.');
                Class<?> clasz = Class.forName(mungedName);
                Object obj = clasz.newInstance();
                if (obj instanceof ScriptEngineFactory) {
                    this.engineSpis.add(obj);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

