# テーブル作成

# テーブル名：キーシーケンス管理
# テーブルID：KEYSEQ
# M/T：T
# 備考：ユニークキー取得用
CREATE TABLE IF NOT EXISTS KEYSEQ (
    NAME            VARCHAR(32)     NOT NULL    PRIMARY KEY     COMMENT 'キーシーケンス名',
    SEQ             INTEGER(10)     NOT NULL    DEFAULT 0       COMMENT 'シーケンス、初期値は0'
) ENGINE=InnoDB;


# テーブル名：ワークフロー定義管理
# テーブルID：DEFINITION
# M/T：M
# 備考：
CREATE TABLE IF NOT EXISTS DEFINITION (
    PROC_DEF_ID     VARCHAR(64)     NOT NULL    PRIMARY KEY     COMMENT 'プロセス定義ID',
    PATH            VARCHAR(128)    NOT NULL                    COMMENT '定義相対パス',
    INTERNAL_PDID   VARCHAR(64)     NOT NULL                    COMMENT '内部プロセス定義ID',
    REGISTER_DATE   DATETIME        NOT NULL                    COMMENT '登録日',
    DEF_STATE       INTEGER(1)      NOT NULL                    COMMENT '定義状態'
) ENGINE=InnoDB;


# テーブル名：組織
# テーブルID：ORGANIZATION
# M/T：M
# 備考：
CREATE TABLE IF NOT EXISTS ORGANIZATION (
    ORG_ID          VARCHAR(64)     NOT NULL    PRIMARY KEY     COMMENT '組織ID',
    ORG_NAME        VARCHAR(128)    NOT NULL                    COMMENT '組織名',
    HIGHER_ORG_ID   VARCHAR(64)                                 COMMENT '上位組織ID'
) ENGINE=InnoDB;


# テーブル名：ユーザ
# テーブルID：USER
# M/T：M
# 備考：
CREATE TABLE IF NOT EXISTS USER (
    USER_ID         VARCHAR(64)     NOT NULL    PRIMARY KEY     COMMENT 'ユーザID',
    FIRST_NAME      VARCHAR(64)     NOT NULL                    COMMENT '名',
    LAST_NAME       VARCHAR(64)     NOT NULL                    COMMENT '姓',
    PASSWORD        VARCHAR(64)     NOT NULL                    COMMENT 'パスワード',
    MAIL_ADDRESS    VARCHAR(64)     NOT NULL                    COMMENT 'メールアドレス'
) ENGINE=InnoDB;


# テーブル名：役割
# テーブルID：ROLE
# M/T：M
# 備考：
CREATE TABLE IF NOT EXISTS ROLE (
    ROLE_ID         VARCHAR(64)     NOT NULL    PRIMARY KEY     COMMENT '役割ID',
    DESCRIPTION     VARCHAR(128)                                COMMENT '役割名'
) ENGINE=InnoDB;


# テーブル名：組織ユーザ関連
# テーブルID：ORGUSERMAP
# M/T：M
# 備考：
CREATE TABLE IF NOT EXISTS ORGUSERMAP (
    ORG_ID          VARCHAR(64)     NOT NULL                    COMMENT '組織ID',
    USER_ID         VARCHAR(64)     NOT NULL                    COMMENT 'ユーザID',
    CONSTRAINT ORGUSERMAP_PK PRIMARY KEY (
        ORG_ID,
        USER_ID
    )
) ENGINE=InnoDB;


# テーブル名：組織役割関連
# テーブルID：ORGROLEMAP
# M/T：M
# 備考：
CREATE TABLE IF NOT EXISTS ORGROLEMAP (
    ROLE_ID         VARCHAR(64)     NOT NULL                    COMMENT '役割ID',
    ORG_ID          VARCHAR(64)     NOT NULL                    COMMENT '組織ID',
    CONSTRAINT ORGROLEMAP_PK PRIMARY KEY (
        ROLE_ID,
        ORG_ID
    )
) ENGINE=InnoDB;


# テーブル名：ユーザ役割関連
# テーブルID：USERROLEMAP
# M/T：M
# 備考：
CREATE TABLE IF NOT EXISTS USERROLEMAP (
    ROLE_ID         VARCHAR(64)     NOT NULL                    COMMENT '役割ID',
    USER_ID         VARCHAR(64)     NOT NULL                    COMMENT 'ユーザID',
    CONSTRAINT USERROLEMAP_PK PRIMARY KEY (
        ROLE_ID,
        USER_ID
    )
) ENGINE=InnoDB;


# テーブル名：プロセスインスタンス
# テーブルID：PROCESS
# M/T：T
# 備考：
CREATE TABLE IF NOT EXISTS PROCESS (
    PROC_ID         VARCHAR(64)     NOT NULL    PRIMARY KEY     COMMENT 'プロセスインスタンスID',
    NAME            VARCHAR(128)                                COMMENT 'プロセス名',
    PACKAGE_ID      VARCHAR(64)     NOT NULL                    COMMENT 'パッケージID',
    PROC_DEF_ID     VARCHAR(64)     NOT NULL                    COMMENT 'プロセス定義ID',
    START_DATE      DATETIME        NOT NULL                    COMMENT '開始日時',
    STARTER_ID      VARCHAR(64)     NOT NULL                    COMMENT '開始者',
    DURATION_LIMIT  DATETIME        NOT NULL                    COMMENT '実行期限',
    PROC_STATE      INTEGER(1)      NOT NULL    DEFAULT 1       COMMENT '状態、初期値は1:open.not_running.not_started',
    UPDATE_DATE     DATETIME                                    COMMENT '最新状態更新日時'
) ENGINE=InnoDB;


# テーブル名：プロセス変数インスタンス
# テーブルID：VARIABLE
# M/T：T
# 備考：
CREATE TABLE IF NOT EXISTS VARIABLE (
    VAR_ID          VARCHAR(64)     NOT NULL    PRIMARY KEY     COMMENT 'プロセス変数インスタンスID',
    NAME            VARCHAR(128)    NOT NULL                    COMMENT '変数名',
    PROC_ID         VARCHAR(64)     NOT NULL                    COMMENT 'プロセスインスタンスID',
    VAR_DEF_ID      VARCHAR(64)     NOT NULL                    COMMENT 'プロセス変数定義ID',
    TYPE            INTEGER(1)      NOT NULL                    COMMENT '変数型',
    VALUE           TEXT            NOT NULL                    COMMENT '変数値',
    UPDATE_DATE     DATETIME                                    COMMENT '最新状態更新日時'
) ENGINE=InnoDB;


# テーブル名：アクティビティインスタンス
# テーブルID：ACTIVITY
# M/T：T
# 備考：
CREATE TABLE IF NOT EXISTS ACTIVITY (
    PROC_ID         VARCHAR(64)     NOT NULL                    COMMENT 'プロセスインスタンスID',
    ACT_ID          VARCHAR(64)     NOT NULL                    COMMENT 'アクティビティインスタンスID',
    ACT_DEF_ID      VARCHAR(64)     NOT NULL                    COMMENT 'アクティビティ定義ID',
    START_DATE      DATETIME        NOT NULL                    COMMENT '開始日時',
    STARTER_ID      VARCHAR(64)     NOT NULL                    COMMENT '開始者',
    DURATION_LIMIT  DATETIME        NOT NULL                    COMMENT '実行期限',
    BLOCK_ID        VARCHAR(64)                                 COMMENT '所属する並行処理ブロックID',
    ACT_STATE       INTEGER(1)      NOT NULL    DEFAULT 1       COMMENT '状態、初期値は1:open.not_running.not_started',
    ACTOR_ID        VARCHAR(64)                                 COMMENT '実行者ID',
    UPDATE_DATE     DATETIME                                    COMMENT '最新状態更新日時',
    CONSTRAINT ACTIVITY_PK PRIMARY KEY (
        PROC_ID,
        ACT_ID
    )
) ENGINE=InnoDB;


# テーブル名：作業項目
# テーブルID：WORKITEM
# M/T：T
# 備考：
CREATE TABLE IF NOT EXISTS WORKITEM (
    WORK_ID         VARCHAR(64)     NOT NULL    PRIMARY KEY     COMMENT '作業項目ID',
    PROC_ID         VARCHAR(64)     NOT NULL                    COMMENT 'プロセスインスタンスID',
    ACT_ID          VARCHAR(64)     NOT NULL                    COMMENT 'アクティビティインスタンスID',
    PARTICIPANT_TYPE INTEGER(1)                                 COMMENT 'ワークフロー参加者型',
    PARTICIPANT_NAME VARCHAR(128)                               COMMENT 'ワークフロー参加者名称'
) ENGINE=InnoDB;


# テーブル名：プロセス完了待ちアクティビティ
# テーブルID：WAITPROCACT
# M/T：T
# 備考：
CREATE TABLE IF NOT EXISTS WAITPROCACT (
    PROC_ID         VARCHAR(64)     NOT NULL                    COMMENT 'プロセスインスタンスID',
    ACT_ID          VARCHAR(64)     NOT NULL                    COMMENT '完了待ちアクティビティインスタンスID',
    SUBPROC_ID      VARCHAR(64)     NOT NULL                    COMMENT 'サブプロセスインスタンスID'
) ENGINE=InnoDB;


# テーブル名：並行処理ブロック
# テーブルID：CONCURBLOCK
# M/T：T
# 備考：
CREATE TABLE IF NOT EXISTS CONCURBLOCK (
    BLOCK_ID        VARCHAR(64)     NOT NULL                    COMMENT 'ブロックID',
    UPPER_BLOCK_ID  VARCHAR(64)                                 COMMENT '上位のブロックID',
    PROC_ID         VARCHAR(64)     NOT NULL                    COMMENT 'プロセスインスタンスID',
    ACT_ID          VARCHAR(64)     NOT NULL                    COMMENT 'ブロック開始アクティビティインスタンスID'
) ENGINE=InnoDB;


# テーブル名：アプリケーション実行
# テーブルID：APPEXEC
# M/T：T
# 備考：
CREATE TABLE IF NOT EXISTS APPEXEC (
    APP_NAME        VARCHAR(64)     NOT NULL                    COMMENT 'アプリケーション名',
    TOOL_AGENT      VARCHAR(64)     NOT NULL                    COMMENT 'アプリケーションを起動したツールエージェントのクラス名',
    EXEC_ID         BIGINT(19)      NOT NULL                    COMMENT 'ツールエージェントが発行した実行ID',
    START_DATE      DATETIME                                    COMMENT '開始日時',
    STARTER_ID      VARCHAR(64)                                 COMMENT '実行者',
    END_DATE        DATETIME                                    COMMENT '終了日時',
    APP_STATE       INTEGER(1)                  DEFAULT 2       COMMENT '状態、初期値は2：未開始',
    CONSTRAINT APPEXEC_PK PRIMARY KEY (
        APP_NAME,
        TOOL_AGENT,
        EXEC_ID
    )
) ENGINE=InnoDB;


# テーブル名：プロセス状態変更履歴
# テーブルID：PROCESSHIST
# M/T：T
# 備考：
CREATE TABLE IF NOT EXISTS PROCESSHIST (
    PROC_ID         VARCHAR(64)     NOT NULL                    COMMENT 'プロセスインスタンスID',
    PACKAGE_ID      VARCHAR(64)     NOT NULL                    COMMENT 'アプリケーションを起動したツールエージェントのクラス名',
    PROC_DEF_ID     VARCHAR(64)     NOT NULL                    COMMENT 'プロセス定義ID',
    PREV_STATE      INTEGER(1)                                  COMMENT '更新前の状態',
    NEW_STATE       INTEGER(1)                                  COMMENT '更新後の状態',
    UPDATE_DATE     DATETIME                                    COMMENT '更新日時',
    REASON          VARCHAR(128)                                COMMENT '更新事由'
) ENGINE=InnoDB;


# テーブル名：プロセス変数変更履歴
# テーブルID：VARIABLEHIST
# M/T：T
# 備考：
CREATE TABLE IF NOT EXISTS VARIABLEHIST (
    VAR_ID          VARCHAR(64)     NOT NULL                    COMMENT 'プロセス変数インスタンスID',
    PROC_ID         VARCHAR(64)     NOT NULL                    COMMENT 'プロセスインスタンスID',
    VAR_DEF_ID      VARCHAR(64)     NOT NULL                    COMMENT 'プロセス変数定義ID',
    TYPE            INTEGER(1)      NOT NULL    DEFAULT 0       COMMENT '変数型',
    PREV_VALUE      TEXT                                        COMMENT '更新前の状態',
    NEW_VALUE       TEXT            NOT NULL                    COMMENT '更新後の状態',
    UPDATE_DATE     DATETIME        NOT NULL                    COMMENT '更新日時',
    REASON          VARCHAR(128)                                COMMENT '更新事由',
    ACT_ID          VARCHAR(64)                                 COMMENT '変更アクティビティID'
) ENGINE=InnoDB;


# テーブル名：アクティビティ状態変更履歴
# テーブルID：ACTIVITYHIST
# M/T：T
# 備考：
CREATE TABLE IF NOT EXISTS ACTIVITYHIST (
    PROC_ID         VARCHAR(64)     NOT NULL                    COMMENT 'プロセスインスタンスID',
    ACT_ID          VARCHAR(64)     NOT NULL                    COMMENT 'アクティビティインスタンスID',
    ACT_DEF_ID      VARCHAR(64)     NOT NULL                    COMMENT 'アクティビティ定義ID',
    ACTOR_ID        VARCHAR(64)     NOT NULL                    COMMENT '実行者ID',
    PREV_STATE      INTEGER(1)                                  COMMENT '更新前の状態',
    NEW_STATE       INTEGER(1)      NOT NULL                    COMMENT '更新後の状態',
    UPDATE_DATE     DATETIME        NOT NULL                    COMMENT '更新日時',
    REASON          VARCHAR(128)                                COMMENT '更新事由'
) ENGINE=InnoDB;


# テーブル名：起動先プロセス
# テーブルID：ETAPROCESS
# M/T：T
# 備考：
CREATE TABLE IF NOT EXISTS ETAPROCESS (
    ENGINE_ID       VARCHAR(64)     NOT NULL                    COMMENT '起動先エンジンID',
    PROCESS_ID      VARCHAR(64)     NOT NULL                    COMMENT '起動先プロセスID',
    ROOT_PROC_ID    VARCHAR(64)     NOT NULL                    COMMENT '起動元プロセスID',
    ROOT_ACT_ID     VARCHAR(64)     NOT NULL                    COMMENT '起動元アクティビティID',
    CONSTRAINT ETAPROCESS_PK PRIMARY KEY (
        ENGINE_ID,
        PROCESS_ID
    )
) ENGINE=InnoDB;


# テーブル名：起動元アクティビティ
# テーブルID：ETAACTIVITY
# M/T：T
# 備考：
CREATE TABLE IF NOT EXISTS ETAACTIVITY (
    PROCESS_ID      VARCHAR(64)     NOT NULL    PRIMARY KEY     COMMENT '起動先プロセスID',
    ENGINE_ID       VARCHAR(64)     NOT NULL                    COMMENT '起動元エンジンID',
    ROOT_PROC_ID    VARCHAR(64)     NOT NULL                    COMMENT '起動元プロセスID',
    ROOT_ACT_ID     VARCHAR(64)     NOT NULL                    COMMENT '起動元アクティビティID'
) ENGINE=InnoDB;


# 外部キー制約作成

# 制約名：ORGANIZATION_FK
# 親キー
#   テーブルID：ORGANIZATION
#   項目ID：ORG_ID
# 子キー
#   テーブルID：ORGANIZATION
#   項目ID：HIGHER_ORG_ID
ALTER TABLE ORGANIZATION ADD CONSTRAINT ORGANIZATION_FK
        FOREIGN KEY (HIGHER_ORG_ID)
    REFERENCES 
        ORGANIZATION (ORG_ID);


# 制約名：ORGANIZATION_ORGUSERMAP_FK
# 親キー
#   テーブルID：ORGANIZATION
#   項目ID：ORG_ID
# 子キー
#   テーブルID：ORGUSERMAP
#   項目ID：ORG_ID
ALTER TABLE ORGUSERMAP ADD CONSTRAINT ORGANIZATION_ORGUSERMAP_FK 
        FOREIGN KEY (ORG_ID)
    REFERENCES 
        ORGANIZATION (ORG_ID);


# 制約名：USER_ORGUSERMAP_FK
# 親キー
#   テーブルID：USER
#   項目ID：USER_ID
# 子キー
#   テーブルID：ORGUSERMAP
#   項目ID：USER_ID
ALTER TABLE ORGUSERMAP ADD CONSTRAINT USER_ORGUSERMAP_FK 
        FOREIGN KEY (USER_ID)
    REFERENCES 
        USER (USER_ID);


# 制約名：USER_USERROLEMAP_FK
# 親キー
#   テーブルID：USER
#   項目ID：USER_ID
# 子キー
#   テーブルID：USERROLEMAP
#   項目ID：USER_ID
ALTER TABLE USERROLEMAP ADD CONSTRAINT USER_USERROLEMAP_FK 
        FOREIGN KEY (USER_ID)
    REFERENCES 
        USER (USER_ID);


# 制約名：ROLE_USERROLEMAP_FK
# 親キー
#   テーブルID：ROLE
#   項目ID：ROLE_ID
# 子キー
#   テーブルID：USERROLEMAP
#   項目ID：ROLE_ID
ALTER TABLE USERROLEMAP ADD CONSTRAINT ROLE_USERROLEMAP_FK 
        FOREIGN KEY (ROLE_ID)
    REFERENCES 
        ROLE (ROLE_ID);


# 制約名：ROLE_ORGROLEMAP_FK
# 親キー
#   テーブルID：ROLE
#   項目ID：ROLE_ID
# 子キー
#   テーブルID：ORGROLEMAP
#   項目ID：ROLE_ID
ALTER TABLE ORGROLEMAP ADD CONSTRAINT ROLE_ORGROLEMAP_FK 
        FOREIGN KEY (ROLE_ID)
    REFERENCES 
        ROLE (ROLE_ID);


# 制約名：ORGANIZATION_ORGROLEMAP_FK
# 親キー
#   テーブルID：ORGANIZATION
#   項目ID：ORG_ID
# 子キー
#   テーブルID：ORGROLEMAP
#   項目ID：ORG_ID
ALTER TABLE ORGROLEMAP ADD CONSTRAINT ORGANIZATION_ORGROLEMAP_FK 
        FOREIGN KEY (ORG_ID)
    REFERENCES 
        ORGANIZATION (ORG_ID);


# 制約名：PROCESS_VARIABLE_FK
# 親キー
#   テーブルID：PROCESS
#   項目ID：PROC_ID
# 子キー
#   テーブルID：VARIABLE
#   項目ID：PROC_ID
ALTER TABLE VARIABLE ADD CONSTRAINT PROCESS_VARIABLE_FK 
        FOREIGN KEY (PROC_ID)
    REFERENCES 
        PROCESS (PROC_ID);


# 制約名：PROCESS_ACTIVITY_FK
# 親キー
#   テーブルID：PROCESS
#   項目ID：PROC_ID
# 子キー
#   テーブルID：ACTIVITY
#   項目ID：PROC_ID
ALTER TABLE ACTIVITY ADD CONSTRAINT PROCESS_ACTIVITY_FK 
        FOREIGN KEY (PROC_ID)
    REFERENCES 
        PROCESS (PROC_ID);


# 制約名：ACTIVITY_WORKITEM_FK
# 親キー
#   テーブルID：ACTIVITY
#   項目ID：PROC_ID, ACT_ID
# 子キー
#   テーブルID：WORKITEM
#   項目ID：PROC_ID, ACT_ID
ALTER TABLE WORKITEM ADD CONSTRAINT ACTIVITY_WORKITEM_FK
        FOREIGN KEY (PROC_ID, ACT_ID)
    REFERENCES 
        ACTIVITY (PROC_ID, ACT_ID);


# 制約名：ACTIVITY_CONCURBLOCK_FK
# 親キー
#   テーブルID：ACTIVITY
#   項目ID：PROC_ID, ACT_ID
# 子キー
#   テーブルID：CONCURBLOCK
#   項目ID：PROC_ID, ACT_ID
ALTER TABLE CONCURBLOCK ADD CONSTRAINT ACTIVITY_CONCURBLOCK_FK
        FOREIGN KEY (PROC_ID, ACT_ID)
    REFERENCES 
        ACTIVITY (PROC_ID, ACT_ID);


# 制約名：ACTIVITY_WAITPROCACT_FK
# 親キー
#   テーブルID：ACTIVITY
#   項目ID：PROC_ID, ACT_ID
# 子キー
#   テーブルID：WAITPROCACT
#   項目ID：PROC_ID, ACT_ID
ALTER TABLE WAITPROCACT ADD CONSTRAINT ACTIVITY_WAITPROCACT_FK
        FOREIGN KEY (PROC_ID, ACT_ID)
    REFERENCES 
        ACTIVITY (PROC_ID, ACT_ID);
