/* $Id: AppConfirmAction.java,v 1.16 2005/08/26 04:45:18 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.sample.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.argo21.nautica.workflow.sample.actionform.AppOvertimeInBean;
import jp.co.argo21.nautica.workflow.sample.actionform.ApplicationContentBean;
import jp.co.argo21.nautica.workflow.sample.actionform.ApplicationFormInBean;
import jp.co.argo21.nautica.workflow.sample.actionform.BeanFactory;
import jp.co.argo21.nautica.workflow.sample.actionform.TimeBean;
import jp.co.argo21.nautica.workflow.sample.actionform.UserBean;
import jp.co.argo21.nautica.workflow.sample.model.AppKind;
import jp.co.argo21.nautica.workflow.sample.model.Application;
import jp.co.argo21.nautica.workflow.sample.model.OvertimeApp;
import jp.co.argo21.nautica.workflow.sample.model.dao.ApplicationDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.DAOFactory;
import jp.co.argo21.nautica.workflow.sample.util.ResourceManager;
import jp.co.argo21.nautica.workflow.sample.util.Constants;
import jp.co.argo21.nautica.workflow.sample.util.Validator;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * \͉ʂŊmF{^̏sANVNXB
 * 
 * @author  ruchida(Argo 21, Corp.)
 * @version $Revision: 1.16 $
 * @since   Nautica Workflow 0.9
 */
public class AppConfirmAction extends Action {

    /**
     * \emFsB
     * 
     * @param mapping ANV}bsO
     * @param form ANVtH[
     * @param request NGXg
     * @param response X|X
     * @return ANVtH[h
     */
    public ActionForward execute(
            ActionMapping mapping,
            ActionForm form,
            HttpServletRequest request,
            HttpServletResponse response)
    {
        // NGXgEZbV\ʁA[UA\ԍ擾
        ApplicationFormInBean formbean = (ApplicationFormInBean)form;
        AppKind appkind = (AppKind)request.getSession().getAttribute("appkind");
        UserBean userbean = (UserBean) request.getSession().getAttribute("user");
        String appID = (String)request.getSession().getAttribute("appid");
        
        // \ɃNGXg瓾lݒ
        BeanFactory beanfactory = BeanFactory.getInstance(appkind.getAppkindID());
        Application model = beanfactory.getModel(formbean);
        model.setKind(appkind);
        model.setUserid(userbean.getUserID());
        model.setUser(userbean.getUser());
        model.setId(appID);
        
        // ͂ꂽl`FbN
        List errMsgs = new ArrayList();
        ResourceManager rm = ResourceManager.getInstance();
        if ( (AppKind.OVERTIME_APPLICATION_ID).equals((appkind.getAppkindID())) ) {
            AppOvertimeInBean overtimeBean = (AppOvertimeInBean)formbean;
            OvertimeApp overtimeApp = (OvertimeApp) model;
            
            int startHour = overtimeApp.getStartHour();
            int startMin = overtimeApp.getStartMin();
            int endHour = overtimeApp.getEndHour();
            int endMin = overtimeApp.getEndMin();
            float overtimeHours = overtimeApp.getOvertimeHours();
            float hour = endHour - startHour;
            int min = endMin - startMin;
            if (min == 30) hour += 0.5; 
            
            // I\莞Jn\莞ꍇ̓G[
            if (startHour > endHour) {
                errMsgs.add(rm.getValue("error.time"));
            } else if (startHour == endHour) {
                // Jn\莞ƏI\莞̊Ԋu30̏ꍇ̓G[
                if ((endMin - startMin) < 30 ) errMsgs.add(rm.getValue("error.time"));
            } else {
                // \莞30ԊuŎw肳ĂȂꍇ̓G[
                if (min != 30 && min != 0 && min != -30) errMsgs.add(rm.getValue("error.time"));
            }
            
            // \莞Ԃ\莞I[o[ꍇ̓G[
            if (hour < overtimeHours) errMsgs.add(rm.getValue("error.hour"));
                        
            // Ȑꍇ̓G[
            if (Validator.isEmpty(overtimeBean.getReason())) {
                errMsgs.add(rm.getValue("app.overtime.reason") + rm.getValue("error.empty"));
            }
        }
        
        // G[ꍇA\͉ʂɑJڂAG[\B
        if (errMsgs.size() != 0) {
            request.setAttribute("errorMsg", errMsgs.toArray());
            request.setAttribute("time", TimeBean.getCurrentTimeBean());
            return mapping.findForward(Constants.ERROR);
        }
        
        try {
            // \e\e[uɓo^
            ApplicationDAO appDao = DAOFactory.getApplicationDAO();
            appDao.updateApplication(model);
            ApplicationDAO appKindDao = DAOFactory.getApplicationDAOFromAppKindID(appkind.getAppkindID());
            appKindDao.updateApplication(model);
            
            // ʕ\p̃f𐶐
            ApplicationContentBean contentBeanFromModel = beanfactory.getContentBeanFromModel(model);
            
            // NGXgAZbVɐ\eݒ
            request.setAttribute("app", contentBeanFromModel);
            request.getSession().setAttribute("appmodel", model);
            
            return mapping.findForward(Constants.SUCCESS);
            
        } catch (SQLException e) {
            // ZbV
            request.getSession().invalidate();
            // vIG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        } catch (Exception e) {
            // ZbV
            request.getSession().invalidate();
            // \ʃG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.UNEXPECTED_ERROR);
        }
    }
}