/* $Id: AppContinueAction.java,v 1.8 2005/08/26 04:45:14 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.sample.action;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.rpc.ServiceException;

import jp.co.argo21.nautica.workflow.sample.actionform.UserBean;
import jp.co.argo21.nautica.workflow.sample.model.AppTransaction;
import jp.co.argo21.nautica.workflow.sample.model.dao.AppTransactionDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.DAOFactory;
import jp.co.argo21.nautica.workflow.sample.util.ResourceManager;
import jp.co.argo21.nautica.workflow.sample.util.SingletonServices;
import jp.co.argo21.nautica.workflow.sample.util.StatusConstants;
import jp.co.argo21.nautica.workflow.sample.util.Constants;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.soap.WorkItemHandler;
import jp.co.argo21.nautica.workflow.soap.WorkflowEngineHandler;
import jp.co.argo21.nautica.workflow.soap.message.Attribute;
import jp.co.argo21.nautica.workflow.soap.message.Filter;
import jp.co.argo21.nautica.workflow.soap.message.WorkItem;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * \e͑҂ꗗN̏sANVNXB
 * 
 * @author  ruchida(Argo 21, Corp.)
 * @version $Revision: 1.8 $
 * @since   Nautica Workflow 0.9
 */
public class AppContinueAction extends Action {
    
    /**
     * \e͑҂ꗗ擾B
     * 
     * @param mapping ANV}bsO
     * @param form ANVtH[
     * @param request NGXg
     * @param response X|X
     * @return ANVtH[h
     */
    public ActionForward execute(
            ActionMapping mapping,
            ActionForm form,
            HttpServletRequest request,
            HttpServletResponse response)
    {
        // NGXg烆[U擾
        UserBean user = (UserBean) request.getSession().getAttribute("user");
        String sessionID = user.getSessionID();
        
        try {
            WorkItemHandler workItemHandler = SingletonServices.getInstance().getWfWorkitemHandler();
            WorkflowEngineHandler wfEngineHandler = SingletonServices.getInstance().getWfEngineHandler();

            // vZXϐ[]"APPLY_WAIT"ݒ
            Filter[] filters = new Filter[1];
            Filter status = new Filter();
            status.setType(5003); 
            status.setFilterName(Constants.STATUS); 
            status.setFilterString(StatusConstants.APPLY_WAIT);
            status.setComparison(1);
            filters[0] = status;
            
            // vZXϐ[]"APPLY_WAIT"łƍڂ擾
            WorkItem[] items = workItemHandler.getWorkItems(sessionID, filters);
            
            // ƍIDAvZXϐ[\ԍ]擾A
            // \ԍƃ[UIDŐ\gUNVe[u
            List appTransList = new ArrayList();
            for (int i=0; i<items.length; i++) {
                String pid = items[i].getProcessID();
                Attribute attr 
                    = wfEngineHandler.getProcessAttributeValue(sessionID, pid, Constants.APPLICATION_NO);
                AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
                AppTransaction appTrans 
                    = appTransDao.getAppTransactionForContinue(attr.getValue(), user.getUserID());
                if (appTrans != null) {
                    // [UID烆[U擾AppTransactionIuWFNgXV
                    String appUserID = appTrans.getAppUserID();
                    User appUser = SingletonServices.getInstance().getUserManager().getUser(appUserID);
                    appTrans.setAppUserID(appUser.getName());
                    appTransList.add(appTrans);
                }
            }
            
            if (appTransList.size() == 0) {
                // Ɖ\ȍڂȂ
                List errMsgs = new ArrayList();
                ResourceManager rm = ResourceManager.getInstance();
                errMsgs.add(rm.getValue("error.noapp"));
                request.setAttribute("errorMsg", errMsgs.toArray());
                return mapping.findForward(Constants.ERROR);
            }
            
            request.setAttribute("apptransactions",
                    appTransList.toArray(new AppTransaction[appTransList.size()]));
            
            return mapping.findForward(Constants.SUCCESS);
        } catch (SQLException e) {
            // ZbV
            request.getSession().invalidate();
            // vIG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        } catch (RemoteException e) {
            // ZbV
            request.getSession().invalidate();
            // vIG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        } catch (ServiceException e) {
            // ZbV
            request.getSession().invalidate();
            // vIG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        } catch (Exception e) {
            // ZbV
            request.getSession().invalidate();
            // \ʃG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.UNEXPECTED_ERROR);
        }
    }
}