/* $Id: ApprovalSelectionAction.java,v 1.10 2005/08/26 04:45:13 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.sample.action;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.argo21.nautica.workflow.sample.actionform.ApplicationContentBean;
import jp.co.argo21.nautica.workflow.sample.actionform.BeanFactory;
import jp.co.argo21.nautica.workflow.sample.model.Application;
import jp.co.argo21.nautica.workflow.sample.model.dao.DAOFactory;
import jp.co.argo21.nautica.workflow.sample.util.Constants;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * F҂ꗗʂŐ\ԍ̃N̏sANVNXB
 * 
 * @author  ruchida(Argo 21, Corp.)
 * @version $Revision: 1.10 $
 * @since   Nautica Workflow 0.9
 */
public class ApprovalSelectionAction extends Action {

    /**
     * F\e擾B
     * 
	 * @param mapping ANV}bsO
	 * @param form ANVtH[
	 * @param request NGXg
	 * @param response X|X
	 * @return ANVtH[h
	 */
	public ActionForward execute(
            ActionMapping mapping,
            ActionForm form,
            HttpServletRequest request,
            HttpServletResponse response)
    {
        
        // NGXg\ԍƍƍID擾
        String appID = request.getParameter("appid");
        Map wids = (HashMap) request.getSession().getAttribute("wids");
        String wid = (String) wids.get(appID);
        
        try {
            // \ԍɁAʃe[u\̓e擾
            Application app = DAOFactory.getApplicationDAO().getApplicationByID(appID);
            
            // ʕ\p̃f𐶐
            BeanFactory beanfactory = BeanFactory.getInstance(app.getKind().getAppkindID());
            ApplicationContentBean contentBeanFromModel = beanfactory.getContentBeanFromModel(app);
            
            request.setAttribute("app", contentBeanFromModel);
            request.getSession().setAttribute("appmodel", app);
            request.getSession().setAttribute("wid", wid);
            
            return mapping.findForward(Constants.SUCCESS);
        } catch (SQLException e) {
            // ZbV
            request.getSession().invalidate();
            // vIG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        } catch (Exception e) {
            // ZbV
            request.getSession().invalidate();
            // \ʃG[
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.UNEXPECTED_ERROR);
        }
    }
}