/* $Id: ShowNotifyListAction.java,v 1.7 2005/08/26 04:45:12 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.sample.action;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.rpc.ServiceException;

import jp.co.argo21.nautica.workflow.sample.actionform.UserBean;
import jp.co.argo21.nautica.workflow.sample.model.Application;
import jp.co.argo21.nautica.workflow.sample.model.dao.DAOFactory;
import jp.co.argo21.nautica.workflow.sample.util.ResourceManager;
import jp.co.argo21.nautica.workflow.sample.util.SingletonServices;
import jp.co.argo21.nautica.workflow.sample.util.StatusConstants;
import jp.co.argo21.nautica.workflow.sample.util.Constants;
import jp.co.argo21.nautica.workflow.soap.WorkItemHandler;
import jp.co.argo21.nautica.workflow.soap.message.Filter;
import jp.co.argo21.nautica.workflow.soap.message.WorkItem;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * \ꗗ\ANVNXB
 * 
 * @author  ruchida(Argo 21, Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public class ShowNotifyListAction extends Action {
    
    /**
     * \ꗗ\sB
     * 
	 * @param mapping ANV}bsO
	 * @param form ANVtH[
	 * @param request NGXg
	 * @param response X|X
	 * @return ANVtH[h
     */
    public ActionForward execute(
            ActionMapping mapping,
            ActionForm form,
            HttpServletRequest request,
            HttpServletResponse response )
    {        
        // NGXg烆[U擾
        UserBean userbean = (UserBean)request.getSession().getAttribute("user");
        String sessionID = userbean.getSessionID();
        List errMsgs = new ArrayList();
        ResourceManager rm = ResourceManager.getInstance();
        
        try {
            // vZXϐ[]"CONFIRM_WAIT"Ɉv郏[NACẽXg擾
            WorkItemHandler itemhandler = SingletonServices.getInstance().getWfWorkitemHandler();
            Filter[] filters = new Filter[1];
    		Filter filter = new Filter();
    		filter.setType(5003); 
    		filter.setFilterName(Constants.STATUS); 
    		filter.setFilterString(StatusConstants.CONFIRM_WAIT);
    		filter.setComparison(1); 
    		filters[0] = filter;		
    		WorkItem[] items = itemhandler.getWorkItems(sessionID, filters);
    		
            Hashtable wids = new Hashtable();        
            List appList = new ArrayList();
            for (int i = 0; i < items.length; i++) {
                String wid = items[i].getID();
    			String appID = itemhandler.getWorkItemAttributeValue(sessionID, wid, Constants.APPLICATION_NO).getValue();
    			Application app = DAOFactory.getApplicationDAO().getApplicationByID(appID);
    			appList.add(app);
    			wids.put(appID, wid);
    		}
            
            if (appList.size() == 0) {
                // ł̊mFKvȐ\Ȃ
                errMsgs.add(rm.getValue("error.nolist"));
                request.setAttribute("errorMsg" , errMsgs.toArray());
                return mapping.findForward(Constants.ERROR);
            }
            
    		Application[] application = (Application[]) appList.toArray(new Application[appList.size()]);
    		
    		request.getSession().setAttribute("getwid", wids);
    		request.setAttribute("applications", application);
            return mapping.findForward(Constants.SUCCESS);
            
        } catch (SQLException e) {
            // ZbV
            request.getSession().invalidate();
            // R[h̎擾Ɏs
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        } catch (ServiceException e) {
            // ZbV
            request.getSession().invalidate();
            // GWڑɎsi[NACenh擾sj
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        } catch (RemoteException e) {
            // ZbV
            request.getSession().invalidate();
            // GWڑɎsi[NACeE[NACe擾sj
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.FATAL_ERROR);
        } catch (Exception e) {
            // ZbV
            request.getSession().invalidate();
            // \ʃG[ʂ֑J
            request.setAttribute("errMsg", e.toString());
            request.setAttribute("err", e.getStackTrace());
            return mapping.findForward(Constants.UNEXPECTED_ERROR);
        }
    }
}