/* $Id: BeanFactory.java,v 1.5 2005/08/26 04:45:32 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.sample.actionform;

import jp.co.argo21.nautica.workflow.sample.model.AppKind;
import jp.co.argo21.nautica.workflow.sample.model.Application;

/**
 * ContentBeanFormBeañt@NgNXB
 * 
 * @author  ruchida(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 * 
 */
public abstract class BeanFactory {

    /**
     * w肳ꂽ\ʂ̃CX^XԂB
     * 
     * @param appKindID \ʃR[h
     * @return Beant@Ng
     */
    public static BeanFactory getInstance(String appKindID) {
        if (appKindID.equals(AppKind.OVERTIME_APPLICATION_ID)) {
            return new OvertimeAppBeanFactory();
        }
        return null;        
    }
    
    /**
     * w肳ꂽFormBean̐\ԂB
     * 
     * @param bean FormBean
     * @return \
     */
    public Application getModel(ApplicationFormInBean bean) {
        return bean.getModel();
    }
    
    /**
     * w肳ꂽ\ContentBeanԂB
     * 
     * @param app \
     * @return ContentBean
     */
    public abstract ApplicationContentBean getContentBeanFromModel(Application app);
    
    /**
     * w肳ꂽ\̃tH[FormBeanԂB
     * 
     * @param app \
     * @return FormBean
     */
    public abstract ApplicationFormInBean getFormBeanFromModel(Application app);
    
}
