/* $Id: AppTransactionDAO.java,v 1.16 2005/08/26 04:45:39 ysahara Exp $
*
* Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
*/
package jp.co.argo21.nautica.workflow.sample.model.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

import jp.co.argo21.nautica.workflow.sample.model.AppKind;
import jp.co.argo21.nautica.workflow.sample.model.AppTransaction;
import jp.co.argo21.nautica.workflow.sample.util.ResourceManager;
import jp.co.argo21.nautica.workflow.sample.util.SingletonServices;
import jp.co.argo21.nautica.workflow.sample.util.StatusConstants;
import jp.co.argo21.nautica.workflow.security.Organization;
import jp.co.argo21.nautica.workflow.security.Role;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.security.simple.OrganizationManagerRemote;
import jp.co.argo21.nautica.workflow.security.simple.RoleManagerRemote;
import jp.co.argo21.nautica.workflow.security.simple.UserManagerRemote;

/**
 * \gUNVe[uɑ΂ANZXsNXB
 * 
 * @author  ruchida(Argo 21, Corp.)
 * @version $Revision: 1.16 $
 * @since   Nautica Workflow 0.9
 */
public class AppTransactionDAO {
    
    public static final String APP_ID             = "APP_ID";
    public static final String APPROVE_ACCOUNT_ID = "APPROVE_ACCOUNT_ID";
    public static final String APPKIND_ID         = "APPKIND_ID";
    public static final String APP_STATUS         = "APP_STATUS";
    public static final String APP_USER_ID        = "APP_USER_ID";
    public static final String APP_ROLE_ID        = "APP_ROLE_ID";
    public static final String COMMENT            = "COMMENT";
    public static final String DATE               = "DATE";
    
    // [
    private static final String KACHO_ROLE        = "KACHO_ROLE";
    private static final String BUCHO_ROLE        = "BUCHO_ROLE";
    public static final String JINJI_KACHO_ROLE  = "JINJI_KACHO_ROLE";
    public static final String JINJI_BUCHO_ROLE  = "JINJI_BUCHO_ROLE";
    public static final String JINJI_ROLE         = "JINJI_ROLE";
    
    // \[X}l[W
    private static ResourceManager locator = ResourceManager.getInstance();
    
    // ԊO\p̃R[hǉ邽߂SQL
    private static final String SQL_INSERT_FOR_OVERTIME
        = "insert into APPTRANSACTION (" +
                "APP_ID, APPROVE_ACCOUNT_ID, APPKIND_ID, APP_STATUS, " +
                "APP_USER_ID, APP_ROLE_ID) values (?,?,?,?,?,?) ";
    
    // \ԍŃR[h擾邽߂SQL
    private static final String SQL_SELECT_BY_APP_ID
        = "select * from APPTRANSACTION where APP_ID = ?";
    
    // \ԍƃ[UIDŃR[h擾邽߂SQL
    private static final String SQL_SELECT_BY_APPID_AND_USERID
        = "select * from APPTRANSACTION where APP_ID = ? and APP_USER_ID = ?";
    
    // \ԍƃ[IDŃR[h擾邽߂SQL
    private static final String SQL_SELECT_BY_APPID_AND_ROLEID
        = "select * from APPTRANSACTION where APP_ID = ? and APP_ROLE_ID = ?";
    
    // \ԍƏFubNԍŃR[h擾邽߂SQL
    private static final String SQL_SELECT_BY_APPID_AND_ACCOUNT_ID
        = "select * from APPTRANSACTION where APP_ID = ? and APPROVE_ACCOUNT_ID = ?";
    
    // [UIDŃR[h擾邽߂SQL
    private static final String SQL_SELECT_BY_USER_ID
        = "select * from APPTRANSACTION where APP_USER_ID = ?";
    
    // [IDŃR[h擾邽߂SQL
    private static final String SQL_SELECT_BY_ROLE_ID
        = "select * from APPTRANSACTION where APP_ROLE_ID = ? AND APP_USER_ID = ''";
    
    // \e͑҂̃R[h擾邽߂SQL
    private static final String SQL_SELECT_FOR_CONTINUE
        = "select * from APPTRANSACTION A  " +
                "where A.APP_ID = ? " +
                "and A.APPROVE_ACCOUNT_ID = 0 " +
                "and A.APP_USER_ID = ? " +
                "and A.APP_STATUS = '҂' " +
                "union " +
                "select B.* from APPTRANSACTION A join APPTRANSACTION B on A.APP_ID = B.APP_ID " +
                "where A.APP_ID = ? " +
                "and A.APPROVE_ACCOUNT_ID = 0 " +
                "and A.APP_USER_ID = ? " +
                "and B.APP_ID = ? " +
                "and B.APP_STATUS = '߂'";
    
    // R[hXV邽߂SQL
    private static final String SQL_UPDATE
        = "update APPTRANSACTION set APP_STATUS = ?, APP_USER_ID = ?, " +
                "APP_ROLE_ID = ?, COMMENT = ?, DATE = ?" +
                "where APP_ID = ? and APPROVE_ACCOUNT_ID = ?";
    
    // Xe[^XXV邽߂SQL
    private static final String SQL_UPDATE_STATUS
        = "update APPTRANSACTION set APP_STATUS = ?" +
                "where APP_ID = ? and APPROVE_ACCOUNT_ID = ?";
    
    // \ԍŃR[h폜邽߂SQL
    private static final String SQL_DELETE
        = "delete from APPTRANSACTION where APP_ID = ?";
        
    /**
     * w肵\ԍR[h폜B
     * 
     * @param appID \ԍ
     * @throws SQLException CӂSQLO
     */
    public void remove(String appID) throws SQLException {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_DELETE);
        try {
            statement.setString(1, appID);
            statement.execute();
        } finally {
            locator.closeConnection(conn, statement);
        }
    }
    
    /**
     * ԊOJ\p̃R[hǉB
     * 
     * @param appID \ԍ
     * @param appKindID \ʃR[h
     * @param userID [UID
     * @throws Exception Cӂ̗O
     */
    public void insertForOverTime(String appID, String appKindID, String userID) throws Exception {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_INSERT_FOR_OVERTIME);
        try {
            AppKindDAO appKindDao = DAOFactory.getAppKindDAO();
            int approveAccount = appKindDao.getApproveAccount(appKindID);
            int confirmAccount = appKindDao.getConfirmAccount(appKindID);
            
            List approvers = new ArrayList();
            approvers = getApprovalID(userID);
            for (int i=0; i < approveAccount; i++) {
                statement.setString(1, appID);
                statement.setInt(2, i);
                statement.setString(3, appKindID);
                
                if (i == 0) {
                    statement.setString(4, StatusConstants.STATUS_TRANS_WAIT);
                    statement.setString(5, userID);
                    statement.setString(6, "");
                } else if (i == 1) {
                    statement.setString(4, StatusConstants.STATUS_TRANS_NOT_REACH);
                    statement.setString(5, (String) approvers.get(0));
                    statement.setString(6, "");
                } else if (i == 2) {
                    statement.setString(4, StatusConstants.STATUS_TRANS_NOT_REACH);
                    statement.setString(5, (String) approvers.get(1));
                    statement.setString(6, "");
                } else if (i == 3) {
                    statement.setString(4, StatusConstants.STATUS_TRANS_NOT_REACH);
                    statement.setString(5, "");
                    statement.setString(6, (String) approvers.get(2));
                }
                statement.execute();
            }
            
            List confirmers = new ArrayList();
            confirmers = getConfirmID(userID);
            for (int i = approveAccount; i < approveAccount+confirmAccount; i++) {
                statement.setString(1, appID);
                statement.setInt(2, i);
                statement.setString(3, appKindID);
                
                if (i == 4) {
                    statement.setString(4, StatusConstants.STATUS_TRANS_CONFIRM);
                    statement.setString(5, (String) confirmers.get(0));
                    statement.setString(6, "");
                } else if (i == 5) {
                    statement.setString(4, StatusConstants.STATUS_TRANS_CONFIRM);
                    statement.setString(5, (String) confirmers.get(1));
                    statement.setString(6, "");
                }
                statement.execute();
            }
        } finally {
            locator.closeConnection(conn, statement);
        }
    }
    
    /**
     * F҃[UID܂̓[IDԂB
     * 
     * @param userID [UID
     * @return F҃[UIDꗗ
     * @throws Exception Cӂ̗O
     */
    private List getApprovalID(String userID) throws Exception {
        UserManagerRemote umr = SingletonServices.getInstance().getUserManager();
        OrganizationManagerRemote omr = SingletonServices.getInstance().getOrganizationManager();
        RoleManagerRemote rmr = SingletonServices.getInstance().getRoleManager();
        User user = umr.getUser(userID);
        Organization[] orgs = omr.getOrganizationByUser(user);
        
        // iiےj[UIDZbg
        List approvers = new ArrayList();
        Role kachoRole = rmr.getRole(KACHO_ROLE);
        User[] users = rmr.getUsersByRole(kachoRole);
        for (int i = 0; i < users.length; i++) {
            Organization[] kachoOrgs = omr.getOrganizationByUser(users[i]);
            if (kachoOrgs[0].getID().equals(orgs[0].getID())) {
                approvers.add(users[i].getID());
                break;
            }
        }
        
        // [UIDZbg
        Role buchoRole = rmr.getRole(BUCHO_ROLE);
        User[] buchoUsers = rmr.getUsersByRole(buchoRole);
        Organization higherOrg = omr.getHigherOrganization(orgs[0]);
        for (int i = 0; i < buchoUsers.length; i++) {
            User[] higherUsers = omr.getAssignedUser(higherOrg);
            for (int j = 0; j < higherUsers.length; j++) {
                if (buchoUsers[i].getID().equals(higherUsers[j].getID())) {
                    approvers.add(buchoUsers[i].getID());
                    break;
                }
            }
        }
        
        // lZbg
        approvers.add(JINJI_ROLE);
        
        return approvers;
    }
    
    /**
     * ҃[UIDԂB
     * 
     * @param userID [UID
     * @return ҃[UID̈ꗗ
     * @throws Exception Cӂ̗O
     */
    private List getConfirmID (String userID) throws Exception {
        List confirmers = new ArrayList();
        RoleManagerRemote rmr = SingletonServices.getInstance().getRoleManager();
                
        // ҃[UIDZbg
        Role jinjiKachoRole = rmr.getRole(JINJI_KACHO_ROLE);
        User[] jinjiKacho = rmr.getUsersByRole(jinjiKachoRole);
        confirmers.add(jinjiKacho[0].getID());
        Role jinjiBuchoRole = rmr.getRole(JINJI_BUCHO_ROLE);
        User[] jinjiBucho = rmr.getUsersByRole(jinjiBuchoRole);
        confirmers.add(jinjiBucho[0].getID());
        
        return confirmers;
    }
    
    /**
     * \ԍŎ擾R[hԂB
     * 
     * @param appID \ԍ
     * @return \gUNVIuWFNgꗗ
     * @throws Exception Cӂ̗O
     */
    public AppTransaction[] getAppTransactionsByAppID (String appID) throws Exception {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_SELECT_BY_APP_ID);
        try {
            statement.setString(1, appID);
            ResultSet rs = statement.executeQuery();
            
            ArrayList result = new ArrayList();
            while(rs.next()) {
                AppTransaction kind = createAppTransFromRecord(rs);
                if (kind!=null)
                    result.add(kind);
            }
            return (AppTransaction[]) result.toArray(new AppTransaction[result.size()]);
            
        } finally {
            locator.closeConnection(conn, statement);
        }
    }
    
    /**
     * w肳ꂽ[Ut[ɎQĂ郌R[hԂB
     * 
     * @param userID [UID
     * @return \gUNVIuWFNgꗗ
     * @throws Exception Cӂ̗O
     */
    public AppTransaction[] getAppTransactionsByUserID (String userID) throws Exception {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_SELECT_BY_USER_ID);
        try {
            statement.setString(1, userID);
            ResultSet rs = statement.executeQuery();
            
            ArrayList result = new ArrayList();
            while(rs.next()) {
                AppTransaction kind = createAppTransFromRecord(rs);
                if (kind!=null)
                    result.add(kind);
            }
            return (AppTransaction[]) result.toArray(new AppTransaction[result.size()]);
            
        } finally {
            locator.closeConnection(conn, statement);
        }
    }
    
    /**
     * w肳ꂽ[t[ɎQĂ郌R[hԂB
     * 
     * @param roleID [ID
     * @return \gUNVIuWFNgꗗ
     * @throws Exception Cӂ̗O
     */
    public AppTransaction[] getAppTransactionsByRoleID (String roleID) throws Exception {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_SELECT_BY_ROLE_ID);
        try {
            statement.setString(1, roleID);
            ResultSet rs = statement.executeQuery();
            
            ArrayList result = new ArrayList();
            while(rs.next()) {
                AppTransaction kind = createAppTransFromRecord(rs);
                if (kind!=null)
                    result.add(kind);
            }
            return (AppTransaction[]) result.toArray(new AppTransaction[result.size()]);
            
        } finally {
            locator.closeConnection(conn, statement);
        }
    }
    
    /**
     * \ԍƃ[UIDŎ擾R[hԂB
     * 
     * @param appID \ԍ
     * @param userID [UID
     * @return \gUNVIuWFNg
     * @throws Exception Cӂ̗O
     */
    public AppTransaction getAppTransactionByAppIDUserID (String appID, String userID) throws Exception {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_SELECT_BY_APPID_AND_USERID);
        try {
            statement.setString(1, appID);
            statement.setString(2, userID);
            ResultSet rs = statement.executeQuery();
            AppTransaction appt = null;
            while (rs.next()) {
                appt = createAppTransFromRecord(rs);
            }
            return appt;
            
        } finally {
            locator.closeConnection(conn, statement);
        }
    }
    
    /**
     * \ԍƃ[IDŎ擾R[hԂB
     * 
     * @param appID \ԍ
     * @param roleID [ID
     * @return \gUNVIuWFNg
     * @throws SQLException CӂSQLO
     */
    public AppTransaction getAppTransactionByAppIDRoleID (String appID, String roleID) throws SQLException {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_SELECT_BY_APPID_AND_ROLEID);
        try {
            statement.setString(1, appID);
            statement.setString(2, roleID);
            ResultSet rs = statement.executeQuery();
            AppTransaction appt = null;
            while (rs.next()) {
                appt = createAppTransFromRecord(rs);
            }
            return appt;
            
        } finally {
            locator.closeConnection(conn, statement);
        }
    }
    
    /**
     * \gUNV𐶐B
     * 
     * @param rs UgZbg
     * @return \gUNV
     * @throws SQLException CӂSQLO
     */
    private AppTransaction createAppTransFromRecord(ResultSet rs) throws SQLException {
        String appID = rs.getString(APP_ID);
        int approveAccountID = rs.getInt(APPROVE_ACCOUNT_ID);
        String appKindID = rs.getString(APPKIND_ID);
        String appStatus = rs.getString(APP_STATUS);
        String appUserID = rs.getString(APP_USER_ID);
        String appRoleID = rs.getString(APP_ROLE_ID);
        String comment = rs.getString(COMMENT);
        Timestamp date = rs.getTimestamp(DATE);
        
        AppTransaction appt = new AppTransaction();
        appt.setAppID(appID);
        appt.setApproveAccountID(approveAccountID);
        appt.setAppKindID(appKindID);
        appt.setAppUserID(appUserID);
        appt.setAppRoleID(appRoleID);
        appt.setAppStatus(appStatus);
        appt.setComment(comment);
        appt.setDate(date);
        
        AppKind appKindFromID = DAOFactory.getAppKindDAO().getAppKindFromID(appKindID);
        appt.setAppkind(appKindFromID);
        
        return appt;
    }
    
    /**
     * \e͑҂̐\gUNVԂB
     * 
     * @param appid \ԍ
     * @param userID [UID
     * @return \gUNV
     * @throws Exception Cӂ̗O
     */
    public AppTransaction getAppTransactionForContinue(String appID, String userID) throws Exception {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_SELECT_FOR_CONTINUE);
        try {
            statement.setString(1, appID);
            statement.setString(2, userID);
            statement.setString(3, appID);
            statement.setString(4, userID);
            statement.setString(5, appID);
            ResultSet rs = statement.executeQuery();
            
            AppTransaction appTrans = null;
            while (rs.next()) {
                appTrans = createAppTransFromRecord(rs);
            }            
            return appTrans;
        } finally {
            locator.closeConnection(conn, statement);
        }
    }

    /**
     * \gUNVXVB
     * 
     * @param appTrans \gUNV
     * @throws SQLException CӂSQLO
     */
    public void updateAppTransaction(AppTransaction appTrans) throws SQLException {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_UPDATE);
        try {
            statement.setString(1, appTrans.getAppStatus());
            statement.setString(2, appTrans.getAppUserID());
            statement.setString(3, appTrans.getAppRoleID());
            statement.setString(4, appTrans.getComment());
            statement.setTimestamp(5, appTrans.getDate());
            statement.setString(6, appTrans.getAppID());
            statement.setInt(7, appTrans.getApproveAccountID());
            statement.executeUpdate();
            
        } finally {
            locator.closeConnection(conn, statement);
        }
    }
    
    /**
     * Xe[^XXVB
     * 
     * @param appTrans \gUNV
     * @throws SQLException CӂSQLO
     */
    public void updateStatus(AppTransaction appTrans) throws SQLException {
        Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_UPDATE_STATUS);
        try {
            statement.setString(1, appTrans.getAppStatus());
            statement.setString(2, appTrans.getAppID());
            statement.setInt(3, appTrans.getApproveAccountID());
            statement.executeUpdate();
            
        } finally {
            locator.closeConnection(conn, statement);
        }
    }

	/**
	 * \ԍƏFubNԍŎ擾R[hԂB
     * 
	 * @param appID \ԍ
	 * @param blockID FubNԍ
	 * @return \gUNVIuWFNg
     * @throws Exception Cӂ̗O
	 */
	public AppTransaction getAppTransactionByAppIDBlockID(String appID, int blockID) 
        throws Exception
    {
	    Connection conn = locator.getConnection();
        PreparedStatement statement = conn.prepareStatement(SQL_SELECT_BY_APPID_AND_ACCOUNT_ID);
        try {
            statement.setString(1, appID);
            statement.setInt(2, blockID);
            ResultSet rs = statement.executeQuery();
            AppTransaction appTras= null;
            while(rs.next()) {
                appTras = createAppTransFromRecord(rs);
            }
            return appTras;
        } finally {
            locator.closeConnection(conn, statement);
        }
	}
	
}
