/*
 * Decompiled with CFR 0.152.
 */
package jp.common.navigate;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.dnd.DropTarget;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jp.common.JpDetailBean;
import jp.common.ProxyUnit;
import jp.common.UnitBaseImpl;
import jp.common.common;
import jp.common.info.UnitInfoData;
import jp.common.info.UnitInformation;
import jp.common.navigate.NaviGateDefaultPanel;

public class InfomationPanel
extends NaviGateDefaultPanel
implements TreeSelectionListener {
    HashMap<String, DefaultMutableTreeNode> nodeMap = new HashMap();
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode("jp");
    private DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
    private Object[] rowData = new Object[2];
    private String viewTreePath = "";
    private final JTable unitInfomation = new JTable();

    public InfomationPanel() {
        this.setLayout(new BorderLayout());
        JTree treeUnit = new JTree(this.treeModel);
        treeUnit.addTreeSelectionListener(this);
        treeUnit.setRootVisible(true);
        new DropTarget(treeUnit, this);
        JScrollPane scrPane = new JScrollPane();
        scrPane.getViewport().setView(treeUnit);
        scrPane.setPreferredSize(new Dimension(200, 150));
        JPanel pnlWestSouth = new JPanel();
        pnlWestSouth.setLayout(new BorderLayout());
        JLabel lblUnit = new JLabel("\u30c4\u30ea\u30fc\u69cb\u9020");
        pnlWestSouth.add("Center", lblUnit);
        pnlWestSouth.add("South", scrPane);
        this.add("North", pnlWestSouth);
        JPanel pnlWestTable = new JPanel();
        pnlWestTable.setLayout(new BorderLayout());
        pnlWestTable.setSize(10, 10);
        JLabel lblMethod = new JLabel("\u30a4\u30f3\u30d5\u30a9\u30e1\u30fc\u30b7\u30e7\u30f3");
        pnlWestTable.add("North", lblMethod);
        this.rowData[0] = "\u9805\u76ee\u7a2e\u5225";
        this.rowData[1] = "\u60c5\u5831";
        DefaultTableModel model = new DefaultTableModel(this.rowData, 0);
        this.unitInfomation.setModel(model);
        new DropTarget(this.unitInfomation, this);
        JScrollPane paneTable = new JScrollPane(this.unitInfomation);
        paneTable.setPreferredSize(new Dimension(300, 200));
        pnlWestTable.add("Center", paneTable);
        this.add("Center", pnlWestTable);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getNewLeadSelectionPath();
        if (path == null) {
            return;
        }
        String strTreePath = path.toString();
        strTreePath = strTreePath.replaceAll(",", ".");
        if ((strTreePath = strTreePath.replaceAll(" ", "")).length() > 2) {
            strTreePath = strTreePath.substring(1, strTreePath.length() - 1);
            this.setInfomation(strTreePath);
        }
    }

    @Override
    public void setUnitViewUpdate() {
        this.setInfomation(this.viewTreePath);
    }

    @Override
    public void setInfomation(String jpPath) {
        this.viewTreePath = jpPath;
        DefaultTableModel model = new DefaultTableModel(this.rowData, 0);
        model.setColumnCount(2);
        this.unitInfomation.setModel(model);
        UnitBaseImpl unit = JpDetailBean.getInstance().getUnit(jpPath);
        if (unit != null) {
            UnitInformation infoUnit = JpDetailBean.getUnitInformation((UnitBaseImpl)unit);
            for (UnitInfoData info : infoUnit.getInfoData()) {
                for (String value : info.getDataList()) {
                    this.showProperty(info.getTitle(), value);
                }
            }
        } else if (!"jp".equalsIgnoreCase(jpPath) && jpPath.indexOf(".") > 0) {
            String strParent = jpPath.substring(0, jpPath.lastIndexOf("."));
            String unitName = jpPath.substring(jpPath.lastIndexOf(".") + 1);
            UnitBaseImpl parentUnit = JpDetailBean.getInstance().getUnit(strParent);
            if (parentUnit instanceof ProxyUnit) {
                common.getInstance().setSubUnit((ProxyUnit)parentUnit, unitName);
            }
        }
    }

    private void showProperty(String propName, String propValue) {
        DefaultTableModel model = (DefaultTableModel)this.unitInfomation.getModel();
        int row = model.getRowCount();
        model.setRowCount(row + 1);
        this.unitInfomation.setValueAt(propName, row, 0);
        this.unitInfomation.setValueAt(propValue, row, 1);
    }

    public void setRootRepaint() {
        JpDetailBean JpUnit = JpDetailBean.getInstance();
        List listNodeName = JpUnit.getJpUnitNameList();
        this.root.removeAllChildren();
        for (String strUnit : listNodeName) {
            this.addRootNode(strUnit);
        }
        this.treeModel.reload(this.root);
    }

    private void addRootNode(String strNode) {
        DefaultMutableTreeNode nodeSwing = new DefaultMutableTreeNode(strNode);
        String strNodePath = "jp." + strNode;
        this.root.add(nodeSwing);
        this.setUnitTreeNode(strNodePath, nodeSwing);
    }

    public void setRepaint(String path) {
        this.setInfomation(path);
        DefaultMutableTreeNode node = this.nodeMap.get(path);
        if (node != null) {
            node.removeAllChildren();
            this.setUnitTreeNode(path, node);
        }
    }

    private void setUnitTreeNode(String strKey, DefaultMutableTreeNode node) {
        UnitInformation infoUnit;
        UnitInfoData info;
        this.nodeMap.put(strKey, node);
        UnitBaseImpl unit = JpDetailBean.getInstance().getUnit(strKey);
        if (unit != null && (info = (infoUnit = JpDetailBean.getUnitInformation((UnitBaseImpl)unit)).getUnitInfoData("CHILD_UNIT")) != null) {
            String[] unitNames;
            String[] stringArray = unitNames = ((String)info.getDataList().get(0)).split(",");
            int n = unitNames.length;
            int n2 = 0;
            while (n2 < n) {
                String unitName = stringArray[n2];
                DefaultMutableTreeNode nodeSwing = new DefaultMutableTreeNode(unitName);
                node.add(nodeSwing);
                String strJpPath = String.valueOf(strKey) + "." + unitName;
                this.setUnitTreeNode(strJpPath, nodeSwing);
                ++n2;
            }
        }
    }
}

