/*
    TCFbECustomTableEx.cpp    December 4, 2004.

    Copyright (C) 2003-2004 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "TCFbECustomTableEx.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
// RXgN^iLbV쐬
__fastcall TCFbECustomTableEx::TCFbECustomTableEx(void)
    : TCFbERowColumnCachedTable()
{
    this->InitCache();
}

//---------------------------------------------------------------------------
// w肳ꂽse[u쐬
__fastcall TCFbECustomTableEx::TCFbECustomTableEx(TStringList* RowLabelList, TStringList* ColumnLabelList)
    : TCFbERowColumnCachedTable(RowLabelList, ColumnLabelList)
{
    this->InitCache();
}

//---------------------------------------------------------------------------
// RXgN^
__fastcall TCFbECustomTableEx::TCFbECustomTableEx(TStringList* SourceCsvStringList)
    : TCFbERowColumnCachedTable(SourceCsvStringList)
{
    this->InitCache();
}

//---------------------------------------------------------------------------
// fXgN^
__fastcall TCFbECustomTableEx::~TCFbECustomTableEx()
{
}

//---------------------------------------------------------------------------
// LbV
void __fastcall TCFbECustomTableEx::InitCache(void)
{
    TCFbECachedTable* MaxRowCache = new TCFbERowCachedTable();
    TCFbECachedTable* MinRowCache = new TCFbERowCachedTable();
    TCFbECachedTable* AverageRowCache = new TCFbERowCachedTable();
    TCFbECachedTable* MedianRowCache = new TCFbERowCachedTable();
    TCFbECachedTable* StdevRowCache = new TCFbERowCachedTable();

    TCFbECachedTable* MaxColumnCache = new TCFbEColumnCachedTable();
    TCFbECachedTable* MinColumnCache = new TCFbEColumnCachedTable();
    TCFbECachedTable* AverageColumnCache = new TCFbEColumnCachedTable();
    TCFbECachedTable* MedianColumnCache = new TCFbEColumnCachedTable();
    TCFbECachedTable* StdevColumnCache = new TCFbEColumnCachedTable();

    this->AddChildCache(MaxRowCache, "Max.row", true);
    this->AddChildCache(MinRowCache, "Min.row", true);
    this->AddChildCache(AverageRowCache, "Average.row", true);
    this->AddChildCache(MedianRowCache, "Median.row", true);
    this->AddChildCache(StdevRowCache, "Stdev.row", true);

    this->AddChildCache(MaxColumnCache, "Max.column", true);
    this->AddChildCache(MinColumnCache, "Min.column", true);
    this->AddChildCache(AverageColumnCache, "Average.column", true);
    this->AddChildCache(MedianColumnCache, "Median.column", true);
    this->AddChildCache(StdevColumnCache, "Stdev.column", true);

    TCFbECachedTable::InitCache();
}

//---------------------------------------------------------------------------
// Normalize iCell ̒lXV trueCȂ false Ԃ
bool __fastcall TCFbECustomTableEx::Normalize(int TargetRowIndex, int TargetColumnIndex, double MaxValue, double MinValue)
{
    if (!this->GetEnabledByIndex(TargetRowIndex, TargetColumnIndex)) {
        return false;
    }
    if (TCFbEToolkit::GetToolkit()->Equals(MaxValue - MinValue, 0.0)) {
        this->SetValueByIndex(TargetRowIndex, TargetColumnIndex, 0.0);
    } else {
        this->SetValueByIndex(TargetRowIndex, TargetColumnIndex, (this->GetValueByIndex(TargetRowIndex, TargetColumnIndex) - MinValue) / (MaxValue - MinValue));
    }
    return true;
}

//---------------------------------------------------------------------------
// Table ̗vf𕔕I Normalize 
void __fastcall TCFbECustomTableEx::PartialNormalize(int ColumnIndex)
{
    double MaxValue;
    double MinValue;
    try {
        MaxValue = this->GetMaxOfColumn(ColumnIndex);
        MinValue = this->GetMinOfColumn(ColumnIndex);
    } catch (...) { //  enabled ȗvfȂ
        return;     // ̗͏I
    }
    for (int i = 0; i < this->GetNumberOfRows(); i++) {
        this->Normalize(i, ColumnIndex, MaxValue, MinValue);
    }
}

//---------------------------------------------------------------------------
// Table ̗vf Normalize 
void __fastcall TCFbECustomTableEx::Normalize(void)
{
    for (int j = 0; j < this->GetNumberOfColumns(); j++) {
        this->PartialNormalize(j);
    }
}

//---------------------------------------------------------------------------
// Standardize iCell ̒lXV trueCȂ false Ԃ
bool __fastcall TCFbECustomTableEx::Standardize(int TargetRowIndex, int TargetColumnIndex, double AverageValue, double StdevValue)
{
    if (!this->GetEnabledByIndex(TargetRowIndex, TargetColumnIndex)) {
        return false;
    }
    if (TCFbEToolkit::GetToolkit()->Equals(StdevValue, 0.0)) {
        this->SetValueByIndex(TargetRowIndex, TargetColumnIndex, 0.0);
    } else {
        this->SetValueByIndex(TargetRowIndex, TargetColumnIndex, (this->GetValueByIndex(TargetRowIndex, TargetColumnIndex) - AverageValue) / StdevValue);
    }
    return true;
}

//---------------------------------------------------------------------------
// Table ̗vf𕔕I Standardize 
void __fastcall TCFbECustomTableEx::PartialStandardize(int ColumnIndex)
{
    double AverageValue;
    double StdevValue;
    try {
        AverageValue = this->GetAverageOfColumn(ColumnIndex);
        StdevValue = this->GetStdevOfColumn(ColumnIndex);
    } catch (...) { //  enabled ȗvfȂ
        return;     // ̗͏I
    }

    for (int i = 0; i < this->GetNumberOfRows(); i++) {
        this->Standardize(i, ColumnIndex, AverageValue, StdevValue);
    }
}

//---------------------------------------------------------------------------
// Table ̗vf Standardize 
void __fastcall TCFbECustomTableEx::Standardize(void)
{
    for (int j = 0; j < this->GetNumberOfColumns(); j++) {
        this->PartialStandardize(j);
    }
}

//---------------------------------------------------------------------------
// Ordering 
void __fastcall TCFbECustomTableEx::Ordering(TList* SortedCellList)
{
    int i = 0;
    while (i < SortedCellList->Count) {
        int EqualsCount = 0;
        while (((i+EqualsCount < SortedCellList->Count))
            && (((TCFbECell*)SortedCellList->Items[i])->GetValue() == ((TCFbECell*)SortedCellList->Items[i+EqualsCount])->GetValue())) {
            EqualsCount++;
        }

        int IndexCount = i;

        for (int k = 0; k < EqualsCount; k++) {
            ((TCFbECell*)SortedCellList->Items[i])->SetValue((SortedCellList->Count - (IndexCount + 1 + (EqualsCount - 1) * 0.5)) / (SortedCellList->Count - 1));
            i++;
        }
    }
}

//---------------------------------------------------------------------------
// Table ̗vf𕔕I Ordering 
void __fastcall TCFbECustomTableEx::PartialOrdering(int ColumnIndex)
{
    TList* SortedCellList = new TList();
    this->GetSortedCellListOfColumn(ColumnIndex, SortedCellList);
    this->Ordering(SortedCellList);

    for (int i = 0; i < this->GetNumberOfRows(); i++) {
        if (this->GetEnabledByIndex(i, ColumnIndex)) {
            this->CellIsUpdatedByIndex(i, ColumnIndex);
        }
    }
    delete SortedCellList;
}

//---------------------------------------------------------------------------
// Table ̗vf Ordering 
void __fastcall TCFbECustomTableEx::Ordering(void)
{
    for (int j = 0; j < this->GetNumberOfColumns(); j++) {
        this->PartialOrdering(j);
    }
}

//---------------------------------------------------------------------------
// Table ̗vfɕI Normalize 
void __fastcall TCFbECustomTableEx::PartialRowNormalize(int RowIndex)
{
    double MaxValue;
    double MinValue;
    try {
        MaxValue = this->GetMaxOfRow(RowIndex);
        MinValue = this->GetMinOfRow(RowIndex);
    } catch (...) { //  enabled ȗvfȂ
        return;     // ̗͏I
    }

    for (int j = 0; j < this->GetNumberOfColumns(); j++) {
        this->Normalize(RowIndex, j, MaxValue, MinValue);
    }
}

//---------------------------------------------------------------------------
// Table ̗vf Normalize 
void __fastcall TCFbECustomTableEx::RowNormalize(void)
{
    for (int i = 0; i < this->GetNumberOfRows(); i++) {
        this->PartialRowNormalize(i);
    }
}

//---------------------------------------------------------------------------
// Table ̗vfɕI Standardize 
void __fastcall TCFbECustomTableEx::PartialRowStandardize(int RowIndex)
{
    double AverageValue;
    double StdevValue;
    try {
        AverageValue = this->GetAverageOfRow(RowIndex);
        StdevValue = this->GetStdevOfRow(RowIndex);
    } catch (...) { //  enabled ȗvfȂ
        return;     // ̗͏I
    }

    for (int j = 0; j < this->GetNumberOfColumns(); j++) {
        this->Standardize(RowIndex, j, AverageValue, StdevValue);
    }
}

//---------------------------------------------------------------------------
// Table ̗vf Standardize 
void __fastcall TCFbECustomTableEx::RowStandardize(void)
{
    for (int i = 0; i < this->GetNumberOfRows(); i++) {
        this->PartialRowStandardize(i);
    }
}

//---------------------------------------------------------------------------
// Table ̗vfɕI Ordering 
void __fastcall TCFbECustomTableEx::PartialRowOrdering(int RowIndex)
{
    TList* SortedCellList = new TList();
    this->GetSortedCellListOfRow(RowIndex, SortedCellList);
    this->Ordering(SortedCellList);

    for (int j = 0; j < this->GetNumberOfColumns(); j++) {
        if (this->GetEnabledByIndex(RowIndex, j)) {
            this->CellIsUpdatedByIndex(RowIndex, j);
        }
    }
    delete SortedCellList;
}

//---------------------------------------------------------------------------
// Table ̗vf Ordering 
void __fastcall TCFbECustomTableEx::RowOrdering(void)
{
    for (int i = 0; i < this->GetNumberOfRows(); i++) {
        this->PartialRowOrdering(i);
    }
}

//---------------------------------------------------------------------------
// TargetRowIndex s TargetColumnIndex ڂNormalize ꂽl Value  DisNormalize ĕԂ
double __fastcall TCFbECustomTableEx::DisNormalize(int ColumnIndex, double NormalizedValue)
{
    return NormalizedValue * (this->GetMaxOfColumn(ColumnIndex) - this->GetMinOfColumn(ColumnIndex)) + this->GetMinOfColumn(ColumnIndex);
}

//---------------------------------------------------------------------------
// ColumnIndex ڂ Standardize ꂽl StandardizedValue  DisNormalize ĕԂ
double __fastcall TCFbECustomTableEx::DisStandardize(int ColumnIndex, double StandardizedValue)
{
    return StandardizedValue * this->GetStdevOfColumn(ColumnIndex) + this->GetAverageOfColumn(ColumnIndex);
}

//---------------------------------------------------------------------------
// ColumnIndex ڂ Ordering ꂽl Order  DisOrdering ĕԂ
double __fastcall TCFbECustomTableEx::DisOrdering(int ColumnIndex, double Order, TDoubleDynArray& SortedOrders)
{
    TDoubleDynArray SortedValues;
    this->GetEnabledCellsInColumn(ColumnIndex, SortedValues);
    return this->DisOrderingCommon(ColumnIndex, Order, SortedOrders, SortedValues);
}

//---------------------------------------------------------------------------
// RowIndex ڂ̉ Normalize ꂽl RowNormalizedValue  DisRowNormalize ĕԂ
double __fastcall TCFbECustomTableEx::DisRowNormalize(int RowIndex, double RowNormalizedValue)
{
    return RowNormalizedValue * (this->GetMaxOfRow(RowIndex) - this->GetMinOfRow(RowIndex)) + this->GetMinOfRow(RowIndex);
}

//---------------------------------------------------------------------------
// RowIndex ڂ̉ Standardize ꂽl RowStandardizedValue  DisRowStandardize ĕԂ
double __fastcall TCFbECustomTableEx::DisRowStandardize(int RowIndex, double RowStandardizedValue)
{
    return RowStandardizedValue * this->GetStdevOfRow(RowIndex) + this->GetAverageOfRow(RowIndex);
}

//---------------------------------------------------------------------------
// RowIndex ڂ̉ Ordering ꂽl RowOrder  DisRowOrdering ĕԂ
double __fastcall TCFbECustomTableEx::DisRowOrdering(int RowIndex, double RowOrder, TDoubleDynArray& SortedOrders)
{
    TDoubleDynArray SortedValues;
    this->GetEnabledCellsInRow(RowIndex, SortedValues);
    double result = this->DisOrderingCommon(RowIndex, RowOrder, SortedOrders, SortedValues);
    return result;
}

//---------------------------------------------------------------------------
// DisOrdering  DisRowOrdering Ŏgʂ̏
double __fastcall TCFbECustomTableEx::DisOrderingCommon(int Index, double Order, TDoubleDynArray& SortedOrders, TDoubleDynArray& SortedValues)
{
    TCFbEToolkit::GetToolkit()->SortDoubleDynArray(SortedValues, sdDescending);    // ~\[g

    if (SortedValues.Length != SortedOrders.Length) {
        SortedValues.Length = 0;
        throw Exception("SortedValues.Length differed from SortedOrders.Length (in TCFbECustomTableEx::DisRowOrdering).");
    }

    if (SortedOrders.Length <= 0) {
        throw Exception("There is no elememt in SortedOrders (in TCFbECustomTableEx::DisRowOrdering).");
    }

    // ̂ꂩ̃gNX̒ɁC\lƓ̂ꍇ
    for (int i = 0; i < SortedOrders.Length; i++) {
        if (TCFbEToolkit::GetToolkit()->Equals(SortedOrders[i], Order)) {
            double ReturnValue = SortedValues[i];
            SortedValues.Length = 0;
            return ReturnValue;
        }
    }

    double LowestOrder = SortedOrders[SortedOrders.High];
    double HighestOrder = SortedOrders[0];

    // orderOf(pa,j) < orderOf(mlowest,j)łꍇ
    if (Order < LowestOrder) {
        int i = SortedOrders.High;
        while (--i > 0) {
            if (SortedOrders[i] > LowestOrder) {
                break;
            }
        }

        double SecondLowestOrder = (i >= 0) ? SortedOrders[i] : HighestOrder;    // RowIndex ڂ̒l̒2Ԗڂɏ
        double LowestValue = SortedValues[SortedValues.High];

        if (TCFbEToolkit::GetToolkit()->Equals(SecondLowestOrder - LowestOrder, 0.0)) {
            SortedValues.Length = 0;
            return LowestValue * (Order - LowestOrder) + LowestValue;
        }

        double SecondLowestValue = SortedValues[i];
        SortedValues.Length = 0;

        return (SecondLowestValue - LowestValue) / (SecondLowestOrder - LowestOrder) * (Order - LowestOrder) + LowestValue;

    // (2) orderOf(pa,j) > orderOf(mhighest,j)łꍇ
    } else if (Order > HighestOrder) {
        int i = 0;
        while (++i < SortedOrders.Length) {
            if (SortedOrders[i] < HighestOrder) {
                break;
            }
        }

        double SecondHighestOrder = (i >= 0) ? SortedOrders[i] : LowestOrder;    // RowIndex ڂ̒l̒2Ԗڂɑ傫
        double HighestValue = SortedValues[0];

        if (TCFbEToolkit::GetToolkit()->Equals(HighestOrder - SecondHighestOrder, 0.0)) {
            SortedValues.Length = 0;
            return HighestValue * (Order - HighestOrder) + HighestValue;
        }

        double SecondHighestValue = SortedValues[i];
        SortedValues.Length = 0;

        return (HighestValue - SecondHighestValue) / (HighestOrder - SecondHighestOrder) * (Order - HighestOrder) + HighestValue;
    }

    // ȊȌꍇ
    int    HighIndex = 0;
    int    LowIndex = SortedOrders.High;

    for (int i = 0; i < SortedOrders.Length; i++) {
        double CurrentOrder = SortedOrders[i];
        if ((CurrentOrder < Order) && (CurrentOrder > SortedOrders[LowIndex])) {
            LowIndex = i;
        } else if ((CurrentOrder > Order) && (CurrentOrder < SortedOrders[HighIndex])) {
            HighIndex = i;
        }
    }

    double HighOrder    = SortedOrders[HighIndex];
    double LowOrder    = SortedOrders[LowIndex];
    double HighValue    = SortedValues[HighIndex];
    double LowValue    = SortedValues[LowIndex];
    SortedValues.Length = 0;

    if (TCFbEToolkit::GetToolkit()->Equals(HighOrder - LowOrder, 0.0)) {
        return LowValue * (Order - LowOrder) + LowValue;
    }

    return ((HighValue - LowValue) / (HighOrder - LowOrder)) * (Order - LowOrder) + LowValue;
}

//---------------------------------------------------------------------------
// j ڂ Inverse Case Frequency Coefficient 𓾂
double __fastcall TCFbECustomTableEx::GetICFCoefficient(int j)
{
    int EnabledCount = this->GetEnabledCountOfColumn(j);
    if (EnabledCount == 0) {
        return 0.0;
    }
    return log((double)this->GetNumberOfRows() / (double)EnabledCount);
}

//---------------------------------------------------------------------------
// s̍őlԂD
// s̗vfȂꍇ͗O𑗏oD
double __fastcall TCFbECustomTableEx::GetMaxOfRow(int i)
{
    TCFbERowCachedTable* MaxOfRowCache = (TCFbERowCachedTable*)this->GetMaxRowCache();

    if (!MaxOfRowCache->GetEnabledByIndex(i, 0)) {
        bool IsFirst = true;
        double Max = 0.0;

        for (int j = 0; j < this->GetNumberOfColumns(); j++) {
            TCFbECell* CurrentCell = this->GetCellByIndex(i, j);
            if (CurrentCell->GetEnabled() && (IsFirst || (CurrentCell->GetValue() > Max))) {
                Max = CurrentCell->GetValue();
                IsFirst = false;
            }
        }
        if (IsFirst) {
            throw Exception("There is no elements in the row (in TCFbECustomTableEx::GetMaxOfRow).");
        }

        MaxOfRowCache->SetValueByIndex(i, 0, Max);
    }

    return MaxOfRowCache->GetValueByIndex(i, 0);
}

//---------------------------------------------------------------------------
// s̍ŏlԂD
// s̗vfȂꍇ͗O𑗏oD
double __fastcall TCFbECustomTableEx::GetMinOfRow(int i)
{
    TCFbERowCachedTable* MinOfRowCache = (TCFbERowCachedTable*)this->GetMinRowCache();

    if (!MinOfRowCache->GetEnabledByIndex(i, 0)) {
        bool IsFirst = true;
        double Min = 0.0;

        for (int j = 0; j < this->GetNumberOfColumns(); j++) {
            TCFbECell* CurrentCell = this->GetCellByIndex(i, j);
            if (CurrentCell->GetEnabled() && (IsFirst || (CurrentCell->GetValue() < Min))) {
                Min = CurrentCell->GetValue();
                IsFirst = false;
            }
        }
        if (IsFirst) {
            throw Exception("There is no elements in the row (in TCFbECustomTableEx::GetMinOfRow).");
        }

        MinOfRowCache->SetValueByIndex(i, 0, Min);
    }

    return MinOfRowCache->GetValueByIndex(i, 0);
}

//---------------------------------------------------------------------------
// s̕ϒlԂD
// s̗vfȂꍇ͗O𑗏oD
double __fastcall TCFbECustomTableEx::GetAverageOfRow(int i)
{
    TCFbERowCachedTable* AverageOfRowCache = (TCFbERowCachedTable*)this->GetAverageRowCache();

    if (!AverageOfRowCache->GetEnabledByIndex(i, 0)) {
        int Count = 0;
        double Sum = 0;

        for (int j = 0; j < this->GetNumberOfColumns(); j++) {
            TCFbECell* CurrentCell = this->GetCellByIndex(i, j);
            if (CurrentCell->GetEnabled()) {
                Sum += CurrentCell->GetValue();
                Count++;
            }
        }

        if (Count == 0) {
            AverageOfRowCache->SetValueByIndex(i, 0, 0.0);
        } else {
            AverageOfRowCache->SetValueByIndex(i, 0, Sum / (double)Count);
        }
    }

    return AverageOfRowCache->GetValueByIndex(i, 0);
}

//---------------------------------------------------------------------------
// s̒ԒlԂD
// s̗vfȂꍇ͗O𑗏oD
double __fastcall TCFbECustomTableEx::GetMedianOfRow(int i)
{
    TCFbERowCachedTable* MedianOfRowCache = (TCFbERowCachedTable*)this->GetMedianRowCache();

    if (!MedianOfRowCache->GetEnabledByIndex(i, 0)) {
        TDoubleDynArray EnabledValues;
        this->GetEnabledCellsInRow(i, EnabledValues);

        if (EnabledValues.Length == 0) {
            throw Exception("There is no elements in the row (in TCFbECustomTableEx::GetMedianOfRow).");
        }

        TCFbEToolkit::GetToolkit()->SortDoubleDynArray(EnabledValues, sdDescending);
        MedianOfRowCache->SetValueByIndex(i, 0, TCFbEToolkit::GetToolkit()->GetMedianOfDynArray(EnabledValues));
        EnabledValues.Length = 0;
    }

    return MedianOfRowCache->GetValueByIndex(i, 0);
}

//---------------------------------------------------------------------------
// s̕W΍ԂD
// s̗vfȂꍇ͗O𑗏oD
double __fastcall TCFbECustomTableEx::GetStdevOfRow(int i)
{
    TCFbERowCachedTable* StdevOfRowCache = (TCFbERowCachedTable*)this->GetStdevRowCache();

    if (!StdevOfRowCache->GetEnabledByIndex(i, 0)) {
        double Average;
        try {
            Average = this->GetAverageOfRow(i);
        } catch (...) {
            throw Exception("There is no elements in the row (in TCFbECustomTableEx::GetStdevOfRow).");
        }

        double  Sum = 0.0;
        int     Count = 0;
        for (int j = 0; j < this->GetNumberOfColumns(); j++) {
            TCFbECell* CurrentCell = this->GetCellByIndex(i, j);
            if (CurrentCell->GetEnabled()) {
                Sum += pow(CurrentCell->GetValue() - Average, 2.0);
                Count++;
            }
        }

        if (Count == 0) {
            StdevOfRowCache->SetValueByIndex(i, 0, 0.0);
        } else {
            StdevOfRowCache->SetValueByIndex(i, 0, sqrt(Sum / (double)Count));
        }
    }

    return StdevOfRowCache->GetValueByIndex(i, 0);
}

//---------------------------------------------------------------------------
// ComparedRowIndex Ԗڂ̍s BaseRowIndex Ԗڂ̍sɑ΂ Averaged Multiplier ԂD
double __fastcall TCFbECustomTableEx::GetAveragedMultiplierOfRow(int BaseRowIndex, int ComparedRowIndex)
{
    double    Sum = 0.0;
    int    Count = 0;

    for (int j = 0; j < this->GetNumberOfColumns(); j++) {
        TCFbECell* ComparedCell = this->GetCellByIndex(ComparedRowIndex, j);
        TCFbECell* BaseCell = this->GetCellByIndex(BaseRowIndex, j);

        if (ComparedCell->GetEnabled() && BaseCell->GetEnabled() && !TCFbEToolkit::GetToolkit()->Equals(ComparedCell->GetValue(), 0.0)) {
            Sum += fabs(BaseCell->GetValue() / ComparedCell->GetValue());
            Count++;
        }
    }

    if (Count == 0) {
        return 0.0;
    }

    return Sum / Count;
}

//---------------------------------------------------------------------------
// ComparedRowIndex Ԗڂ̍s BaseRowIndex Ԗڂ̍sɑ΂ Median of Multiplier ԂD
double __fastcall TCFbECustomTableEx::GetMedianOfMultiplierOfRow(int BaseRowIndex, int ComparedRowIndex)
{
    TDoubleDynArray EnabledValues;

    for (int j = 0; j < this->GetNumberOfColumns(); j++) {
        TCFbECell* ComparedCell = this->GetCellByIndex(ComparedRowIndex, j);
        TCFbECell* BaseCell = this->GetCellByIndex(BaseRowIndex, j);

        if (ComparedCell->GetEnabled() && BaseCell->GetEnabled() && !TCFbEToolkit::GetToolkit()->Equals(ComparedCell->GetValue(), 0)) {
            EnabledValues.Length++;
            EnabledValues[EnabledValues.High] = fabs(BaseCell->GetValue() / ComparedCell->GetValue());
        }
    }

    double ReturnValue = 0.0;
    if (EnabledValues.Length > 0) {
        TCFbEToolkit::GetToolkit()->SortDoubleDynArray(EnabledValues, sdDescending);
        ReturnValue = TCFbEToolkit::GetToolkit()->GetMedianOfDynArray(EnabledValues);
        EnabledValues.Length = 0;
    }

    return ReturnValue;
}

//---------------------------------------------------------------------------
// ̍őlԂD
// ̗vfȂꍇ͗O𑗏oD
double __fastcall TCFbECustomTableEx::GetMaxOfColumn(int j)
{
    TCFbEColumnCachedTable* MaxOfColumnCache = (TCFbEColumnCachedTable*)this->GetMaxColumnCache();

    if (!MaxOfColumnCache->GetEnabledByIndex(0, j)) {
        bool IsFirst = true;
        double Max = 0.0;

        for (int i = 0; i < this->GetNumberOfRows(); i++) {
            TCFbECell* CurrentCell = this->GetCellByIndex(i, j);
            if (CurrentCell->GetEnabled() && (IsFirst || (CurrentCell->GetValue() > Max))) {
                Max = CurrentCell->GetValue();
                IsFirst = false;
            }
        }
        if (IsFirst) {
            throw Exception("There is no elements in the column (in TCFbECustomTableEx::GetMaxOfColumn).");
        }

        MaxOfColumnCache->SetValueByIndex(0, j, Max);
    }

    return MaxOfColumnCache->GetValueByIndex(0, j);
}

//---------------------------------------------------------------------------
// ̍ŏlԂD
// ̗vfȂꍇ͗O𑗏oD
double __fastcall TCFbECustomTableEx::GetMinOfColumn(int j)
{
    TCFbEColumnCachedTable* MinOfColumnCache = (TCFbEColumnCachedTable*)this->GetMinColumnCache();

    if (!MinOfColumnCache->GetEnabledByIndex(0, j)) {
        bool IsFirst = true;
        double Min = 0.0;

        for (int i = 0; i < this->GetNumberOfRows(); i++) {
            TCFbECell* CurrentCell = this->GetCellByIndex(i, j);
            if (CurrentCell->GetEnabled() && (IsFirst || (CurrentCell->GetValue() < Min))) {
                Min = CurrentCell->GetValue();
                IsFirst = false;
            }
        }
        if (IsFirst) {
            throw Exception("There is no elements in the column (in TCFbECustomTableEx::GetMinOfColumn).");
        }

        MinOfColumnCache->SetValueByIndex(0, j, Min);
    }

    return MinOfColumnCache->GetValueByIndex(0, j);
}

//---------------------------------------------------------------------------
// ̕ϒlԂD
// ̗vfȂꍇ͗O𑗏oD
double __fastcall TCFbECustomTableEx::GetAverageOfColumn(int j)
{
    TCFbEColumnCachedTable* AverageOfColumnCache = (TCFbEColumnCachedTable*)this->GetAverageColumnCache();

    if (!AverageOfColumnCache->GetEnabledByIndex(0, j)) {
        int Count = 0;
        double Sum = 0;

        for (int i = 0; i < this->GetNumberOfRows(); i++) {
            TCFbECell* CurrentCell = this->GetCellByIndex(i, j);
            if (CurrentCell->GetEnabled()) {
                Sum += CurrentCell->GetValue();
                Count++;
            }
        }

        if (Count == 0) {
            AverageOfColumnCache->SetValueByIndex(0, j, 0.0);
        } else {
            AverageOfColumnCache->SetValueByIndex(0, j, Sum / (double)Count);
        }
    }

    return AverageOfColumnCache->GetValueByIndex(0, j);
}

//---------------------------------------------------------------------------
// ̒ԒlԂD
// ̗vfȂꍇ͗O𑗏oD
double __fastcall TCFbECustomTableEx::GetMedianOfColumn(int j)
{
    TCFbEColumnCachedTable* MedianOfColumnCache = (TCFbEColumnCachedTable*)this->GetMedianColumnCache();

    if (!MedianOfColumnCache->GetEnabledByIndex(0, j)) {
        TDoubleDynArray EnabledValues;
        this->GetEnabledCellsInColumn(j, EnabledValues);

        if (EnabledValues.Length == 0) {
            throw Exception("There is no elements in the column (in TCFbECustomTableEx::GetMedianOfColumn).");
        }

        TCFbEToolkit::GetToolkit()->SortDoubleDynArray(EnabledValues, sdDescending);
        MedianOfColumnCache->SetValueByIndex(0, j, TCFbEToolkit::GetToolkit()->GetMedianOfDynArray(EnabledValues));
        EnabledValues.Length = 0;
    }

    return MedianOfColumnCache->GetValueByIndex(0, j);
}

//---------------------------------------------------------------------------
// ̕W΍ԂD
// ̗vfȂꍇ͗O𑗏oD
double __fastcall TCFbECustomTableEx::GetStdevOfColumn(int j)
{
    TCFbEColumnCachedTable* StdevOfColumnCache = (TCFbEColumnCachedTable*)this->GetStdevColumnCache();

    if (!StdevOfColumnCache->GetEnabledByIndex(0, j)) {
        double Average;
        try {
            Average = this->GetAverageOfColumn(j);
        } catch (...) {
            throw Exception("There is no elements in the column (in TCFbECustomTableEx::GetStdevOfColumn).");
        }

        double  Sum = 0.0;
        int     Count = 0;
        for (int i = 0; i < this->GetNumberOfRows(); i++) {
            TCFbECell* CurrentCell = this->GetCellByIndex(i, j);
            if (CurrentCell->GetEnabled()) {
                Sum += pow(CurrentCell->GetValue() - Average, 2.0);
                Count++;
            }
        }

        if (Count == 0) {
            StdevOfColumnCache->SetValueByIndex(0, j, 0.0);
        } else {
            StdevOfColumnCache->SetValueByIndex(0, j, sqrt(Sum / (double)Count));
        }
    }

    return StdevOfColumnCache->GetValueByIndex(0, j);
}

//---------------------------------------------------------------------------
// ComparedColumnIndex Ԗڂ̗ BaseColumnIndex Ԗڂ̗ɑ΂ Averaged Multiplier ԂD
double __fastcall TCFbECustomTableEx::GetAveragedMultiplierOfColumn(int BaseColumnIndex, int ComparedColumnIndex)
{
    double    Sum = 0.0;
    int    Count = 0;

    for (int i = 0; i < this->GetNumberOfRows(); i++) {
        TCFbECell* ComparedCell = this->GetCellByIndex(i, ComparedColumnIndex);
        TCFbECell* BaseCell = this->GetCellByIndex(i, BaseColumnIndex);

        if (ComparedCell->GetEnabled() && BaseCell->GetEnabled() && ComparedCell->GetValue() != 0) {
            Sum += fabs(BaseCell->GetValue() / ComparedCell->GetValue());
            Count++;
        }
    }

    if (Count == 0) {
        return 0.0;
    }

    return Sum / Count;
}

//---------------------------------------------------------------------------
// ComparedColumnIndex Ԗڂ̗ BaseColumnIndex Ԗڂ̗ɑ΂ Median of Multiplier ԂD
double __fastcall TCFbECustomTableEx::GetMedianOfMultiplierOfColumn(int BaseColumnIndex, int ComparedColumnIndex)
{
    TDoubleDynArray EnabledValues;

    for (int i = 0; i < this->GetNumberOfRows(); i++) {
        TCFbECell* ComparedCell = this->GetCellByIndex(i, ComparedColumnIndex);
        TCFbECell* BaseCell = this->GetCellByIndex(i, BaseColumnIndex);

        if (ComparedCell->GetEnabled() && BaseCell->GetEnabled() && ComparedCell->GetValue() != 0) {
            EnabledValues.Length++;
            EnabledValues[EnabledValues.High] = fabs(BaseCell->GetValue() / ComparedCell->GetValue());
        }
    }

    double ReturnValue = 0.0;
    if (EnabledValues.Length > 0) {
        TCFbEToolkit::GetToolkit()->SortDoubleDynArray(EnabledValues, sdDescending);
        ReturnValue = TCFbEToolkit::GetToolkit()->GetMedianOfDynArray(EnabledValues);
        EnabledValues.Length = 0;
    }

    return ReturnValue;
}

//---------------------------------------------------------------------------
// ȉCprotected method
//---------------------------------------------------------------------------

