/*
    TCFbEDataSetEx.cpp    June 6, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "TCFbEDataSetEx.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)            
//---------------------------------------------------------------------------
double __fastcall TCFbEDataSetEx::GetSimilarityByIndex(int TargetRowIndex, int ComparedRowIndex, int ConditionColumnIndex)
{
    if (!this->IsPrepared()) {
        Exception("TCFbEDataSetEx is not preapared (in TCFbEDataSetEx::GetSimilaritiesByIndex).");
    }

    if ((this->FVWSimilarityComputationAlgorithm != NULL) && (this->ConditionIndexForSimilarity != ConditionColumnIndex)) {
        for (int j = 0; j < this->SimilarityComputationTable->GetColumnLabelList()->Count; j++) {
            double VWSimilarityOfColumn = this->GetVWSimilarityOfColumn(ConditionColumnIndex, j);
            for (int i = 0; i < this->SimilarityComputationTable->GetRowLabelList()->Count; i++) {
                TCFbECell* CurrentCell = (this->FAlgorithmBase == abRow) ? this->NormalizedTable->GetCellByIndex(i, j) : this->NormalizedTable->GetCellByIndex(j, i);
                if (CurrentCell->GetEnabled()) {
                    this->SimilarityComputationTable->SetValueByIndex(i, j, CurrentCell->GetValue() * VWSimilarityOfColumn);
                }
            }
        }

        // Inverse Case Frequency
        if (this->FInverseCaseFrequencyEnabled) {
            for (int j = 0; j < this->SimilarityComputationTable->GetNumberOfColumns(); j++) {
                this->InverseCaseFrequencyForColumn(j);
            }
        }

        // ConditionColumnIndex  -1 ̂Ƃ́CSd݂ 1.0 ƂčXV
        this->ConditionIndexForSimilarity = ConditionColumnIndex;
    }

    if (!this->SimilarityCache->GetEnabledByIndex(TargetRowIndex, ComparedRowIndex)) {
        double CalculatedSimilarity = this->FSimilarityComputationAlgorithm->ComputeSimilarity(this->SimilarityComputationTable, TargetRowIndex, ComparedRowIndex);

        if (this->FCaseAmplifier != 1.0) {
            if (CalculatedSimilarity >= 0.0) {
                CalculatedSimilarity = Power(CalculatedSimilarity, this->FCaseAmplifier);
            } else {
                CalculatedSimilarity = -1.0 * Power(-1.0 * CalculatedSimilarity, this->FCaseAmplifier);
            }
        }

        this->SimilarityCache->SetValueByIndex(TargetRowIndex, ComparedRowIndex, CalculatedSimilarity);
    }

    return this->SimilarityCache->GetValueByIndex(TargetRowIndex, ComparedRowIndex);
}

//---------------------------------------------------------------------------
double __fastcall TCFbEDataSetEx::GetPredictedValueByIndex(int TargetRowIndex, int TargetColumnIndex)
{
    if (!this->IsPrepared()) {
        Exception("TCFbEDataSetEx is not preapared (in TCFbEDataSetEx::GetPredictedValueByIndex).");
    }

    if (!this->PredictedValueCache->GetEnabledByIndex(TargetRowIndex, TargetColumnIndex)) {
        double  PredictedValue;
        TObjectList* NeighborList = new TObjectList();
        if (this->FAlgorithmBase == abRow) {
            this->GetNearestNeighbors(TargetRowIndex, TargetColumnIndex, this->FNeighborhoodSize, NeighborList);
            PredictedValue = this->FPredictionAlgorithm->Predict(this->PredictionTable, TargetRowIndex, TargetColumnIndex, NeighborList, this->VWPredictionTable, this->FVWPredictionAlgorithm);
        } else {    // ACex[XȂ\Ώۂ̍sƗւĎs
            this->GetNearestNeighbors(TargetColumnIndex, TargetRowIndex, this->FNeighborhoodSize, NeighborList);
            PredictedValue = this->FPredictionAlgorithm->Predict(this->PredictionTable, TargetColumnIndex, TargetRowIndex, NeighborList, this->VWPredictionTable, this->FVWPredictionAlgorithm);
        }
        delete NeighborList;

        switch (this->FValueBase) {
            case vbStandardizedValue:
                PredictedValue = this->DisStandardize(PredictedValue, this->GetAverageOfColumn(TargetColumnIndex), this->GetStdevOfColumn(TargetColumnIndex));
                break;
            case vbNormalizedValue:
                PredictedValue = this->DisNormalize(PredictedValue, this->GetMaxOfColumn(TargetColumnIndex), this->GetMinOfColumn(TargetColumnIndex));
                break;
            case vbOrder:
                PredictedValue = this->DisOrderingEx(PredictedValue, TargetColumnIndex);
                break;
            default:
                ; // Ȃ
        }
        this->PredictedValueCache->SetValueByIndex(TargetRowIndex, TargetColumnIndex, PredictedValue);
    }

    return this->PredictedValueCache->GetValueByIndex(TargetRowIndex, TargetColumnIndex);
}

//---------------------------------------------------------------------------
// ComparedColumnIndex Ԗڂ̗ BaseColumnIndex Ԗڂ̗ɑ΂ Variable Weighting Weighted Multiplier ԂD
double __fastcall TCFbEDataSetEx::GetVWSimilarityOfColumn(int BaseColumnIndex, int ComparedColumnIndex)
{
    if (!this->VWSimilarityComputationCache->GetEnabledByIndex(BaseColumnIndex, ComparedColumnIndex)) {
        this->VWSimilarityComputationCache->SetValueByIndex(BaseColumnIndex, ComparedColumnIndex, this->FVWSimilarityComputationAlgorithm->ComputeSimilarity(this->VWSimilarityComputationTable, BaseColumnIndex, ComparedColumnIndex));
    }
    return this->VWSimilarityComputationCache->GetValueByIndex(BaseColumnIndex, ComparedColumnIndex);
}

//---------------------------------------------------------------------------
// RXgN^
__fastcall TCFbEDataSetEx::TCFbEDataSetEx(void)
    : TCFbETableEx()
{
    this->FValueBase = vbUnknown;
    this->FAlgorithmBase = abUnknown;
    this->FSimilarityComputationAlgorithm = NULL;
    this->FPredictionAlgorithm = NULL;
    this->FNeighborhoodSize = -1;
    this->FIsPrepared = false;

    this->TemporallyUnableRowIndex = -1;
    this->TemporallyUnableColumnIndex = -1;
    this->TemporallyUnableValue = 0.0;

    this->ConditionIndexForSimilarity = -1;
    this->ConditionIndexForPrediction = -1;
}

//---------------------------------------------------------------------------
// RXgN^
// SourceCsvStringList f[^\z
// Row  1 sڂɃR[h̃x
// Column  1 sڂɃACẽx
// ͒lĂƂ݂Ȃ
__fastcall TCFbEDataSetEx::TCFbEDataSetEx(TStringList* SourceCsvStringList)
    : TCFbETableEx(SourceCsvStringList)
{
    this->FValueBase = vbUnknown;
    this->FAlgorithmBase = abUnknown;
    this->FSimilarityComputationAlgorithm = NULL;
    this->FPredictionAlgorithm = NULL;
    this->FNeighborhoodSize = -1;
    this->FIsPrepared = false;

    this->TemporallyUnableRowIndex = -1;
    this->TemporallyUnableColumnIndex = -1;
    this->TemporallyUnableValue = 0.0;

    this->ConditionIndexForSimilarity = -1;
    this->ConditionIndexForPrediction = -1;
}

//---------------------------------------------------------------------------
// fXgN^
__fastcall TCFbEDataSetEx::~TCFbEDataSetEx()
{
    if (this->IsPrepared()) {
        delete this->FPredictionAlgorithm;
        delete this->FSimilarityComputationAlgorithm;

        if (this->FVWSimilarityComputationAlgorithm != NULL) {
            delete this->FVWSimilarityComputationAlgorithm;
        }
        if (this->FVWPredictionAlgorithm != NULL) {
            delete this->FVWPredictionAlgorithm;
        }
    }
}

//---------------------------------------------------------------------------
// LbV
void __fastcall TCFbEDataSetEx::InitCache(void)
{
    this->NormalizedTable = new TCFbETableEx();
    this->AddChildCache(this->NormalizedTable, "NormalizedTable", false);
    
    TCFbETableEx::InitCache();
}

//---------------------------------------------------------------------------
//    CF ̏siPredictionTable 
//    ValueBase:            vZɎgliValue / StandardizedValue / NormalizedValue / Order
//    AlgorithmBase:        Row(User)-based CColumn(Item)-based 
//    SimilarityComputationAlgorithm:   ގxvZASYiTCFbEDataSetEx 
//    PredictionAlgorithm:  \ASYiTCFbEDataSetEx 
//    NeighborhoodSize:     lCo[tbhTCY
//    DefaultValueEnabled:  Default Value ߍ݋@\Lɂ邩ǂ
//    DefaultValue:         Default Value ߍ݋@\LȂƂɖߍޒl
//    InverseCaseFrequencyEnabled:  Inverse Case Frequency @\Lɂ邩ǂ
//    CaseAmplifier:        Case Amplification @\gpƂ amplifierigpȂƂ 1.0 wj
//    VWSimilarityComputationAlgorithm: Variable Weighting for Similarity Computation vZASY
//    VWPredictionAlgorithm: Variable Weighting for Prediction vZASY
void __fastcall TCFbEDataSetEx::PrepareCF(TCFbEValueBase ValueBase, TCFbEAlgorithmBase AlgorithmBase, TCFbESimilarityComputationAlgorithm* SimilarityComputationAlgorithm, TCFbEPredictionAlgorithm* PredictionAlgorithm, int NeighborhoodSize, bool DefaultValueEnabled, double DefaultValue, bool InverseCaseFrequencyEnabled, double CaseAmplifier, TCFbESimilarityComputationAlgorithm* VWSimilarityComputationAlgorithm, TCFbESimilarityComputationAlgorithm* VWPredictionAlgorithm)
{
    if (this->IsPrepared()) {
        delete this->FSimilarityComputationAlgorithm;
        delete this->FPredictionAlgorithm;
        if (this->FVWSimilarityComputationAlgorithm != NULL) {
            delete this->FVWSimilarityComputationAlgorithm;
            this->FVWSimilarityComputationAlgorithm = NULL;
        }
        if (this->FVWPredictionAlgorithm != NULL) {
            delete this->FVWPredictionAlgorithm;
            this->FVWPredictionAlgorithm = NULL;
        }

        this->NormalizedTable->DeleteChildCache("SimilarityComputationTable");
        this->SimilarityComputationTable = NULL;
        this->NormalizedTable->DeleteChildCache("VWSimilarityComputationTable");
        this->VWSimilarityComputationTable = NULL;

        this->NormalizedTable->DeleteChildCache("PredictionTable");
        this->PredictionTable = NULL;
        this->NormalizedTable->DeleteChildCache("VWPredictionTable");
        this->VWPredictionTable = NULL;

        this->ConditionIndexForSimilarity = -1;
        this->ConditionIndexForPrediction = -1;

        for (int i = 1; i < this->ChildCacheList->Count; i++) {
            this->DeleteChildCacheByIndex(i);
        }
    }

    this->FSimilarityComputationAlgorithm = SimilarityComputationAlgorithm;
    this->FPredictionAlgorithm = PredictionAlgorithm;
    this->FNeighborhoodSize = NeighborhoodSize;
    this->FAlgorithmBase = AlgorithmBase;
    this->FValueBase = ValueBase;
    this->FVWSimilarityComputationAlgorithm = VWSimilarityComputationAlgorithm;
    this->FVWPredictionAlgorithm = VWPredictionAlgorithm;

    // Value / StandardizedValue / NormalizedValue / Order ̏
    this->NormalizedTable->Assign(this);

    switch (this->FValueBase) {
        case vbStandardizedValue:
            this->AddChildCache(new TCFbEColumnCachedTable(this), "Average.column", true);
            this->AddChildCache(new TCFbEColumnCachedTable(this), "Stdev.column", true);
            this->Standardize(NormalizedTable);
            break;

        case vbNormalizedValue:
            this->AddChildCache(new TCFbEColumnCachedTable(this), "Max.column", true);
            this->AddChildCache(new TCFbEColumnCachedTable(this), "Min.column", true);
            this->Normalize(NormalizedTable);
            break;

        case vbOrder :
            this->Ordering(NormalizedTable);
            break;

        default:
            break;
    }

    // Default Value ̐ݒ
    this->FDefaultValueEnabled = DefaultValueEnabled;
    this->FDefaultValue = DefaultValue;
    if (this->FDefaultValueEnabled) {
        for (int i = 0; i < this->NormalizedTable->GetNumberOfRows(); i++) {
            for (int j = 0; j < this->NormalizedTable->GetNumberOfColumns(); j++) {
                if (!this->NormalizedTable->GetEnabledByIndex(i, j)) {
                    this->NormalizedTable->SetValueByIndex(i, j, this->FDefaultValue);
                }
            }
        }
    }

    // Variable Weighting for Similarity Computation e[ȕ
    if (this->FVWSimilarityComputationAlgorithm != NULL) {
        if (this->FAlgorithmBase == abRow) {    // User-based CF
            this->SimilarityComputationTable = new TCFbETableEx(this->GetRowLabelList(), this->GetColumnLabelList());
            this->VWSimilarityComputationTable = new TCFbERotatedTableEx();
            this->VWSimilarityComputationTable->RotatedCopyAllElementsAndCache(this->NormalizedTable, false, false);
        } else {    // Item-based CF
            this->SimilarityComputationTable = new TCFbERotatedTableEx(this->GetColumnLabelList(), this->GetRowLabelList());
            this->VWSimilarityComputationTable = new TCFbETableEx();
            this->VWSimilarityComputationTable->CopyAllElementsAndCache(this->NormalizedTable, false, false);
        }
        this->NormalizedTable->AddChildCache(this->VWSimilarityComputationTable, "VWSimilarityComputationTable", false);

        // Variable Weighting for Similarity LbV̏
        this->VWSimilarityComputationCache = new TCFbERowRowCachedTable(this->VWSimilarityComputationTable->GetRowLabelList(), this->VWSimilarityComputationTable->GetColumnLabelList());
        this->VWSimilarityComputationTable->AddChildCache(this->VWSimilarityComputationCache, "VWSimilarityComputationCache", true);


    } else {
        // SimilarityComputationTable ̏
        if (this->FAlgorithmBase == abRow) {    // User-based CF
            this->SimilarityComputationTable = new TCFbETableEx();
            this->SimilarityComputationTable->CopyAllElementsAndCache(this->NormalizedTable, false, false);
        } else {    // Item-based CF
            this->SimilarityComputationTable = new TCFbERotatedTableEx();
            this->SimilarityComputationTable->RotatedCopyAllElementsAndCache(this->NormalizedTable, false, false);
        }
    }
    this->NormalizedTable->AddChildCache(this->SimilarityComputationTable, "SimilarityComputationTable", false);

    // PredictionTable ̏
    if (this->FAlgorithmBase == abRow) {    // User-based CF
        this->PredictionTable = new TCFbETableEx();
        this->PredictionTable->CopyAllElementsAndCache(this->NormalizedTable, false, false);
    } else {    // Item-based CF
        this->PredictionTable = new TCFbERotatedTableEx();
        this->PredictionTable->RotatedCopyAllElementsAndCache(this->NormalizedTable, false, false);
    }
    this->NormalizedTable->AddChildCache(this->PredictionTable, "PredictionTable", false);

    // Variable Weighting for Prediction e[ȕ
    if (this->FVWPredictionAlgorithm != NULL) {
        if (this->FAlgorithmBase == abRow) {    // User-based CF
            this->VWPredictionTable = new TCFbERotatedTableEx();
            this->VWPredictionTable->RotatedCopyAllElementsAndCache(this->NormalizedTable, false, false);
        } else {    // Item-based CF
            this->VWPredictionTable = new TCFbETableEx();
            this->VWPredictionTable->CopyAllElementsAndCache(this->NormalizedTable, false, false);
        }

        // Variable Weighting for Prediction LbV̏
        this->VWPredictionCache = new TCFbERowRowCachedTable(this->VWPredictionTable->GetRowLabelList(), this->VWPredictionTable->GetColumnLabelList());
        this->VWPredictionTable->AddChildCache(this->VWPredictionCache, "VWPredictionCache", true);
        this->NormalizedTable->AddChildCache(this->VWPredictionTable, "VWPredictionTable", false);
    }

    // Inverse Case Frequency
    this->FInverseCaseFrequencyEnabled = InverseCaseFrequencyEnabled;
    if (this->FInverseCaseFrequencyEnabled) {
        for (int j = 0; j < this->SimilarityComputationTable->GetNumberOfColumns(); j++) {
            this->InverseCaseFrequencyForColumn(j);
        }
    }

    this->FCaseAmplifier = CaseAmplifier;

    // Similarity LbV̏
    this->SimilarityCache = new TCFbERowRowCachedTable(this->SimilarityComputationTable->GetRowLabelList(), this->SimilarityComputationTable->GetColumnLabelList());
    this->SimilarityComputationTable->AddChildCache(this->SimilarityCache, "SimilarityCache", true);

    // PredictedValue LbV̏
    if (this->FAlgorithmBase == abRow) {    // User-based CF
        this->PredictedValueCache = new TCFbETableEx(this->GetRowLabelList(), this->GetColumnLabelList());
    } else {    // Item-based CF
        this->PredictedValueCache = new TCFbERotatedTableEx(this->GetRowLabelList(), this->GetColumnLabelList());
    }
    this->PredictionTable->AddChildCache(this->PredictedValueCache, "PredictedValueCache", false);

    // vZLbV̒ǉ
    if (this->FSimilarityComputationAlgorithm != NULL) {
        this->FSimilarityComputationAlgorithm->PrepareCache(this->SimilarityComputationTable);
    }

    if (this->FPredictionAlgorithm != NULL) {
        this->FPredictionAlgorithm->PrepareCache(this->PredictionTable);
    }

    if (this->FVWSimilarityComputationAlgorithm != NULL) {
        this->FVWSimilarityComputationAlgorithm->PrepareCache(this->VWSimilarityComputationTable);
    }

    if (this->FVWPredictionAlgorithm != NULL) {
        this->FVWPredictionAlgorithm->PrepareCache(this->VWPredictionTable);
    }

    this->FIsPrepared = true;
}

//---------------------------------------------------------------------------
// TargetRowIndex ɑ΂ NearestNeigobors 𒲂ׂ
// TargetRowIndex: ގx𒲂ׂΏۂ̍s
// TargetColumnIndex: \Ώۂ̗iTargetColumnIndex ̒l Enabled łȂs Neighbors Ɋ܂߂Ȃ 
// NeighborList  Neigobors ގxɓĕԂ
// Ԃꂽ TObjectList  GetNearestNeighbors Ă񂾃NX폜Kv
void __fastcall TCFbEDataSetEx::GetNearestNeighbors(int TargetRowIndex, int TargetColumnIndex, int NeighborhoodSize, TObjectList* NeighborList)
{
    if (NeighborhoodSize == 0) {
        NeighborhoodSize = MaxInt;
    }

    for (int i = 0; i < this->SimilarityComputationTable->GetNumberOfRows(); i++) {
        if (this->PredictionTable->GetEnabledByIndex(i, TargetColumnIndex) && (i != TargetRowIndex)) {
            double Similarity = this->GetSimilarityByIndex(TargetRowIndex, i, TargetColumnIndex);

            int k = 0;
            while (k < NeighborList->Count) {
                if ( ((TCFbENeighbor*)NeighborList->Items[k])->GetSimilarity() < Similarity) {
                    break;
                }
                k++;
            }

            if (k < NeighborhoodSize) {
                if (NeighborList->Count >= NeighborhoodSize) {
                    NeighborList->Delete(NeighborList->Count - 1);
                }
                TCFbECell* CurrentSourceCell = (this->FAlgorithmBase == abRow) ? this->GetCellByIndex(i, TargetColumnIndex) : this->GetCellByIndex(TargetColumnIndex, i);
                double Value = CurrentSourceCell->GetEnabled() ? CurrentSourceCell->GetValue() : this->FDefaultValue;
                NeighborList->Insert(k, new TCFbENeighbor(this->PredictionTable->GetRowLabelList()->Strings[i], Similarity, this->PredictionTable->GetValueByIndex(i, TargetColumnIndex), Value));
            }
        }
    }
}

//---------------------------------------------------------------------------
// BaseDataSet ɂāCthis ɂȂVȗƂĒǉ
void __fastcall TCFbEDataSetEx::FillColumns(TCFbEDataSetEx* BaseDataSet)
{
    for (int j = 0; j < BaseDataSet->GetNumberOfColumns(); j++) {
        if (this->GetColumnLabelList()->IndexOf(BaseDataSet->GetColumnLabelList()->Strings[j]) == -1) {
            this->AddColumn(BaseDataSet->GetColumnLabelList()->Strings[j].c_str());
        }
    }
}

//---------------------------------------------------------------------------
// TargetDataSet Ǝѐ邩ǂ𒲂ׂ
bool __fastcall TCFbEDataSetEx::IsConsistentWith(TCFbEDataSetEx* TargetDataSet)
{
    if (this->GetNumberOfColumns() != TargetDataSet->GetNumberOfColumns()) {
        return false;
    }

    for (int j = 0; j < this->GetColumnLabelList()->Count; j++) {
        if (TargetDataSet->GetColumnLabelList()->IndexOf(this->GetColumnLabelList()->Strings[j]) == -1) {
            return false;
        }
    }
    return true;
}

//---------------------------------------------------------------------------
// ColumnIndex ڂ Ordering ꂽl Order  DisOrdering ĕԂ
double __fastcall TCFbEDataSetEx::DisOrderingEx(double Order, int ColumnIndex)
{
    TDoubleDynArray SortedOrders;
    if (this->FAlgorithmBase == abRow) {    // User-based
        this->PredictionTable->GetEnabledCellsInColumn(ColumnIndex, SortedOrders);
    } else {
        this->PredictionTable->GetEnabledCellsInRow(ColumnIndex, SortedOrders);
    }
    TCFbEToolkit::GetToolkit()->SortDoubleDynArray(SortedOrders, sdDescending);

    TDoubleDynArray SortedValues;
    this->GetEnabledCellsInColumn(ColumnIndex, SortedValues);
    TCFbEToolkit::GetToolkit()->SortDoubleDynArray(SortedValues, sdDescending);

    double ResultedValue = this->DisOrdering(Order, SortedOrders, SortedValues);
    SortedOrders.Length = 0;
    SortedValues.Length = 0;
    
    return ResultedValue;
}

//---------------------------------------------------------------------------
// TargetRowIndex, TargetColumnIndex ̃ZꎞI Enabled = false ɂ
void __fastcall TCFbEDataSetEx::TemporallyUnable(int TargetRowIndex, int TargetColumnIndex)
{
    if ((this->TemporallyUnableRowIndex >= 0) && (this->TemporallyUnableColumnIndex >= 0)) {
        this->RecoverEnabled();
    }

    if (this->GetEnabledByIndex(TargetRowIndex, TargetColumnIndex)) {
        this->TemporallyUnableRowIndex = TargetRowIndex;
        this->TemporallyUnableColumnIndex = TargetColumnIndex;
        this->TemporallyUnableValue = this->GetValueByIndex(TargetRowIndex, TargetColumnIndex);
        this->UnableElementByIndex(TargetRowIndex, TargetColumnIndex);
    } else {
        this->TemporallyUnableRowIndex = -1;
        this->TemporallyUnableColumnIndex = -1;
    }
}

//---------------------------------------------------------------------------
// ꎞI Enabled = false ɂĂZɂǂ
void __fastcall TCFbEDataSetEx::RecoverEnabled(void)
{
    if ((this->TemporallyUnableRowIndex < 0) && (this->TemporallyUnableColumnIndex < 0)) {
        return;
    }

    this->SetValueByIndex(this->TemporallyUnableRowIndex, this->TemporallyUnableColumnIndex, this->TemporallyUnableValue);
    this->TemporallyUnableRowIndex = -1;
    this->TemporallyUnableColumnIndex = -1;
}

//---------------------------------------------------------------------------
// ȉCprotected \bh̒`
//---------------------------------------------------------------------------
void __fastcall TCFbEDataSetEx::RePrepareCF(int TargetRowIndex, int TargetColumnIndex)
{
    if (!this->IsPrepared()) {
        return;
    }

    // ΏۃZ܂܂sE̐K蒼
    // Value / StandardizedValue / NormalizedValue / Order ̏
    this->NormalizedTable->CopyColumnFrom(this, TargetColumnIndex, true);

    switch (this->FValueBase) {
        case vbStandardizedValue:
        case vbNormalizedValue:
        case vbOrder:
            if (this->FValueBase == vbStandardizedValue) {
                this->PartialStandardize(NormalizedTable, TargetColumnIndex);
            } else if (this->FValueBase == vbNormalizedValue) {
                this->PartialNormalize(NormalizedTable, TargetColumnIndex);
            } else if (this->FValueBase == vbOrder) {
                this->PartialOrdering(NormalizedTable, TargetColumnIndex);
            }
            break;

        default:
            break;
    }

    // Default Value ̐ݒ
    if (this->FDefaultValueEnabled) {
        for (int i = 0; i < this->NormalizedTable->GetNumberOfRows(); i++) {
            if (!this->NormalizedTable->GetEnabledByIndex(i, TargetColumnIndex) && (i != TargetRowIndex)) {
                this->NormalizedTable->SetValueByIndex(i, TargetColumnIndex, this->FDefaultValue);
            }
        }
    }

    // Variable Weighting for Similarity Computation e[u̍XV
    if (this->FVWSimilarityComputationAlgorithm != NULL) {
        if (this->FAlgorithmBase == abRow) {    // User-based CF
            this->VWSimilarityComputationTable->CopyColumnAsRowFrom(this->NormalizedTable, TargetColumnIndex, false);
        } else {    // Item-based CF
            this->VWSimilarityComputationTable->CopyColumnFrom(this->NormalizedTable, TargetColumnIndex, false);
        }

        if (this->ConditionIndexForSimilarity == TargetColumnIndex) {
            this->SimilarityComputationTable->UnableAllElements();
            this->ConditionIndexForSimilarity = -1;

        } else if (this->ConditionIndexForSimilarity >= 0) {
            if (this->FAlgorithmBase == abRow) {
                double VWSimilarityOfColumn = this->GetVWSimilarityOfColumn(this->ConditionIndexForSimilarity, TargetColumnIndex);
                for (int i = 0; i < this->SimilarityComputationTable->GetRowLabelList()->Count; i++) {
                    TCFbECell* CurrentCell = this->NormalizedTable->GetCellByIndex(i, TargetColumnIndex);
                    if (CurrentCell->GetEnabled()) {
                        this->SimilarityComputationTable->SetValueByIndex(i, TargetColumnIndex, CurrentCell->GetValue() * VWSimilarityOfColumn);
                    }
                }
            } else {
                double VWSimilarityOfColumn = this->GetVWSimilarityOfColumn(this->ConditionIndexForSimilarity, TargetRowIndex);
                for (int j = 0; j < this->SimilarityComputationTable->GetColumnLabelList()->Count; j++) {
                    TCFbECell* CurrentCell = this->NormalizedTable->GetCellByIndex(TargetRowIndex, j);
                    if (CurrentCell->GetEnabled()) {
                        this->SimilarityComputationTable->SetValueByIndex(TargetRowIndex, j, CurrentCell->GetValue() * VWSimilarityOfColumn);
                    }
                }
            }
        }

    } else {
        // SimilarityComputationTable ̍XV
        if (this->FAlgorithmBase == abRow) {    // User-based CF
            this->SimilarityComputationTable->CopyColumnFrom(this->NormalizedTable, TargetColumnIndex, false);
        } else {    // Item-based CF
            this->SimilarityComputationTable->CopyColumnAsRowFrom(this->NormalizedTable, TargetColumnIndex, false);
        }
    }

    // PredictionTable ̍XV
    if (this->FAlgorithmBase == abRow) {    // User-based CF
        this->PredictionTable->CopyColumnFrom(this->NormalizedTable, TargetColumnIndex, false);
    } else {    // Item-based CF
        this->PredictionTable->CopyColumnAsRowFrom(this->NormalizedTable, TargetColumnIndex, false);
    }

    // PredictedValueCache ̍XV
//    this->PredictedValueCache->UnableAllElements();

    // Variable Weighting for Prediction e[u̍XV
    if (this->FVWPredictionAlgorithm != NULL) {
        if (this->FAlgorithmBase == abRow) {    // User-based CF
            this->VWPredictionTable->CopyColumnAsRowFrom(this->NormalizedTable, TargetColumnIndex, false);
        } else {    // Item-based CF
            this->VWPredictionTable->CopyColumnFrom(this->NormalizedTable, TargetColumnIndex, false);
        }
    }

    // Inverse Case Frequency
    if (this->FInverseCaseFrequencyEnabled) {
        this->InverseCaseFrequencyForColumn(TargetColumnIndex);
    }
}

//---------------------------------------------------------------------------
// TargetColumnIndex ڂ̑Svf Inverse Case Frequency Kp
void __fastcall TCFbEDataSetEx::InverseCaseFrequencyForColumn(int TargetColumnIndex)
{
    double ICFCoefficient = this->SimilarityComputationTable->GetICFCoefficient(TargetColumnIndex);
    for (int i = 0; i < this->SimilarityComputationTable->GetNumberOfRows(); i++) {
        if (this->SimilarityComputationTable->GetEnabledByIndex(i, TargetColumnIndex)) {
            this->SimilarityComputationTable->SetValueByIndex(i, TargetColumnIndex, this->SimilarityComputationTable->GetValueByIndex(i, TargetColumnIndex) * ICFCoefficient);
        }
    }
}

//---------------------------------------------------------------------------

