/*
    TCFbEOutputFormatter.cpp    June 6, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "TCFbEOutputFormatter.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
// RXgN^iargc  argv ɂăR}hC^
__fastcall TCFbEOutputFormatter::TCFbEOutputFormatter(TCFbEDocfbeCommandLineParser* Parser, TCFbEOutputCache* OutputCache, bool IsVerbose)
{
    this->Parser = Parser;
    this->OutputCache = OutputCache;

    this->FOutputStringList = new TStringList();

    try {
        if (IsVerbose) {
            fprintf(stderr, "(4/4) Outputting results.\n");
            fprintf(stderr, "    ..... completed:  0.00\%");
        }

        this->OutputHeader();

        // \ʂ̏o
        for (int i = 0; i < OutputCache->GetNumberOfRows(); i++) {
            this->OutputBody(i);

            if (IsVerbose) {
                fprintf(stderr, "\b\b\b\b\b\b%5.2f\%", (double)i / (double)OutputCache->GetNumberOfRows() * 100.0);
            }
        }

        if (IsVerbose) {
            fprintf(stderr, "\b\b\b\b\b\b100.00\%\n\n");
        }
    } catch (...) {
        delete this->FOutputStringList;
        throw;
    }
}

//---------------------------------------------------------------------------
__fastcall TCFbEOutputFormatter::~TCFbEOutputFormatter()
{
    delete this->FOutputStringList;
}

//---------------------------------------------------------------------------
AnsiString __fastcall TCFbEOutputFormatter::GetOutputString(void)
{
    return this->FOutputStringList->Text;
}

//---------------------------------------------------------------------------
// OutputString  FileName ̃t@Cɕۑ
void __fastcall TCFbEOutputFormatter::SaveOutputStringTo(TFileName FileName)
{
    this->FOutputStringList->SaveToFile(FileName);
}

//---------------------------------------------------------------------------

