/*
    TCFbERecommendationOutputFormatter.cpp    June 6, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "TCFbERecommendationOutputFormatter.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
// RXgN^iargc  argv ɂăR}hC^
__fastcall TCFbERecommendationOutputFormatter::TCFbERecommendationOutputFormatter(TCFbEDocfbeCommandLineParser* Parser, TCFbEOutputCache* OutputCache, bool IsVerbose)
    : TCFbEOutputFormatter(Parser, OutputCache, IsVerbose)
{
}

//---------------------------------------------------------------------------
__fastcall TCFbERecommendationOutputFormatter::~TCFbERecommendationOutputFormatter()
{
}

//---------------------------------------------------------------------------
// wb_ this->FOutputStringList ɒǉDwb_KvłȂꍇ͂ return D
void __fastcall TCFbERecommendationOutputFormatter::OutputHeader(void)
{
    // xo
    this->FOutputStringList->Add("Label");
    this->FOutputStringList->Add("");
    this->FOutputStringList->Add("Recommended Item's Label,Score");
    this->FOutputStringList->Add("");

    // "l̕z" x̏o
    if (this->Parser->DisplayDistribution) {
        this->FOutputStringList->Add("Distributions of Similarities");
        this->FOutputStringList->Add("");
    }

    // "Neighbor̃x" x̏o
    AnsiString    ALine = "Neighbors'";
    if (this->Parser->DisplayNeighbors) {
        ALine += " Label";
    }

    // "Neighbor̗ގx" x̏o
    if (this->Parser->DisplaySimilarities) {
        ALine += (ALine != "Neighbors'") ? ",Similarity" : " Similarity";
    }

    // "Neighbor̒l" x̏o
    if (this->Parser->DisplayValues) {
        ALine += (ALine != "Neighbors'") ? ",Value" : " Value";
    }

    if (ALine != "Neighbors'") {
        this->FOutputStringList->Add(ALine);
        this->FOutputStringList->Add("");
    }

    this->FOutputStringList->Add("");
}

//---------------------------------------------------------------------------
// {fB this->FOutputStringList ɒǉD
void __fastcall TCFbERecommendationOutputFormatter::OutputBody(int TargetRowIndex)
{
    // sx̏o
    this->FOutputStringList->Add(this->OutputCache->GetResultRowLabel(TargetRowIndex));
    this->FOutputStringList->Add("");

    // \ʂ̒l̏o
    TList*    SortedResultList = new TList();
    this->GetSortedResultList(TargetRowIndex, SortedResultList);
    for (int i = 0; i < SortedResultList->Count; i++) {
        TCFbERecommendedItem*    Item = (TCFbERecommendedItem*)SortedResultList->Items[i];
        this->FOutputStringList->Add(Item->GetLabel() + "," + FloatToStr(Item->GetPredictedValue()));
    }
    delete SortedResultList;
    this->FOutputStringList->Add("");

    // ގx̕z̏o
    if (this->Parser->DisplayDistribution) {
        AnsiString    ALine = IntToStr(this->OutputCache->GetDistribution(TargetRowIndex, 19));
        for (int k = 18; k >= 0; k--) {
            ALine += "," + IntToStr(this->OutputCache->GetDistribution(TargetRowIndex, k));
        }
        this->FOutputStringList->Add(ALine);
        this->FOutputStringList->Add("");
    }

    if (this->Parser->DisplayNeighbors || this->Parser->DisplaySimilarities || this->Parser->DisplayValues) {
        for (int k = 0; k < this->OutputCache->GetNumberOfNeighbors(TargetRowIndex); k++) {
            TCFbENeighbor*    Neighbor = this->OutputCache->GetNeighbor(TargetRowIndex, k);

            // Neighbor̃x̏o
            AnsiString    ALine;
            if (this->Parser->DisplayNeighbors) {
                ALine += Neighbor->GetLabel();
            }

            // Neighbor̗ގx̏o
            if (this->Parser->DisplaySimilarities) {
                if (!ALine.IsEmpty()) {
                    ALine += ",";
                }
                ALine += FloatToStr(Neighbor->GetSimilarity());
            }

            // Neighbor̒l̏o
            if (this->Parser->DisplayValues) {
                if (!ALine.IsEmpty()) {
                    ALine += ",";
                }
                ALine += FloatToStr(Neighbor->GetSourceValue());
            }

            this->FOutputStringList->Add(ALine);
        }

        this->FOutputStringList->Add("");
    }

    this->FOutputStringList->Add("");
}

//---------------------------------------------------------------------------
// ȉCprotected \bh̒`
//---------------------------------------------------------------------------
// RowIndex Ԗڂ̍šʂ\[gCSortedResultList ɓĕԂ
void __fastcall TCFbERecommendationOutputFormatter::GetSortedResultList(int RowIndex, TList* SortedResultList)
{
    for (int j = 0; j < this->OutputCache->GetNumberOfColumns(); j++) {
        if (this->OutputCache->GetResultEnabled(RowIndex, j)) {
            TCFbERecommendedItem*    Item = new TCFbERecommendedItem(this->OutputCache->GetResultColumnLabel(j), this->OutputCache->GetResultValue(RowIndex, j));
            SortedResultList->Add(Item);
        }
    }
    SortedResultList->Sort(CompareRecommendedItem);
}

//---------------------------------------------------------------------------

