/*
    TCFbERecommendedItem.h    June 6, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbERecommendedItemH
#define TCFbERecommendedItemH
//---------------------------------------------------------------------------
#include <system.hpp>
#include <Contnrs.hpp>
#include "TCFbEToolkit.h"
//---------------------------------------------------------------------------
class TCFbERecommendedItem : public TObject
{
public:
    virtual __fastcall TCFbERecommendedItem(AnsiString Label, double PredictedValue);    // RXgN^
    __fastcall ~TCFbERecommendedItem();    // fXgN^

    virtual AnsiString  GetLabel(void) { return this->FLabel; }
    virtual double      GetPredictedValue(void) { return this->FPredictedValue; }
    
protected:
    AnsiString  FLabel;
    double      FPredictedValue;

private:

};

//---------------------------------------------------------------------------
// TCFbERecommendedItem ̔r֐
//---------------------------------------------------------------------------
// ~\[g
// > 0 ()    Item1  Item2 菬
//   0    Item1  Item2 
// < 0 ()    Item1  Item2 傫
int __fastcall CompareRecommendedItem(void *Item1, void *Item2)
{
    if (TCFbEToolkit::GetToolkit()->Equals(((TCFbERecommendedItem*)Item1)->GetPredictedValue(), ((TCFbERecommendedItem*)Item2)->GetPredictedValue())) {
        return 0;
    } else if ( ((TCFbERecommendedItem*)Item1)->GetPredictedValue() < ((TCFbERecommendedItem*)Item2)->GetPredictedValue()) {
        return 1;
    } else {
        return -1;
    }
}

//---------------------------------------------------------------------------
#endif
