/*
    TCFbEToolkit.cpp    June 6, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#pragma hdrstop

#include "TCFbEToolkit.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
// ȉpublic\bh
//---------------------------------------------------------------------------
// RXgN^
__fastcall TCFbEToolkit::TCFbEToolkit()
    : TObject()
{
    this->DebugStringList = new TStringList();  
}

//---------------------------------------------------------------------------
// fXgN^
__fastcall TCFbEToolkit::~TCFbEToolkit()
{
    if (this->DebugStringList->Count > 0) {
        this->DebugStringList->SaveToFile(ExtractFilePath(Application->ExeName) + "debug.txt");
    }
    delete this->DebugStringList;
}

//---------------------------------------------------------------------------
// t@Ng\bhCVOgƂĎTCFbEToolkit𓾂Ƃ̃\bh@
TCFbEToolkit* __fastcall TCFbEToolkit::GetToolkit() {
    if (TCFbEToolkit::Instance == NULL) {    // CX^X݂Ȃ
        TCFbEToolkit::Instance = new TCFbEToolkit();
    }
    return TCFbEToolkit::Instance;
}

//---------------------------------------------------------------------------
// c[Lbg
void __fastcall TCFbEToolkit::DeleteToolkit()
{
    if (TCFbEToolkit::Instance != NULL) {    // CX^X݂
        delete TCFbEToolkit::Instance;        // 
    }
}

//---------------------------------------------------------------------------
// TList^̃Rs[
void __fastcall TCFbEToolkit::CopyList(TList* SourceList, TList* DestinationList)
{
    DestinationList->Clear();
    for (int i = 0; i < SourceList->Count; i++) {
        DestinationList->Add(SourceList->Items[i]);
    }
}

//---------------------------------------------------------------------------
// Font0  Font1 ̃tHg true 𓙂Ȃ false Ԃ܂D
bool __fastcall TCFbEToolkit::Equals(TFont* Font0, TFont* Font1)
{
    if ((Font0->Name == Font1->Name) && (Font0->Size == Font1->Size) && (Font0->Height == Font1->Height) && (Font0->Color == Font1->Color) && (Font0->Pitch == Font1->Pitch) && (Font0->Charset == Font1->Charset)) {
        return true;
    }
    return false;
}

//---------------------------------------------------------------------------
// Value0  Value1 rD덷 ErrorRange ȉȂ瓙Ƃ
bool __fastcall TCFbEToolkit::Equals(double Value0, double Value1, double ErrorRange)
{
    return fabs(Value0 - Value1) <= ErrorRange;
}

//---------------------------------------------------------------------------
// AvP[V݂fBNgɃfobOt@Ci"debug.txt"jo͂
void __fastcall TCFbEToolkit::DebugOutput(AnsiString OutputString)
{
    this->DebugStringList->Add(OutputString);
}

//---------------------------------------------------------------------------
// AvP[ṼvCIeBύX
void __fastcall TCFbEToolkit::SetApplicationPriority(TThreadPriority Priority)
{
    unsigned long ProcessID = GetCurrentProcessId();
    void* ProcessHandle = OpenProcess(PROCESS_SET_INFORMATION, false, ProcessID);
    void* ThreadHandle = GetCurrentThread();

    switch (Priority) {
        case tpIdle:
            SetPriorityClass(ProcessHandle, IDLE_PRIORITY_CLASS);
            SetThreadPriority(ThreadHandle, THREAD_PRIORITY_IDLE);
            break;

        case tpLowest:
            SetPriorityClass(ProcessHandle, BELOW_NORMAL_PRIORITY_CLASS);
            SetThreadPriority(ThreadHandle, THREAD_PRIORITY_LOWEST);
            break;

        case tpLower:
            SetPriorityClass(ProcessHandle, BELOW_NORMAL_PRIORITY_CLASS);
            SetThreadPriority(ThreadHandle, THREAD_PRIORITY_BELOW_NORMAL);
            break;

        case tpNormal:
            SetPriorityClass(ProcessHandle, NORMAL_PRIORITY_CLASS);
            SetThreadPriority(ThreadHandle, THREAD_PRIORITY_NORMAL);
            break;

        case tpHigher:
            SetPriorityClass(ProcessHandle, ABOVE_NORMAL_PRIORITY_CLASS);
            SetThreadPriority(ThreadHandle, THREAD_PRIORITY_ABOVE_NORMAL);
            break;

        case tpHighest:
            SetPriorityClass(ProcessHandle, HIGH_PRIORITY_CLASS);
            SetThreadPriority(ThreadHandle, THREAD_PRIORITY_HIGHEST);
            break;

        case tpTimeCritical:
            SetPriorityClass(ProcessHandle, REALTIME_PRIORITY_CLASS);
            SetThreadPriority(ThreadHandle, THREAD_PRIORITY_TIME_CRITICAL);
            break;
        default:
            break;
    }
}

//---------------------------------------------------------------------------
// DynArray \[g
// sdAscending    ̃\[g
// sdDescending    ~̃\[g
void __fastcall TCFbEToolkit::SortDoubleDynArray(TDoubleDynArray& DynArray, TSortDirection Direction)
{
    if (Direction == sdAscending) {
        for (int i = 0; i < DynArray.Length - 1; i++) {
            for (int j = i + 1; j < DynArray.Length; j++) {
                if (DynArray[i] > DynArray[j]) {
                    double Buffer = DynArray[i];
                    DynArray[i] = DynArray[j];
                    DynArray[j] = Buffer;
                }
            }
        }
    } else {
        for (int i = 0; i < DynArray.Length - 1; i++) {
            for (int j = i + 1; j < DynArray.Length; j++) {
                if (DynArray[i] < DynArray[j]) {
                    double Buffer = DynArray[i];
                    DynArray[i] = DynArray[j];
                    DynArray[j] = Buffer;
                }
            }
        }
    }
}

//---------------------------------------------------------------------------
// DynArray ̗vf̕ϒlԂ
double __fastcall TCFbEToolkit::GetAverageOfDynArray(TDoubleDynArray& DynArray)
{
    if (DynArray.Length == 0) {
        return 0.0;
    }
    
    double Sum = 0.0;
    for (int k = 0; k < DynArray.Length; k++) {
        Sum += DynArray[k];
    }
    return Sum / DynArray.Length;
}

//---------------------------------------------------------------------------
// DynArray ̗vf̒ԒlԂiDynArray ̓\[gĂKv
double __fastcall TCFbEToolkit::GetMedianOfDynArray(TDoubleDynArray& DynArray)
{
    if (DynArray.Length != 0) {
        // Metrics̐
        if ( DynArray.Length % 2 == 1 ) {
            // ̏ꍇAԗvf̒l
            return DynArray[(DynArray.Length - 1 ) / 2];
        } else {
            // ̏ꍇAԗvfQ̕
            return (DynArray[DynArray.Length/2-1] + DynArray[DynArray.Length/2]) / 2.0;
        }
    }

    return 0.0;
}

//---------------------------------------------------------------------------
// CSV`̕TStringsɕ
void __fastcall TCFbEToolkit::CsvToStrings(AnsiString str,TStrings *List)
{
    AnsiString tmp;       // e
    bool quote=false;     // p

    List->Clear();        // Xg̃NA

    for(int i=1;i<=str.Length();i++){
        if(IsDBCSLeadByte(str[i])==TRUE){    //̂PoCgځH
            tmp += str[i];
            if(i<str.Length()){
                i++;
                tmp += str[i];
            }
        } else if(this->IsQuote(str[i])){    //p
            if(i<str.Length() && this->IsQuote(str[i+1]))
              str+="\"";
            else
              quote=!quote;
        } else if(quote==false && this->IsDelimiter(str[i])) {    //؂蕶
            List->Add(tmp.Trim());
            tmp="";
//        } else if(quote==false && isspace(str[i])) {    //(KvȁH)
//            ;
        } else {//̑
            tmp += str[i];
        }
    }

    List->Add(tmp.Trim());
}

//---------------------------------------------------------------------------
// Array  Index1  Index2 ̗vfւ
void __fastcall TCFbEToolkit::Exchange(TDoubleDynArray& Array, int Index1, int Index2)
{
    double Buffer = Array[Index1];
    Array[Index1] = Array[Index2];
    Array[Index2] = Buffer;
}
                                                 
//---------------------------------------------------------------------------
// t@C̃o[W擾֐
AnsiString __fastcall TCFbEToolkit::GetExeVersion(AnsiString FileName)
{
    DWORD dwSize;
    DWORD dwReserved;
    LPVOID lpBuffer;
    AnsiString version;

    dwSize = ::GetFileVersionInfoSize(FileName.c_str(), &dwReserved);
    lpBuffer = ::HeapAlloc(::GetProcessHeap(), HEAP_ZERO_MEMORY, dwSize );
    if( lpBuffer && ::GetFileVersionInfo(Application->ExeName.c_str(), 0, dwSize, lpBuffer )) {
        LPVOID lpStr;
        UINT dwLength;

        ::VerQueryValue( lpBuffer, "\\StringFileInfo\\041103A4\\FileVersion", &lpStr, &dwLength );
        version = (LPTSTR)lpStr;
    }
    if(lpBuffer){
        ::HeapFree( ::GetProcessHeap(), 0, lpBuffer );
    }
    return version;
}

//---------------------------------------------------------------------------
// Rs[CgԂ֐
AnsiString __fastcall TCFbEToolkit::GetCopyrightStr(AnsiString ApplicationName)
{
    return ApplicationName + " " + GetExeVersion(Application->ExeName) + "\n"
        + "Copyright (C) 2003-2005 CFbE Research Group,\n"
        + "Software Engineering Laboratory,\n"
        + "Graduate School of Information Science,\n"
        + "Nara Institute of Science and Technology, All rights reserved.\n";
}

//---------------------------------------------------------------------------

