<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- 2003/07/08 CSTI 日本語化対応 v0.5 -->
	
	<!-- -->
	<xsl:output method="html" indent="no" />
	<!-- -->
	<xsl:include href="common.xslt" />
	<!-- -->
	<xsl:param name='type-id' />
	<!-- -->
	<xsl:template match="/">
		<xsl:apply-templates select="ndoc/assembly/module/namespace/*[@id=$type-id]" />
	</xsl:template>
	<!-- -->
	<xsl:template name="indent">
		<xsl:param name="count" />
		<xsl:if test="$count &gt; 0">
			<xsl:text>&#38;nbsp&#59;&#38;nbsp&#59;&#38;nbsp&#59;</xsl:text>
			<xsl:call-template name="indent">
				<xsl:with-param name="count" select="$count - 1" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!-- -->
	<xsl:template name="draw-hierarchy">
		<xsl:param name="list" />
		<xsl:param name="level" />
		<!-- this is commented out because XslTransform is throwing an InvalidCastException in it. -->
		<xsl:if test="count($list) &gt; 0">
			<!-- last() is causing an InvalidCastException in Beta 2. -->
			<xsl:variable name="last" select="count($list)" />
			<xsl:call-template name="indent">
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
			
			<xsl:choose>
				<xsl:when test="starts-with($list[$last]/@type, 'System.')">
					<a>
						<xsl:attribute name="href">
							<xsl:call-template name="get-filename-for-system-type">
								<xsl:with-param name="type-name" select="$list[$last]/@type" />
							</xsl:call-template>
						</xsl:attribute>
						<xsl:call-template name="get-datatype">
							<xsl:with-param name="datatype" select="$list[$last]/@type" />
						</xsl:call-template>
					</a>
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="base-class-id" select="string($list[$last]/@id)" />
					<xsl:variable name="base-class" select="//class[@id=$base-class-id]" />
					<xsl:choose>
						<xsl:when test="$base-class">
							<a>
								<xsl:attribute name="href">
									<xsl:call-template name="get-filename-for-type">
										<xsl:with-param name="id" select="$list[$last]/@id" />
									</xsl:call-template>
								</xsl:attribute>
								<xsl:call-template name="get-datatype">
									<xsl:with-param name="datatype" select="$list[$last]/@type" />
								</xsl:call-template>
							</a>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="get-datatype">
								<xsl:with-param name="datatype" select="$list[$last]/@type" />
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
			<br />
			<xsl:call-template name="draw-hierarchy">
				<xsl:with-param name="list" select="$list[position()!=$last]" />
				<xsl:with-param name="level" select="$level + 1" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!-- -->
	<xsl:template match="class">
		<xsl:call-template name="type">
			<xsl:with-param name="type">クラス</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	<!-- -->
	<xsl:template match="interface">
		<xsl:call-template name="type">
			<xsl:with-param name="type">インターフェイス</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	<!-- -->
	<xsl:template match="structure">
		<xsl:call-template name="type">
			<xsl:with-param name="type">構造体</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	<!-- -->
	<xsl:template match="delegate">
		<xsl:call-template name="type">
			<xsl:with-param name="type">デリゲート</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	<!-- -->
	<xsl:template match="enumeration">
		<xsl:call-template name="type">
			<xsl:with-param name="type">列挙型</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	<!-- -->
	<xsl:template name="type">
		<xsl:param name="type" />
		<html dir="LTR">
			<xsl:call-template name="html-head">
				<xsl:with-param name="title" select="concat(@name, ' ', $type)" />
			</xsl:call-template>
			<body id="bodyID" class="dtBODY">
				<xsl:call-template name="title-row">
					<xsl:with-param name="type-name" select="concat(@name, ' ', $type)" />
				</xsl:call-template>
				<div id="nstext">
					<xsl:call-template name="summary-section" />
					<xsl:if test="local-name()!='delegate' and local-name()!='enumeration'">
						<xsl:variable name="members-href">
							<xsl:call-template name="get-filename-for-type-members">
								<xsl:with-param name="id" select="@id" />
							</xsl:call-template>
						</xsl:variable>
						<xsl:if test="constructor|field|property|method|operator|event">
							<p>この型のすべてのメンバの一覧については、<a href="{$members-href}"><xsl:value-of select="@name" /> メンバ</a> を参照してください。</p>
						</xsl:if>
					</xsl:if>
					<xsl:if test="local-name() != 'delegate' and local-name() != 'enumeration'">
						<p>
							<xsl:choose>
								<xsl:when test="self::interface">
									<xsl:if test="base">
										<xsl:call-template name="draw-hierarchy">
											<xsl:with-param name="list" select="descendant::base" />
											<xsl:with-param name="level" select="0" />
										</xsl:call-template>
										<xsl:call-template name="indent">
											<xsl:with-param name="count" select="count(descendant::base)" />
										</xsl:call-template>
										<b>
											<xsl:value-of select="@name" />
										</b>
									</xsl:if>
								</xsl:when>
								<xsl:otherwise>
									<xsl:variable name="href">
										<xsl:call-template name="get-filename-for-system-type">
											<xsl:with-param name="type-name" select="'System.Object'" />
										</xsl:call-template>
									</xsl:variable>
									<a href="{$href}">System.Object</a>
									<br />
									<xsl:call-template name="draw-hierarchy">
										<xsl:with-param name="list" select="descendant::base" />
										<xsl:with-param name="level" select="1" />
									</xsl:call-template>
									<xsl:call-template name="indent">
										<xsl:with-param name="count" select="count(descendant::base) + 1" />
									</xsl:call-template>
									<b>
										<xsl:value-of select="@name" />
									</b>
								</xsl:otherwise>
							</xsl:choose>
						</p>
					</xsl:if>
					<xsl:call-template name="vb-type-syntax" />
					<xsl:call-template name="cs-type-syntax" />
					<xsl:if test="local-name() = 'delegate'">
						<xsl:call-template name="parameter-section" />
						<xsl:call-template name="returnvalue-section" />
					</xsl:if>
					<xsl:call-template name="remarks-section" />
					<xsl:call-template name="example-section" />
					<xsl:if test="local-name() = 'enumeration'">
						<xsl:call-template name="members-section" />
					</xsl:if>
					<h4 class="dtH4">必要条件</h4>
					<p>
						<b>名前空間: </b>
						<a>
							<xsl:attribute name="href">
								<xsl:call-template name="get-filename-for-namespace">
									<xsl:with-param name="name" select="../@name" />
								</xsl:call-template>
							</xsl:attribute>
							<xsl:value-of select="../@name" />
						</a>
					</p>
					<p>
						<b>アセンブリ: </b>
						<xsl:value-of select="../../../@name" /> (<xsl:value-of select="../../@name" /> 内)
					</p>
					<xsl:if test="documentation/permission">
						<p>
							<b>.NET Framework セキュリティ: </b>
							<ul class="permissions">
								<xsl:for-each select="documentation/permission">
									<li>
										<a>
											<xsl:attribute name="href">
												<xsl:call-template name="get-filename-for-type-name">
													<xsl:with-param name="type-name" select="substring-after(@cref, 'T:')" />
												</xsl:call-template>
											</xsl:attribute>
											<xsl:value-of select="substring-after(@cref, 'T:')" />
										</a>
										<xsl:text>&#38;nbsp&#59;</xsl:text>
										<xsl:apply-templates mode="slashdoc" />
									</li>
								</xsl:for-each>
							</ul>
						</p>
					</xsl:if>
					<xsl:variable name="page">
						<xsl:choose>
							<xsl:when test="local-name() = 'enumeration'">列挙型</xsl:when>
							<xsl:when test="local-name() = 'delegate'">デリゲート</xsl:when>
							<xsl:otherwise>type</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:call-template name="seealso-section">
						<xsl:with-param name="page" select="$page" />
					</xsl:call-template>
					
					<xsl:if test="not($ndoc-omit-object-tags)">
						<object type="application/x-oleobject" classid="clsid:1e2a7bd0-dab9-11d0-b93a-00c04fc99f9e" viewastext="true" style="display: none;">
							<xsl:choose>
								<xsl:when test="local-name() = 'enumeration'">
									<xsl:element name="param">
										<xsl:attribute name="name">Keyword</xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="concat(@name, ' 列挙型')" /></xsl:attribute>
									</xsl:element>
									<xsl:element name="param">
										<xsl:attribute name="name">Keyword</xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="concat(substring-after(@id, ':'), ' 列挙型')" /></xsl:attribute>
									</xsl:element>
									<xsl:for-each select="field">
										<xsl:element name="param">
											<xsl:attribute name="name">Keyword</xsl:attribute>
											<xsl:attribute name="value"><xsl:value-of select="concat(@name, ' 列挙型メンバ')" /></xsl:attribute>
										</xsl:element>
										<xsl:element name="param">
											<xsl:attribute name="name">Keyword</xsl:attribute>
											<xsl:attribute name="value"><xsl:value-of select="concat(../@name, '.', @name, ' 列挙型メンバ')" /></xsl:attribute>
										</xsl:element>
									</xsl:for-each>
								</xsl:when>
								<xsl:when test="local-name() = 'delegate'">
									<xsl:element name="param">
										<xsl:attribute name="name">Keyword</xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="concat(@name, ' デリゲート')" /></xsl:attribute>
									</xsl:element>
									<xsl:element name="param">
										<xsl:attribute name="name">Keyword</xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="concat(substring-after(@id, ':'), ' デリゲート')" /></xsl:attribute>
									</xsl:element>
								</xsl:when>
								<xsl:when test="local-name() = 'class'">
									<xsl:element name="param">
										<xsl:attribute name="name">Keyword</xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="concat(@name, ' ', local-name(), ',', @name, ' クラスについて')" /></xsl:attribute>
									</xsl:element>
								</xsl:when>
								<xsl:otherwise>
									<xsl:element name="param">
										<xsl:attribute name="name">Keyword</xsl:attribute>
										<xsl:attribute name="value"><xsl:value-of select="concat(@name, ' ', local-name(), ',', @name, ' ', local-name(), 'について')" /></xsl:attribute>
									</xsl:element>
								</xsl:otherwise>
							</xsl:choose>
						</object>
					</xsl:if>
					
					<xsl:call-template name="footer-row">
						<xsl:with-param name="type-name" select="concat(@name, ' ', $type)" />
					</xsl:call-template>
				</div>
			</body>
		</html>
	</xsl:template>
	<!-- -->
</xsl:stylesheet>
