/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.trolltech.qt.gui.QCheckBox;
import com.trolltech.qt.gui.QComboBox;
import com.trolltech.qt.gui.QGroupBox;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QSpinBox;
import com.trolltech.qt.gui.QTextBrowser;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.Global;

public class ConfigDebugPage
extends QWidget {
    QComboBox messageCombo;
    QComboBox serverCombo;
    QCheckBox disableUploads;
    QCheckBox carriageReturnFix;
    QCheckBox htmlEntitiesFix;
    QCheckBox enableThumbnails;
    QSpinBox databaseCache;
    QCheckBox reloadSharedNotebooks;

    public ConfigDebugPage(QWidget parent) {
        super(parent);
        QGroupBox serverGroup = new QGroupBox(this.tr("Server Configuration"));
        QLabel serverLabel = new QLabel(this.tr("Server"));
        this.serverCombo = new QComboBox();
        this.serverCombo.addItem("www.evernote.com");
        this.serverCombo.addItem("sandbox.evernote.com");
        this.disableUploads = new QCheckBox();
        this.disableUploads.setText(this.tr("Disable uploads to server"));
        QHBoxLayout serverLayout = new QHBoxLayout();
        serverLayout.addWidget((QWidget)serverLabel);
        serverLayout.addWidget((QWidget)this.serverCombo);
        serverLayout.addWidget((QWidget)this.disableUploads);
        serverGroup.setLayout((QLayout)serverLayout);
        QLabel messageLevelLabel = new QLabel(this.tr("Message Level"));
        this.messageCombo = new QComboBox();
        this.messageCombo.addItem(this.tr("Low"), (Object)"Low");
        this.messageCombo.addItem(this.tr("Medium"), (Object)"Medium");
        this.messageCombo.addItem(this.tr("High"), (Object)"High");
        this.messageCombo.addItem(this.tr("Extreme"), (Object)"Extreme");
        QHBoxLayout messageLayout = new QHBoxLayout();
        messageLayout.addWidget((QWidget)messageLevelLabel);
        messageLayout.addWidget((QWidget)this.messageCombo);
        messageLayout.setStretch(1, 100);
        QHBoxLayout databaseCacheLayout = new QHBoxLayout();
        this.databaseCache = new QSpinBox();
        databaseCacheLayout.addWidget((QWidget)new QLabel(this.tr("Database Cache (MB) - Requires restart")));
        this.databaseCache.setMinimum(4);
        this.databaseCache.setMaximum(128);
        this.databaseCache.setValue(new Integer(Global.databaseCache) / 1024);
        databaseCacheLayout.addWidget((QWidget)this.databaseCache);
        databaseCacheLayout.setStretch(1, 100);
        QVBoxLayout mainLayout = new QVBoxLayout();
        mainLayout.addLayout((QLayout)messageLayout);
        mainLayout.addLayout((QLayout)databaseCacheLayout);
        QHBoxLayout thumbnailLayout = new QHBoxLayout();
        QLabel thumbnailLabel = new QLabel(this.tr("Enable Thumbnails (experimental)"));
        thumbnailLayout.addWidget((QWidget)thumbnailLabel);
        this.enableThumbnails = new QCheckBox((QWidget)this);
        thumbnailLayout.addWidget((QWidget)this.enableThumbnails);
        mainLayout.addLayout((QLayout)thumbnailLayout);
        mainLayout.addWidget((QWidget)serverGroup);
        QGroupBox crlfGroup = new QGroupBox(this.tr("Carriage Return Fix"));
        String crlfMessage = new String(this.tr("Note: The carriage return is a test fix.  If you enable it, it will do some modifications to the notes you view to try and get the carriage returns to look correct.  This is due to the way that the way Evernote 3.1 Windows client is dealing with carriage returns.  This fixwill try and correct this problem.  This fix is not permanent unless you edit a note.  Ifyou edit a note, this fix is PERMANENT and will be sent to Evernote on the next sync.  I haven'thad any issues with this, but please be aware of this condition."));
        this.carriageReturnFix = new QCheckBox((QWidget)this);
        QVBoxLayout crlfLayout = new QVBoxLayout();
        this.carriageReturnFix.setText(this.tr("Enable Carriage Return Fix"));
        crlfLayout.addWidget((QWidget)this.carriageReturnFix);
        crlfGroup.setLayout((QLayout)crlfLayout);
        QGroupBox htmlGroup = new QGroupBox(this.tr("Android Note Fix"));
        String entitiesMessage = new String(this.tr("Note: This is an experimental fix to correct Unicode notes created on Android Evernote clients."));
        this.htmlEntitiesFix = new QCheckBox((QWidget)this);
        QVBoxLayout htmlLayout = new QVBoxLayout();
        this.htmlEntitiesFix.setText(this.tr("Enable Android Fix"));
        htmlLayout.addWidget((QWidget)this.htmlEntitiesFix);
        htmlGroup.setLayout((QLayout)htmlLayout);
        this.reloadSharedNotebooks = new QCheckBox(this.tr("Shared Notebooks"));
        QGroupBox refresh = new QGroupBox(this.tr("Special Refresh (WARNING - This can cause unsynchronized data loss)."));
        QVBoxLayout refreshLayout = new QVBoxLayout();
        refreshLayout.addWidget((QWidget)this.reloadSharedNotebooks);
        refresh.setLayout((QLayout)refreshLayout);
        QTextBrowser msg = new QTextBrowser((QWidget)this);
        QTextBrowser htmlMsg = new QTextBrowser((QWidget)this);
        msg.setText(crlfMessage);
        htmlMsg.setText(entitiesMessage);
        crlfLayout.addWidget((QWidget)msg);
        mainLayout.addWidget((QWidget)crlfGroup);
        htmlLayout.addWidget((QWidget)htmlMsg);
        mainLayout.addWidget((QWidget)htmlGroup);
        mainLayout.addWidget((QWidget)refresh);
        mainLayout.addStretch(1);
        this.setLayout((QLayout)mainLayout);
        this.serverCombo.activated.connect((Object)this, "serverOptionChanged()");
    }

    public void setDebugLevel(String level) {
        int i = this.messageCombo.findData((Object)level);
        if (i > 0) {
            this.messageCombo.setCurrentIndex(i);
        }
    }

    public String getDebugLevel() {
        int i = this.messageCombo.currentIndex();
        return this.messageCombo.itemData(i).toString();
    }

    public void setHtmlEntitiesFix(boolean val) {
        this.htmlEntitiesFix.setChecked(val);
    }

    public boolean getHtmlEntitiesFix() {
        return this.htmlEntitiesFix.isChecked();
    }

    public void setCarriageReturnFix(boolean val) {
        this.carriageReturnFix.setChecked(val);
    }

    public boolean getCarriageReturnFix() {
        return this.carriageReturnFix.isChecked();
    }

    public void setServer(String server) {
        int i = this.serverCombo.findText(server);
        if (i > 0) {
            this.serverCombo.setCurrentIndex(i);
        }
    }

    public String getServer() {
        int i = this.serverCombo.currentIndex();
        return this.serverCombo.itemText(i);
    }

    private void serverOptionChanged() {
        String text = this.serverCombo.currentText();
        if (text.equalsIgnoreCase("www.evernote.com")) {
            this.disableUploads.setChecked(true);
        }
    }

    public void setDisableUploads(boolean val) {
        this.disableUploads.setChecked(val);
    }

    public boolean getDisableUploads() {
        return this.disableUploads.isChecked();
    }

    public void setEnableThumbnails(boolean val) {
        this.enableThumbnails.setChecked(val);
    }

    public boolean getEnableThumbnails() {
        return this.enableThumbnails.isChecked();
    }

    public String getDatabaseCacheSize() {
        return new Integer(this.databaseCache.value() * 1024).toString();
    }

    public boolean reloadSharedNotebooksClicked() {
        return this.reloadSharedNotebooks.isChecked();
    }
}

