/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.trolltech.qt.gui.QComboBox;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QWidget;
import java.util.List;

public class StackNotebook
extends QDialog {
    private boolean okPressed = false;
    private final QComboBox stack;
    QPushButton ok;
    List<String> currentStacks;

    public StackNotebook() {
        this.setWindowTitle(this.tr("Stack Notebook"));
        QGridLayout grid = new QGridLayout();
        this.setLayout((QLayout)grid);
        QGridLayout textGrid = new QGridLayout();
        this.stack = new QComboBox();
        this.stack.setEditable(true);
        textGrid.addWidget((QWidget)new QLabel(this.tr("Stack Name")), 1, 1);
        textGrid.addWidget((QWidget)this.stack, 1, 2);
        textGrid.setContentsMargins(10, 10, -10, -10);
        grid.addLayout((QLayout)textGrid, 1, 1);
        QGridLayout buttonGrid = new QGridLayout();
        this.ok = new QPushButton(this.tr("OK"));
        this.ok.clicked.connect((Object)this, "okButtonPressed()");
        this.ok.setEnabled(true);
        QPushButton cancel = new QPushButton(this.tr("Cancel"));
        cancel.clicked.connect((Object)this, "cancelButtonPressed()");
        this.stack.currentStringChanged.connect((Object)this, "textChanged(String)");
        buttonGrid.addWidget((QWidget)this.ok, 3, 1);
        buttonGrid.addWidget((QWidget)cancel, 3, 2);
        grid.addLayout((QLayout)buttonGrid, 2, 1);
    }

    private void okButtonPressed() {
        this.okPressed = true;
        this.close();
    }

    private void cancelButtonPressed() {
        this.okPressed = false;
        this.close();
    }

    public String getStackName() {
        return this.stack.currentText();
    }

    public void setStackNames(List<String> names) {
        this.currentStacks = names;
        this.stack.clear();
        int i = 0;
        while (i < names.size()) {
            this.stack.addItem(names.get(i));
            ++i;
        }
    }

    public void setStackName(String name) {
        this.stack.setEditText(name);
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    public void setTitle(String s) {
        this.setWindowTitle(s);
    }

    public void setTagList(List<String> t) {
        this.currentStacks = t;
    }

    private void textChanged(String text) {
        this.ok.setEnabled(true);
    }
}

