/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.evernote.edam.type.Tag;
import com.trolltech.qt.gui.QComboBox;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QSpacerItem;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;
import java.util.List;

public class TagMerge
extends QDialog {
    private final QComboBox newTag;
    private final QPushButton okButton;
    private final QPushButton cancelButton;
    private boolean okClicked;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public TagMerge(List<Tag> tags) {
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "tag.png"));
        this.okClicked = false;
        this.okButton = new QPushButton();
        this.okButton.setText(this.tr("OK"));
        this.okButton.pressed.connect((Object)this, "onClicked()");
        this.cancelButton = new QPushButton();
        this.cancelButton.setText(this.tr("Cancel"));
        this.cancelButton.pressed.connect((Object)this, "onCancel()");
        QVBoxLayout middleLayout = new QVBoxLayout();
        middleLayout.addSpacerItem(new QSpacerItem(1, 1));
        middleLayout.addSpacerItem(new QSpacerItem(1, 1));
        QVBoxLayout closeLayout = new QVBoxLayout();
        closeLayout.addWidget((QWidget)new QLabel(this.tr("Merge Into")));
        this.newTag = new QComboBox();
        closeLayout.addWidget((QWidget)this.newTag);
        QHBoxLayout buttonLayout = new QHBoxLayout();
        buttonLayout.addStretch(1);
        buttonLayout.addWidget((QWidget)this.okButton);
        buttonLayout.addWidget((QWidget)this.cancelButton);
        this.setWindowTitle(this.tr("Open/Close Notebooks"));
        QHBoxLayout upperLayout = new QHBoxLayout();
        upperLayout.addLayout((QLayout)middleLayout);
        upperLayout.addLayout((QLayout)closeLayout);
        QVBoxLayout mainLayout = new QVBoxLayout();
        mainLayout.addLayout((QLayout)upperLayout);
        mainLayout.addSpacing(1);
        mainLayout.addLayout((QLayout)buttonLayout);
        this.setLayout((QLayout)mainLayout);
        int i = 0;
        while (i < tags.size()) {
            this.newTag.addItem(tags.get(i).getName(), (Object)tags.get(i).getGuid());
            ++i;
        }
        this.setWindowTitle(this.tr("Merge Tags"));
    }

    private void onClicked() {
        this.okClicked = true;
        this.close();
    }

    private void onCancel() {
        this.okClicked = false;
        this.close();
    }

    public boolean okClicked() {
        return this.okClicked;
    }

    public String getNewTagGuid() {
        int position = this.newTag.currentIndex();
        return this.newTag.itemData(position).toString();
    }
}

