/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.QSize;
import com.trolltech.qt.gui.QAction;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QMenu;
import com.trolltech.qt.gui.QPixmap;
import com.trolltech.qt.gui.QWidget;
import java.util.List;

public class ColorMenu {
    private final QMenu menu = new QMenu();
    QWidget parent;
    QColor currentColor;

    public ColorMenu(QWidget b) {
        this.parent = b;
        this.populateList();
        this.currentColor = new QColor("black");
    }

    public void setDefault(QColor color) {
        this.currentColor = color;
    }

    private void populateList() {
        List colorNames = QColor.colorNames();
        int i = 0;
        while (i < colorNames.size()) {
            QColor color = new QColor((String)colorNames.get(i));
            QPixmap pix = new QPixmap(new QSize(22, 22));
            pix.fill(color);
            QAction newAction = new QAction(new QIcon(pix), "", (QObject)this.parent);
            newAction.setToolTip((String)colorNames.get(i));
            newAction.setText((String)colorNames.get(i));
            newAction.hovered.connect((Object)this, "itemHovered()");
            this.menu.addAction(newAction);
            ++i;
        }
    }

    private void itemHovered() {
        if (this.menu.activeAction() != null && this.menu.activeAction().toolTip() != null) {
            this.currentColor = new QColor(this.menu.activeAction().toolTip());
        }
    }

    public QColor getColor() {
        return this.currentColor;
    }

    public QMenu getMenu() {
        return this.menu;
    }
}

