/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.trolltech.qt.gui.QCheckBox;
import com.trolltech.qt.gui.QComboBox;
import com.trolltech.qt.gui.QFontDatabase;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QGroupBox;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.Global;
import java.util.List;

public class ConfigFontPage
extends QWidget {
    private final QCheckBox overrideFonts;
    private final QComboBox fontList;
    private final QComboBox fontSizeList;
    private String font = Global.getDefaultFont();
    private String fontSize = Global.getDefaultFontSize();

    public ConfigFontPage(QWidget parent) {
        QGroupBox fontGroup = new QGroupBox(this.tr("New Note Defaults"));
        QGridLayout fontLayout = new QGridLayout();
        this.overrideFonts = new QCheckBox(this.tr("Override Defaults"));
        this.overrideFonts.setCheckable(true);
        this.overrideFonts.setChecked(Global.overrideDefaultFont());
        this.overrideFonts.clicked.connect((Object)this, "toggleFontOverride(Boolean)");
        fontLayout.addWidget((QWidget)this.overrideFonts, 1, 2);
        this.fontList = new QComboBox();
        this.fontList.activated.connect((Object)this, "fontSelected(String)");
        fontLayout.addWidget((QWidget)new QLabel(this.tr("Font")), 2, 1);
        fontLayout.addWidget((QWidget)this.fontList, 2, 2);
        this.fontSizeList = new QComboBox();
        fontLayout.addWidget((QWidget)this.fontSizeList, 3, 2);
        this.fontSizeList.activated.connect((Object)this, "fontSizeSelected(String)");
        fontLayout.addWidget((QWidget)new QLabel(this.tr("Size")), 3, 1);
        fontGroup.setLayout((QLayout)fontLayout);
        fontLayout.setColumnStretch(2, 100);
        this.toggleFontOverride(Global.overrideDefaultFont());
        this.loadFonts();
        this.loadSettings();
        QVBoxLayout mainLayout = new QVBoxLayout();
        mainLayout.addWidget((QWidget)fontGroup);
        mainLayout.addStretch(1);
        this.setLayout((QLayout)mainLayout);
    }

    private void toggleFontOverride(Boolean value) {
        this.fontList.setEnabled(value.booleanValue());
        this.fontSizeList.setEnabled(value.booleanValue());
    }

    private void loadFonts() {
        QFontDatabase fonts = new QFontDatabase();
        List fontFamilies = fonts.families();
        int i = 0;
        while (i < fontFamilies.size()) {
            if (this.font.equals("")) {
                this.font = (String)fontFamilies.get(i);
            }
            this.fontList.addItem((String)fontFamilies.get(i));
            if (i == 0) {
                this.loadFontSize((String)fontFamilies.get(i));
            }
            ++i;
        }
    }

    private void loadFontSize(String name) {
        QFontDatabase db = new QFontDatabase();
        this.fontSizeList.clear();
        List points = db.pointSizes(name);
        int i = 0;
        while (i < points.size()) {
            if (this.fontSize.equals("")) {
                this.fontSize = ((Integer)points.get(i)).toString();
            }
            this.fontSizeList.addItem(((Integer)points.get(i)).toString());
            ++i;
        }
    }

    private void fontSelected(String font) {
        this.font = font;
        this.loadFontSize(font);
    }

    private void fontSizeSelected(String size) {
        this.fontSize = size;
    }

    private void loadSettings() {
        int index;
        if (!Global.getDefaultFont().equals("")) {
            index = this.fontList.findText(Global.getDefaultFont());
            this.fontList.setCurrentIndex(index);
        }
        if (!Global.getDefaultFontSize().equals("")) {
            index = this.fontSizeList.findText(Global.getDefaultFontSize());
            this.fontSizeList.setCurrentIndex(index);
        }
    }

    public String getFont() {
        return this.font;
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public boolean overrideFont() {
        return this.overrideFonts.isChecked();
    }
}

