/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QGroupBox;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QRadioButton;
import com.trolltech.qt.gui.QTextBrowser;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;

public class SharedNotebookSyncError
extends QDialog {
    private boolean okPressed = false;
    QPushButton ok;
    public final QRadioButton doNothing;
    public final QRadioButton deleteNotebook;
    public final QRadioButton convertToLocal;
    public final QRadioButton convertToShared;
    private final QGroupBox choiceGroup;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public SharedNotebookSyncError(String notebook) {
        this.setWindowTitle(this.tr("Shared Notebook Synchronization Error"));
        QGridLayout grid = new QGridLayout();
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "synchronize.png"));
        QVBoxLayout vLayout = new QVBoxLayout();
        this.setLayout((QLayout)vLayout);
        QTextBrowser msg1 = new QTextBrowser();
        msg1.setText(String.valueOf(this.tr("There was an error with notebook ")) + notebook + this.tr("\nThe most probable reason is that the owner of the notebook has revoked your authority to view it.\n\n") + this.tr("Below are the choices available to resolve this issue."));
        vLayout.addWidget((QWidget)msg1);
        this.choiceGroup = new QGroupBox((QWidget)this);
        this.doNothing = new QRadioButton((QWidget)this);
        this.doNothing.setChecked(true);
        this.doNothing.setText(this.tr("Do nothing and ask me later."));
        this.deleteNotebook = new QRadioButton((QWidget)this);
        this.deleteNotebook.setText(this.tr("Permanently delete this notebook & all notes"));
        this.convertToLocal = new QRadioButton((QWidget)this);
        this.convertToLocal.setText(this.tr("Convert this notebook to a local notebook and keep all notes"));
        this.convertToShared = new QRadioButton((QWidget)this);
        this.convertToShared.setText(this.tr("Convert this notebook to a shared notebook and keep all notes"));
        QVBoxLayout optionLayout = new QVBoxLayout();
        optionLayout.addWidget((QWidget)this.doNothing);
        optionLayout.addWidget((QWidget)this.deleteNotebook);
        this.choiceGroup.setLayout((QLayout)optionLayout);
        vLayout.addWidget((QWidget)this.choiceGroup);
        QGridLayout buttonGrid = new QGridLayout();
        this.ok = new QPushButton(this.tr("OK"));
        this.ok.clicked.connect((Object)this, "okButtonPressed()");
        QPushButton cancel = new QPushButton(this.tr("Cancel"));
        cancel.clicked.connect((Object)this, "cancelButtonPressed()");
        buttonGrid.addWidget((QWidget)this.ok, 3, 1);
        buttonGrid.addWidget((QWidget)cancel, 3, 2);
        grid.addLayout((QLayout)buttonGrid, 3, 1);
        vLayout.addLayout((QLayout)grid);
    }

    private void okButtonPressed() {
        this.okPressed = true;
        this.close();
    }

    private void cancelButtonPressed() {
        this.okPressed = false;
        this.close();
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    public void setTitle(String s) {
        this.setWindowTitle(s);
    }
}

