/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.evernote.edam.type.Tag;
import com.trolltech.qt.gui.QCheckBox;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QLineEdit;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QWidget;
import java.util.List;

public class TagEdit
extends QDialog {
    private boolean okPressed = false;
    private final QLineEdit tag;
    QPushButton ok;
    private final QCheckBox useParentTag;
    List<Tag> currentTags;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public TagEdit() {
        this.setWindowTitle(this.tr("Add Tag"));
        QGridLayout grid = new QGridLayout();
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "tag.png"));
        this.setLayout((QLayout)grid);
        QGridLayout textGrid = new QGridLayout();
        this.tag = new QLineEdit();
        textGrid.addWidget((QWidget)new QLabel(this.tr("Tag Name")), 1, 1);
        textGrid.addWidget((QWidget)this.tag, 1, 2);
        textGrid.setContentsMargins(10, 10, -10, -10);
        grid.addLayout((QLayout)textGrid, 1, 1);
        this.useParentTag = new QCheckBox();
        this.useParentTag.setVisible(false);
        this.useParentTag.setChecked(false);
        grid.addWidget((QWidget)this.useParentTag, 2, 1);
        QGridLayout buttonGrid = new QGridLayout();
        this.ok = new QPushButton(this.tr("OK"));
        this.ok.clicked.connect((Object)this, "okButtonPressed()");
        this.ok.setEnabled(false);
        QPushButton cancel = new QPushButton(this.tr("Cancel"));
        cancel.clicked.connect((Object)this, "cancelButtonPressed()");
        this.tag.textChanged.connect((Object)this, "textChanged()");
        buttonGrid.addWidget((QWidget)this.ok, 3, 1);
        buttonGrid.addWidget((QWidget)cancel, 3, 2);
        grid.addLayout((QLayout)buttonGrid, 3, 1);
    }

    private void okButtonPressed() {
        this.okPressed = true;
        this.close();
    }

    private void cancelButtonPressed() {
        this.okPressed = false;
        this.close();
    }

    public String getTag() {
        return this.tag.text();
    }

    public void setTag(String name) {
        this.tag.setText(name);
    }

    public void setParentTag(String name) {
        this.useParentTag.setText(String.valueOf(this.tr("Create as child of \"")) + name + "\"");
        this.useParentTag.setVisible(true);
        this.useParentTag.setChecked(true);
    }

    public QCheckBox getParentTag() {
        return this.useParentTag;
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    public void setTitle(String s) {
        this.setWindowTitle(s);
    }

    public void setTagList(List<Tag> t) {
        this.currentTags = t;
    }

    private void textChanged() {
        if (this.tag.text().equals("")) {
            this.ok.setEnabled(false);
            return;
        }
        if (this.currentTags == null) {
            this.ok.setEnabled(false);
            return;
        }
        int i = 0;
        while (i < this.currentTags.size()) {
            String s = this.currentTags.get(i).getName();
            if (s.equalsIgnoreCase(this.tag.text())) {
                this.ok.setEnabled(false);
                return;
            }
            ++i;
        }
        this.ok.setEnabled(true);
    }
}

