/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.gui;

import com.evernote.edam.type.Note;
import cx.fbn.nevernote.filters.DateAttributeFilter;
import cx.fbn.nevernote.filters.DateAttributeFilterFactory;
import java.util.ArrayList;

public class DateAttributeFilterTable {
    ArrayList<DateAttributeFilter> table = new ArrayList();

    public DateAttributeFilterTable(boolean since, boolean created) {
        DateAttributeFilterFactory.FilterType[] filterTypeArray = DateAttributeFilterFactory.FilterType.values();
        int n = filterTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DateAttributeFilterFactory.FilterType type = filterTypeArray[n2];
            this.table.add(DateAttributeFilterFactory.getFilter(type, since, created));
            ++n2;
        }
    }

    public void reset() {
        int i = 0;
        while (i < this.table.size()) {
            this.table.get(i).set(false);
            ++i;
        }
    }

    public void select(int i) {
        this.table.get(i).set(true);
    }

    public boolean hasSelection() {
        int i = 0;
        while (i < this.table.size()) {
            if (this.table.get(i).isSet()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int size() {
        return this.table.size();
    }

    public boolean check(Note n) {
        int i = 0;
        while (i < this.table.size()) {
            if (this.table.get(i).isSet() && !this.table.get(i).attributeCheck(n)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getLabel(int i) {
        return this.table.get(i).getLabel();
    }
}

