/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.sql;

import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.driver.NSqlQuery;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import java.util.ArrayList;
import java.util.List;

public class WordsTable {
    private final ApplicationLogger logger;
    private final DatabaseConnection db;

    public WordsTable(ApplicationLogger l, DatabaseConnection d) {
        this.logger = l;
        this.db = d;
    }

    public void createTable() {
        NSqlQuery query = new NSqlQuery(this.db.getIndexConnection());
        this.logger.log(this.logger.HIGH, "Creating table WORDS ...");
        if (!query.exec("create table words (word varchar, guid varchar, source varchar, weight int, primary key (word, guid, source));")) {
            this.logger.log(this.logger.HIGH, "Table WORDS creation FAILED!!!");
            this.logger.log(this.logger.HIGH, query.lastError());
        }
    }

    public void dropTable() {
        NSqlQuery query = new NSqlQuery(this.db.getIndexConnection());
        query.exec("drop table words");
    }

    public int getWordCount() {
        NSqlQuery query = new NSqlQuery(this.db.getIndexConnection());
        query.exec("select count(*) from words");
        query.next();
        int returnValue = new Integer(query.valueString(0));
        return returnValue;
    }

    public void clearWordIndex() {
        NSqlQuery query = new NSqlQuery(this.db.getIndexConnection());
        this.logger.log(this.logger.HIGH, "DELETE FROM WORDS");
        boolean check = query.exec("DELETE FROM WORDS");
        if (!check) {
            this.logger.log(this.logger.HIGH, "Table WORDS clear has FAILED!!!");
        }
    }

    public void expungeFromWordIndex(String guid, String type) {
        NSqlQuery deleteWords = new NSqlQuery(this.db.getIndexConnection());
        if (!deleteWords.prepare("delete from words where guid=:guid and source=:source")) {
            this.logger.log(this.logger.EXTREME, "Note SQL select prepare deleteWords has failed.");
            this.logger.log(this.logger.MEDIUM, deleteWords.lastError());
        }
        deleteWords.bindValue(":guid", guid);
        deleteWords.bindValue(":source", type);
        deleteWords.exec();
    }

    public void expunge(String guid) {
        NSqlQuery deleteWords = new NSqlQuery(this.db.getIndexConnection());
        if (!deleteWords.prepare("delete from words where guid=:guid")) {
            this.logger.log(this.logger.EXTREME, "Word SQL select prepare expunge has failed.");
            this.logger.log(this.logger.MEDIUM, deleteWords.lastError());
        }
        deleteWords.bindValue(":guid", guid);
        deleteWords.exec();
    }

    public synchronized void addWordToNoteIndex(String guid, String word, String type, Integer weight) {
        NSqlQuery findWords = new NSqlQuery(this.db.getIndexConnection());
        if (!findWords.prepare("Select weight from words where guid=:guid and source=:type and word=:word")) {
            this.logger.log(this.logger.MEDIUM, "Prepare failed in addWordToNoteIndex()");
            this.logger.log(this.logger.MEDIUM, findWords.lastError());
        }
        findWords.bindValue(":guid", guid);
        findWords.bindValue(":type", type);
        findWords.bindValue(":word", word);
        boolean addNeeded = true;
        findWords.exec();
        if (findWords.next()) {
            int recordWeight = new Integer(findWords.valueString(0));
            addNeeded = false;
            if (recordWeight < weight) {
                NSqlQuery updateWord = new NSqlQuery(this.db.getIndexConnection());
                if (!updateWord.prepare("Update words set weight=:weight where guid=:guid and source=:type and word=:word")) {
                    this.logger.log(this.logger.MEDIUM, "Prepare failed for find words in addWordToNoteIndex()");
                    this.logger.log(this.logger.MEDIUM, findWords.lastError());
                }
                updateWord.bindValue(":weight", weight);
                updateWord.bindValue(":guid", guid);
                updateWord.bindValue(":type", type);
                updateWord.bindValue(":word", word);
                updateWord.exec();
            }
        }
        if (!addNeeded) {
            return;
        }
        NSqlQuery insertWords = new NSqlQuery(this.db.getIndexConnection());
        if (!insertWords.prepare("Insert Into Words (word, guid, weight, source) Values(:word, :guid, :weight, :type )")) {
            this.logger.log(this.logger.EXTREME, "Note SQL select prepare checkWords has failed.");
            this.logger.log(this.logger.MEDIUM, insertWords.lastError());
        }
        insertWords.bindValue(":word", word);
        insertWords.bindValue(":guid", guid);
        insertWords.bindValue(":weight", weight);
        insertWords.bindValue(":type", type);
        if (!insertWords.exec()) {
            String err = insertWords.lastError();
            this.logger.log(this.logger.MEDIUM, "Error inserting words into index: " + err);
        }
    }

    public List<String> getGuidList() {
        NSqlQuery query = new NSqlQuery(this.db.getIndexConnection());
        this.logger.log(this.logger.HIGH, "gedGuidList()");
        boolean check = query.exec("Select distinct guid from words");
        if (!check) {
            this.logger.log(this.logger.HIGH, "Table WORDS select distinct guid has FAILED!!!");
        }
        ArrayList<String> guids = new ArrayList<String>();
        while (query.next()) {
            guids.add(query.valueString(0));
        }
        return guids;
    }
}

