/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.internal;

import com.trolltech.qt.QNativePointer;
import com.trolltech.qt.core.QAbstractFileEngine;
import com.trolltech.qt.core.QDateTime;
import com.trolltech.qt.core.QDir;
import com.trolltech.qt.core.QFileInfo;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.internal.JarCache;
import com.trolltech.qt.internal.QClassPathEntry;
import com.trolltech.qt.internal.QClassPathFileEngineHandler;
import com.trolltech.qt.internal.QFSEntryEngine;
import com.trolltech.qt.internal.QJarEntryEngine;
import com.trolltech.qt.internal.RetroTranslatorHelper;
import java.io.File;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QClassPathEngine
extends QAbstractFileEngine {
    public static final String FileNameDelim = "#";
    public static final String FileNameIndicator = "classpath";
    public static final String FileNamePrefix = "classpath:";
    private static HashSet<String> classpaths;
    private String m_fileName = "";
    private String m_baseName = "";
    private String m_selectedSource = "*";
    private List<QAbstractFileEngine> m_engines = new LinkedList<QAbstractFileEngine>();

    public QClassPathEngine(String fileName) {
        this.setFileName(fileName);
    }

    private static String makeUrl(String path) {
        boolean hasProtocol = false;
        try {
            URL url = new URL(path);
            if (url.getProtocol().length() > 0) {
                hasProtocol = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!hasProtocol) {
            path = "file:" + path;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSearchPath(String path) {
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            if (classpaths == null) {
                QClassPathEngine.findClassPaths();
            }
            String url = QClassPathEngine.makeUrl(path);
            classpaths.remove(url);
            classpaths.add(QClassPathEngine.makeUrl(path));
            JarCache.reset(classpaths);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSearchPath(String path) {
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            if (classpaths == null) {
                QClassPathEngine.findClassPaths();
            }
            classpaths.remove(QClassPathEngine.makeUrl(path));
            JarCache.reset(classpaths);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void setFileName(String fileName) {
        int first;
        if (fileName.equals(this.fileName())) {
            return;
        }
        this.cleanUp();
        if (!fileName.startsWith(FileNamePrefix)) {
            throw new IllegalArgumentException("Invalid format of path: '" + fileName + "'");
        }
        this.m_fileName = fileName.substring(FileNamePrefix.length());
        String[] searchPath = RetroTranslatorHelper.split(this.m_fileName, FileNameDelim, 2);
        this.m_selectedSource = "*";
        if (searchPath.length == 1) {
            this.m_baseName = searchPath[0];
        } else {
            this.m_baseName = searchPath[1];
            this.m_selectedSource = searchPath[0];
        }
        int last = this.m_baseName.length();
        for (first = 0; first < last && this.m_baseName.charAt(first) == '/'; ++first) {
        }
        if (this.m_baseName.endsWith("/")) {
            --last;
        }
        this.m_baseName = last < first ? "" : this.m_baseName.substring(first, last).replace('\\', '/');
        if (classpaths == null) {
            QClassPathEngine.findClassPaths();
        }
        if (this.m_selectedSource.equals("*")) {
            List<JarFile> potentialJars = JarCache.jarFiles(this.m_baseName);
            if (potentialJars != null) {
                for (JarFile path : potentialJars) {
                    this.addJarFileFromPath(path, this.m_baseName, true);
                }
            } else {
                int pos = this.m_baseName.lastIndexOf("/");
                String parentSearch = pos < 0 ? "" : this.m_baseName.substring(0, pos);
                List<JarFile> parentDirJars = JarCache.jarFiles(parentSearch);
                if (parentDirJars != null) {
                    for (JarFile jarFile : parentDirJars) {
                        this.addJarFileFromPath(jarFile, this.m_baseName, false);
                    }
                }
                for (String string : JarCache.classPathDirs()) {
                    try {
                        this.addFromPath(new URL(QClassPathEngine.makeUrl(string)), this.m_baseName);
                    }
                    catch (Exception e) {}
                }
            }
        } else {
            try {
                String url = QClassPathEngine.makeUrl(this.m_selectedSource);
                if (url.startsWith("file:") && new File(url.substring(5)).isDirectory()) {
                    this.addFromPath(new URL(url), this.m_baseName);
                }
                this.addJarFileFromPath(new URL("jar:" + url + "!/"), this.m_baseName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean copy(String newName) {
        if (this.m_engines.size() > 0) {
            return this.m_engines.get(0).copy(newName);
        }
        return false;
    }

    @Override
    public boolean setPermissions(int perms) {
        for (QAbstractFileEngine engine : this.m_engines) {
            if (!engine.setPermissions(perms)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean caseSensitive() {
        return true;
    }

    @Override
    public boolean close() {
        if (this.m_engines.size() == 0) {
            return false;
        }
        return this.m_engines.get(0).close();
    }

    @Override
    public List<String> entryList(QDir.Filters filters, List<String> filterNames) {
        List<String> result = null;
        for (QAbstractFileEngine engine : this.m_engines) {
            if (result == null) {
                result = engine.entryList(filters, filterNames);
                continue;
            }
            List<String> list = engine.entryList(filters, filterNames);
            result.removeAll(list);
            result.addAll(list);
        }
        return result;
    }

    @Override
    public QAbstractFileEngine.FileFlags fileFlags(QAbstractFileEngine.FileFlags type) {
        QAbstractFileEngine.FileFlags flags = new QAbstractFileEngine.FileFlags(new QAbstractFileEngine.FileFlag[0]);
        for (QAbstractFileEngine engine : this.m_engines) {
            flags.set(engine.fileFlags(type));
        }
        if (this.fileName(QAbstractFileEngine.FileName.PathName).equals("/")) {
            flags.set(new QAbstractFileEngine.FileFlag[]{QAbstractFileEngine.FileFlag.RootFlag});
        }
        flags.clear(new QAbstractFileEngine.FileFlag[]{QAbstractFileEngine.FileFlag.LocalDiskFlag});
        return flags;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String fileName(QAbstractFileEngine.FileName file) {
        if (this.m_engines.size() == 0) {
            return "";
        }
        String classPathEntry = "";
        if (this.m_engines.size() == 1) {
            QAbstractFileEngine engine = this.m_engines.get(0);
            if (!(engine instanceof QClassPathEntry)) throw new RuntimeException("Bogus engine in class path file engine");
            classPathEntry = ((QClassPathEntry)((Object)engine)).classPathEntryName();
        } else {
            classPathEntry = "*";
        }
        String result = "";
        if (file == QAbstractFileEngine.FileName.DefaultName) {
            return FileNamePrefix + this.m_fileName;
        }
        if (file == QAbstractFileEngine.FileName.CanonicalName) return this.fileName(QAbstractFileEngine.FileName.CanonicalPathName) + "/" + this.fileName(QAbstractFileEngine.FileName.BaseName);
        if (file == QAbstractFileEngine.FileName.LinkName) {
            return this.fileName(QAbstractFileEngine.FileName.CanonicalPathName) + "/" + this.fileName(QAbstractFileEngine.FileName.BaseName);
        }
        if (file == QAbstractFileEngine.FileName.AbsoluteName) return FileNamePrefix + classPathEntry + FileNameDelim + this.m_baseName;
        if (file == QAbstractFileEngine.FileName.LinkName) {
            return FileNamePrefix + classPathEntry + FileNameDelim + this.m_baseName;
        }
        if (file == QAbstractFileEngine.FileName.BaseName) {
            int pos = this.m_baseName.lastIndexOf("/");
            return pos > 0 ? this.m_baseName.substring(pos + 1) : this.m_baseName;
        }
        if (file == QAbstractFileEngine.FileName.PathName) {
            int pos = this.m_baseName.lastIndexOf("/");
            if (pos <= 0) return "";
            String string = this.m_baseName.substring(0, pos);
            return string;
        }
        if (file == QAbstractFileEngine.FileName.AbsolutePathName) {
            return FileNamePrefix + classPathEntry + FileNameDelim + this.fileName(QAbstractFileEngine.FileName.PathName);
        }
        if (file != QAbstractFileEngine.FileName.CanonicalPathName) throw new IllegalArgumentException("Unknown file name type: " + file);
        return this.m_engines.get(0).fileName(file);
    }

    @Override
    public QDateTime fileTime(QAbstractFileEngine.FileTime time) {
        if (this.m_engines.size() == 0) {
            return new QDateTime();
        }
        return this.m_engines.get(0).fileTime(time);
    }

    @Override
    public boolean link(String newName) {
        for (QAbstractFileEngine engine : this.m_engines) {
            if (!engine.link(newName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mkdir(String dirName, boolean createParentDirectories) {
        for (QAbstractFileEngine engine : this.m_engines) {
            if (!engine.mkdir(dirName, createParentDirectories)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean open(QIODevice.OpenMode openMode) {
        if (this.m_engines.size() == 0) {
            return false;
        }
        return this.m_engines.get(0).open(openMode);
    }

    @Override
    public long pos() {
        if (this.m_engines.size() == 0) {
            return -1L;
        }
        return this.m_engines.get(0).pos();
    }

    @Override
    public long read(QNativePointer data, long maxlen) {
        if (this.m_engines.size() == 0) {
            return -1L;
        }
        return this.m_engines.get(0).read(data, maxlen);
    }

    @Override
    public long readLine(QNativePointer data, long maxlen) {
        if (this.m_engines.size() == 0) {
            return -1L;
        }
        return this.m_engines.get(0).readLine(data, maxlen);
    }

    @Override
    public boolean remove() {
        boolean ok = true;
        for (QAbstractFileEngine engine : this.m_engines) {
            ok = ok && engine.remove();
        }
        return ok;
    }

    @Override
    public boolean rename(String newName) {
        boolean ok = true;
        for (QAbstractFileEngine engine : this.m_engines) {
            ok = ok && engine.rename(newName);
        }
        return ok;
    }

    @Override
    public boolean rmdir(String dirName, boolean recursive) {
        boolean ok = true;
        for (QAbstractFileEngine engine : this.m_engines) {
            ok = ok && engine.rmdir(dirName, recursive);
        }
        return ok;
    }

    @Override
    public boolean seek(long offset) {
        if (this.m_engines.size() == 0) {
            return false;
        }
        return this.m_engines.get(0).seek(offset);
    }

    @Override
    public String owner(QAbstractFileEngine.FileOwner owner) {
        String result = "";
        int i = 0;
        while (result.length() == 0 && i < this.m_engines.size()) {
            result = this.m_engines.get(i++).owner(owner);
        }
        return result;
    }

    @Override
    public int ownerId(QAbstractFileEngine.FileOwner owner) {
        int result = -2;
        int i = 0;
        while (result == -2 && i < this.m_engines.size()) {
            result = this.m_engines.get(i++).ownerId(owner);
        }
        return result;
    }

    @Override
    public boolean isRelativePath() {
        return false;
    }

    @Override
    public boolean isSequential() {
        for (QAbstractFileEngine engine : this.m_engines) {
            if (!engine.isSequential()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean setSize(long sz) {
        if (this.m_engines.size() == 0) {
            return false;
        }
        return this.m_engines.get(0).setSize(sz);
    }

    @Override
    public long size() {
        if (this.m_engines.size() == 0) {
            return -1L;
        }
        return this.m_engines.get(0).size();
    }

    @Override
    public long write(QNativePointer data, long len) {
        if (this.m_engines.size() == 0) {
            return -1L;
        }
        return this.m_engines.get(0).write(data, len);
    }

    private void cleanUp() {
        if (this.m_engines != null) {
            this.m_engines.clear();
        }
    }

    private void addFromPath(URL url, String fileName) {
        QFileInfo file;
        String qtified_path = url.getFile().replace('\\', '/');
        if (url.getProtocol().equals("file") && (file = new QFileInfo(qtified_path)).isDir() && file.exists() && new QFileInfo(qtified_path + "/" + fileName).exists()) {
            this.addEngine(new QFSEntryEngine(qtified_path + "/" + fileName, url.toExternalForm()));
            return;
        }
    }

    private void addJarFileFromPath(JarFile jarFile, String fileName, boolean directory) {
        QJarEntryEngine engine = new QJarEntryEngine(jarFile, fileName, directory);
        if (engine.isValid()) {
            this.addEngine(engine);
        }
    }

    static boolean checkIsDirectory(JarFile jarFile, JarEntry fileInJar) {
        try {
            InputStream s = jarFile.getInputStream(fileInJar);
            s.read();
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    private void addJarFileFromPath(URL jarFileURL, String fileName) {
        try {
            JarFile jarFile = ((JarURLConnection)jarFileURL.openConnection()).getJarFile();
            boolean isDirectory = false;
            JarEntry fileInJar = jarFile.getJarEntry(fileName);
            if (fileInJar != null && !(isDirectory = fileInJar.isDirectory())) {
                isDirectory = QClassPathEngine.checkIsDirectory(jarFile, fileInJar);
            }
            if (!isDirectory) {
                List<JarFile> files = JarCache.jarFiles(fileName);
                String jarFileName = jarFile.getName();
                if (files != null) {
                    for (JarFile f : files) {
                        if (!f.getName().equals(jarFileName)) continue;
                        isDirectory = true;
                        break;
                    }
                }
                if (!isDirectory) {
                    String fileNameWithSlash = fileName + "/";
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String entryName = entry.getName();
                        if (!entryName.startsWith(fileNameWithSlash)) continue;
                        isDirectory = true;
                        break;
                    }
                }
            }
            this.addJarFileFromPath(jarFile, fileName, isDirectory);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addEngine(QAbstractFileEngine engine) {
        if (this.m_engines == null) {
            this.m_engines = new LinkedList<QAbstractFileEngine>();
        }
        this.m_engines.add(engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findClassPaths() {
        Class<QClassPathEngine> clazz = QClassPathEngine.class;
        synchronized (QClassPathEngine.class) {
            classpaths = new HashSet();
            ArrayList<URL> cpUrls = new ArrayList<URL>();
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = QClassPathFileEngineHandler.class.getClassLoader();
                }
                Enumeration<URL> urls = loader.getResources("META-INF/MANIFEST.MF");
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    if (!url.getProtocol().equals("jar")) continue;
                    try {
                        String f = url.getFile();
                        int bang = f.indexOf("!");
                        if (bang >= 0) {
                            f = f.substring(0, bang);
                        }
                        if (f.trim().length() <= 0) continue;
                        classpaths.add(f);
                        cpUrls.add(new URL(f));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String[] paths = RetroTranslatorHelper.split(System.getProperty("java.class.path"), File.pathSeparator);
            int k = 0;
            for (String p : paths) {
                if (p.trim().length() <= 0) continue;
                ++k;
                String url = QClassPathEngine.makeUrl(p);
                boolean match = false;
                try {
                    JarFile jarFile2 = ((JarURLConnection)new URL("jar:" + url + "!/").openConnection()).getJarFile();
                    for (URL otherURL : cpUrls) {
                        JarFile jarFile1 = ((JarURLConnection)new URL("jar:" + otherURL.toString() + "!/").openConnection()).getJarFile();
                        if (!new File(jarFile1.getName()).getCanonicalPath().equals(new File(jarFile2.getName()).getCanonicalPath())) continue;
                        match = true;
                        break;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (match) continue;
                classpaths.add(url);
            }
            if (k == 0) {
                classpaths.add("file:" + QDir.currentPath());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            JarCache.reset(classpaths);
            return;
        }
    }
}

