/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.afm.FontMetric;
import org.apache.fontbox.cmap.CMap;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.encoding.DictionaryEncoding;
import org.apache.pdfbox.encoding.Encoding;
import org.apache.pdfbox.encoding.EncodingManager;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.util.ResourceLoader;

public abstract class PDSimpleFont
extends PDFont {
    private final HashMap<Integer, Float> mFontSizes = new HashMap(128);
    private float avgFontWidth = 0.0f;
    private static final Log log = LogFactory.getLog(PDSimpleFont.class);

    public PDSimpleFont() {
    }

    public PDSimpleFont(COSDictionary fontDictionary) {
        super(fontDictionary);
    }

    public Font getawtFont() throws IOException {
        log.error("Not yet implemented:" + this.getClass().getName());
        return null;
    }

    public void drawString(String string, Graphics g, float fontSize, AffineTransform at, float x, float y) throws IOException {
        Font _awtFont = this.getawtFont();
        if (!this.isType1Font() && _awtFont.canDisplayUpTo(string) != -1) {
            log.warn("Changing font on <" + string + "> from <" + _awtFont.getName() + "> to the default font");
            _awtFont = Font.decode(null);
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.writeFont(g2d, at, _awtFont, x, y, string);
    }

    public float getFontHeight(byte[] c, int offset, int length) throws IOException {
        float retval = 0.0f;
        int code = this.getCodeFromArray(c, offset, length);
        FontMetric metric = this.getAFM();
        if (metric != null) {
            Encoding encoding = this.getFontEncoding();
            String characterName = encoding.getName(code);
            retval = metric.getCharacterHeight(characterName);
        } else {
            PDFontDescriptor desc = this.getFontDescriptor();
            if (desc != null) {
                float xHeight = desc.getXHeight();
                float capHeight = desc.getCapHeight();
                retval = xHeight != 0.0f && capHeight != 0.0f ? (xHeight + capHeight) / 2.0f : (xHeight != 0.0f ? xHeight : (capHeight != 0.0f ? capHeight : 0.0f));
                if (retval == 0.0f) {
                    retval = desc.getAscent();
                }
            }
        }
        return retval;
    }

    public float getFontWidth(byte[] c, int offset, int length) throws IOException {
        int code = this.getCodeFromArray(c, offset, length);
        Float fontWidth = this.mFontSizes.get(code);
        if (fontWidth == null) {
            fontWidth = Float.valueOf(this.getFontWidth(code));
            if (fontWidth.floatValue() == -1.0f) {
                fontWidth = Float.valueOf(this.getFontWidthFromAFMFile(code));
            }
            this.mFontSizes.put(code, fontWidth);
        }
        return fontWidth.floatValue();
    }

    public float getAverageFontWidth() throws IOException {
        float average = 0.0f;
        if (this.avgFontWidth != 0.0f) {
            average = this.avgFontWidth;
        } else {
            float totalWidth = 0.0f;
            float characterCount = 0.0f;
            COSArray widths = (COSArray)this.font.getDictionaryObject(COSName.WIDTHS);
            if (widths != null) {
                for (int i = 0; i < widths.size(); ++i) {
                    COSNumber fontWidth = (COSNumber)widths.getObject(i);
                    if (!(fontWidth.floatValue() > 0.0f)) continue;
                    totalWidth += fontWidth.floatValue();
                    characterCount += 1.0f;
                }
            }
            average = totalWidth > 0.0f ? totalWidth / characterCount : this.getAverageFontWidthFromAFMFile();
            this.avgFontWidth = average;
        }
        return average;
    }

    public COSBase getToUnicode() {
        return this.font.getDictionaryObject(COSName.TO_UNICODE);
    }

    public void setToUnicode(COSBase unicode) {
        this.font.setItem(COSName.TO_UNICODE, unicode);
    }

    public PDRectangle getFontBoundingBox() throws IOException {
        return this.getFontDescriptor().getFontBoundingBox();
    }

    protected void writeFont(Graphics2D g2d, AffineTransform at, Font awtFont, float x, float y, String string) {
        if (!at.isIdentity()) {
            try {
                AffineTransform atInv = at.createInverse();
                g2d.setFont(awtFont.deriveFont(1.0f));
                g2d.transform(at);
                Point2D.Float newXy = new Point2D.Float(x, y);
                atInv.transform(new Point2D.Float(x, y), newXy);
                g2d.drawString(string, (float)newXy.getX(), (float)newXy.getY());
                g2d.transform(atInv);
            }
            catch (NoninvertibleTransformException e) {
                log.error("Error in " + this.getClass().getName() + ".writeFont", e);
            }
        } else {
            g2d.setFont(awtFont.deriveFont(at));
            g2d.drawString(string, x, y);
        }
    }

    protected void determineEncoding() {
        String cmapName = null;
        COSName encodingName = null;
        COSBase encoding = this.getEncoding();
        Encoding fontEncoding = null;
        if (encoding != null) {
            if (encoding instanceof COSName) {
                if (this.cmap == null) {
                    encodingName = (COSName)encoding;
                    this.cmap = (CMap)cmapObjects.get(encodingName.getName());
                    if (this.cmap == null) {
                        cmapName = encodingName.getName();
                    }
                }
                if (this.cmap == null && cmapName != null) {
                    try {
                        fontEncoding = EncodingManager.INSTANCE.getEncoding(encodingName);
                    }
                    catch (IOException exception) {
                        log.debug("Debug: Could not find encoding for " + encodingName);
                    }
                }
            } else if (encoding instanceof COSDictionary) {
                try {
                    fontEncoding = new DictionaryEncoding((COSDictionary)encoding);
                }
                catch (IOException exception) {
                    log.error("Error: Could not create the DictionaryEncoding");
                }
            } else if (encoding instanceof COSStream && this.cmap == null) {
                COSStream encodingStream = (COSStream)encoding;
                try {
                    this.parseCmap(null, encodingStream.getUnfilteredStream());
                }
                catch (IOException exception) {
                    log.error("Error: Could not parse the embedded CMAP");
                }
            }
        }
        this.setFontEncoding(fontEncoding);
        this.extractToUnicodeEncoding();
        if (this.cmap == null && cmapName != null) {
            String resourceName = "org/apache/pdfbox/resources/cmap/" + cmapName;
            try {
                this.parseCmap("org/apache/pdfbox/resources/cmap/", ResourceLoader.loadResource(resourceName));
                if (this.cmap == null && encodingName == null) {
                    log.error("Error: Could not parse predefined CMAP file for '" + cmapName + "'");
                }
            }
            catch (IOException exception) {
                log.error("Error: Could not find predefined CMAP file for '" + cmapName + "'");
            }
        }
    }

    private void extractToUnicodeEncoding() {
        COSName encodingName = null;
        String cmapName = null;
        COSBase toUnicode = this.getToUnicode();
        if (toUnicode != null) {
            this.setHasToUnicode(true);
            if (toUnicode instanceof COSStream) {
                try {
                    this.parseCmap(null, ((COSStream)toUnicode).getUnfilteredStream());
                }
                catch (IOException exception) {
                    log.error("Error: Could not load embedded CMAP");
                }
            } else if (toUnicode instanceof COSName) {
                encodingName = (COSName)toUnicode;
                this.cmap = (CMap)cmapObjects.get(encodingName.getName());
                if (this.cmap == null) {
                    cmapName = encodingName.getName();
                    String resourceName = "org/apache/pdfbox/resources/cmap/" + cmapName;
                    try {
                        this.parseCmap("org/apache/pdfbox/resources/cmap/", ResourceLoader.loadResource(resourceName));
                    }
                    catch (IOException exception) {
                        log.error("Error: Could not find predefined CMAP file for '" + cmapName + "'");
                    }
                    if (this.cmap == null) {
                        log.error("Error: Could not parse predefined CMAP file for '" + cmapName + "'");
                    }
                }
            }
        }
    }
}

