/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.Font;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.FontManager;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontFactory;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;

public class PDType0Font
extends PDSimpleFont {
    private static final Log log = LogFactory.getLog(PDType0Font.class);
    private COSArray descendantFontArray;
    private PDFont descendentFont;
    private COSDictionary descendantFontDictionary;
    private Font awtFont;

    public PDType0Font() {
        this.font.setItem(COSName.SUBTYPE, (COSBase)COSName.TYPE0);
    }

    public PDType0Font(COSDictionary fontDictionary) {
        super(fontDictionary);
        this.descendantFontDictionary = (COSDictionary)this.getDescendantFonts().getObject(0);
        if (this.descendantFontDictionary != null) {
            try {
                this.descendentFont = PDFontFactory.createFont(this.descendantFontDictionary);
            }
            catch (IOException exception) {
                log.error("Error while creating the descendant font!");
            }
        }
    }

    public Font getawtFont() throws IOException {
        if (this.awtFont == null) {
            if (this.descendentFont != null) {
                this.awtFont = ((PDSimpleFont)this.descendentFont).getawtFont();
            }
            if (this.awtFont == null) {
                this.awtFont = FontManager.getStandardFont();
                log.info("Using font " + this.awtFont.getName() + " instead of " + this.descendentFont.getFontDescriptor().getFontName());
            }
        }
        return this.awtFont;
    }

    public PDRectangle getFontBoundingBox() throws IOException {
        throw new RuntimeException("Not yet implemented");
    }

    public float getFontWidth(byte[] c, int offset, int length) throws IOException {
        return this.descendentFont.getFontWidth(c, offset, length);
    }

    public float getFontHeight(byte[] c, int offset, int length) throws IOException {
        return this.descendentFont.getFontHeight(c, offset, length);
    }

    public float getAverageFontWidth() throws IOException {
        return this.descendentFont.getAverageFontWidth();
    }

    private COSArray getDescendantFonts() {
        if (this.descendantFontArray == null) {
            this.descendantFontArray = (COSArray)this.font.getDictionaryObject(COSName.DESCENDANT_FONTS);
        }
        return this.descendantFontArray;
    }

    public float getFontWidth(int charCode) {
        return this.descendentFont.getFontWidth(charCode);
    }

    public String encode(byte[] c, int offset, int length) throws IOException {
        if (this.hasToUnicode()) {
            return super.encode(c, offset, length);
        }
        int result = this.cmap.lookupCID(c, offset, length);
        if (result != -1) {
            return this.descendentFont.cmapEncoding(result, 2, true);
        }
        return null;
    }
}

