#       SCCS Id: @(#)Makefile.nt       3.2     96/10/30
#       Copyright (c) NetHack PC Development Team 1993, 1994, 1995, 1996
#
#       NetHack 3.2 Makefile for MS Visual C++ V4.x and MS NMAKE
#  
#       Win32 Compilers Tested:
#                              - Microsoft 32 bit Visual C++ V4.x
#
#       In addition to your C compiler,
#
#       if you want to change           you will need a
#       files with suffix               workalike for
#              .y                           yacc   (such as bison)
#              .l                           lex    (such as flex)
#
#
#       If you have any questions read the Install.nt file included with
#       the distribution.
#
#       Michael Allison
#
#----------------------------------------------------------------------
# Do not delete the following 3 lines.
#
TARGETOS=BOTH
APPVER=4.0
!include <win32.mak>

#
#  Set the gamedir according to your preference.  It must be present prior
#  to compilation.

GAME    = NetHack               # Game Name
GAMEDIR = \games\jnethackn      # Game directory

#
#  Source directories.    Makedefs hardcodes these, don't change them.
#

INCL  = ..\include   # NetHack include files
DAT   = ..\dat       # NetHack data files
DOC   = ..\doc       # NetHack documentation files
UTIL  = ..\util      # Utility source
SRC   = ..\src       # Main source
SYS   = ..\sys\share # Shared system files
NTSYS = ..\sys\winnt # NT Win32 specific files
TTY   = ..\win\tty   # window port files (tty)
WIN32 = ..\win\win32 # window port files (Win32)
WSHR  = ..\win\share # Tile support files 
JP    = ..\japanese  # JP
EXT   = ..\extension # Extension
WINRC = $(WIN32)\res # windows resource files

#
#  Object directory.
#

OBJ     = o


#
# Exe File Info.
# ($(MAKE) macro is often predefined, so we use $(MAKEBIN) instead.)
#

MAKEBIN = nmake

# 
# Yacc/Lex ... if you got 'em.
#
# If you have yacc and lex programs (or work-alike such as bison 
# and flex), comment out the upper two macros and uncomment 
# the lower two.
#

DO_YACC = YACC_MSG
DO_LEX  = LEX_MSG
#DO_YACC  = YACC_ACT
#DO_LEX   = LEX_ACT

#
# - Specify your yacc and lex programs (or work-alikes) here.
#

YACC	= bison -y
#YACC   = byacc
#YACC	= yacc

LEX	= lex
#LEX	= flex

#
# - Specify your flex skeleton file (if needed).
#

FLEXSKEL =
#FLEXSKEL = -S../tools/flex.ske

YTABC   = y.tab.c
YTABH   = y.tab.h
LEXYYC  = lex.yy.c

#
# Optional high-quality BSD random number generation routines
# (see pcconf.h). Set to nothing if not used.
#

RANDOM	= $(OBJ)\random.o
#RANDOM	=

#
# - For debugging ability, comment out the upper two 
#   macros and uncomment the lower two.
#

#
#  Leave the next two lines uncommented _ONLY_ if you do NOT want any
#  debug capability in the object files, or in the NetHack executable.
#  Comment them if you want debug capability.

#cdebug = /Gm /Zi /Od /D "_DEBUG"
#linkdebug = /debug
cdebug = /O2 
linkdebug = 

#
# For additional libraries
#
splibs = vfw32.lib winmm.lib

#
# Compiler and Linker flags
#

PRECOMPHEAD = N			# set to Y if you want to use precomp. headers


########################################################################
########################################################################
#
# Nothing below this line should have to be changed.
#

RESFILE = $(WINRC)\$(GAME).res

#Do not uncomment these for 3.2.1
TILEUTIL  = $(UTIL)\tile2bmp.exe
TILEBMP   = $(OBJ)\nhtiles.bmp
TILEGAME  = $(OBJ)\tile.o
TILEDEF   = -DTILES
#TILEHDR   =
#SOUND = $(OBJ)\ntsound.o

SOUND =
#TILEUTIL  =
#TILEBMP   =
#TILEGAME  =
#TILEDEF   =   
TILEHDR   =

USE_DLB = Y

! IF ("$(USE_DLB)"=="Y")
DLBFLG = -DDLB
! ELSE
DLBFLG =
! ENDIF

#
# - Util builds
#

CFLAGSU	= -c $(cflags) $(cvars) -I$(INCL) -nologo $(cdebug) $(TILEDEF) $(DLBFLG)
LFLAGSU	= $(linkdebug) $(conflags)

#
# - Game build
#
#

CFLAGSG	= $(CFLAGSU)
LFLAGSG	= $(guiflags) $(linkdebug) -IGNORE:505 $(guilibs) $(splibs)
#LFLAGSG	= $(conflags) $(linkdebug) -IGNORE:505 $(conlibs)


GAMEFILE = $(GAMEDIR)\$(GAME).exe # whole thing

#  This line should not be deleted.
NTSUB = -DWIN32CON

#
# Precompiled header verification
#

! IF ("$(PRECOMPHEAD)"=="Y")
PCHUSE  = /YuHACK.H /Fphack.pch
PCHMAK  = /YcHACK.H /Fphack.pch
PCH     = hack.pch
PCHOBJ  = pch.obj
! ELSE
PCHUSE  =
PCHMAK  =
PCH     =
PCHOBOJ =
! ENDIF

! IF ("$(USE_DLB)"=="Y")
DLB = nhdat
! ELSE
DLB =
! ENDIF

#
#  The default make target (so just typing 'nmake' is useful).
#
default : $(GAMEFILE)

#
#  Make Rules.
#

.SUFFIXES:  .exe .o .til .uu .c .y .l

#
# Rules for files in src
#


.c{$(OBJ)}.o:
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@ $<

{$(SRC)}.c{$(OBJ)}.o:
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB)  -Fo$@  $<

#
# Rules for files in sys\share
#

{$(SYS)}.c{$(OBJ)}.o:
	@$(cc) $(CFLAGSG) $(PCHUSE) -Fo$@  $<

#
# Rules for files in sys\winnt
#

{$(NTSYS)}.c{$(OBJ)}.o:
	@$(cc) $(CFLAGSG) $(PCHUSE) -Fo$@  $<

{$(NTSYS)}.h{$(INCL)}.h:
	@copy $< $@

#
# Rules for files in util
#

{$(UTIL)}.c{$(OBJ)}.o:
	@$(cc) $(CFLAGSU) $(NTSUB) -Fo$@ $<

#
# Rules for files in win\share
#

{$(WSHR)}.c{$(OBJ)}.o:
	@$(cc) $(CFLAGSG) $(PCHUSE) -Fo$@ $<

{$(WSHR)}.h{$(INCL)}.h:
	@copy $< $@

#{$(WSHR)}.txt{$(DAT)}.txt:
#	@copy $< $@


#
# Rules for files in win\tty
#

{$(TTY)}.c{$(OBJ)}.o:
	@$(cc) $(CFLAGSG) $(PCHUSE) -Fo$@  $<

#
# Rules for files in win\win32
#

{$(WIN32)}.c{$(OBJ)}.o:
	@$(cc) $(CFLAGSG) $(PCHUSE) -Fo$@  $<

#
# Rules for files in japanese
#

{$(JP)}.c{$(OBJ)}.o:
	@$(cc) $(CFLAGSG) $(PCHUSE) -Fo$@  $<

#
# Rules for files in extension
#

{$(EXT)}.c{$(OBJ)}.o:
	@$(cc) $(CFLAGSG) $(PCHUSE) -Fo$@  $<


#
# NETHACK OBJECTS
# 
# This section creates shorthand macros for many objects
# referenced later on in the Makefile.
#


DEFFILE = $(NTSYS)\$(GAME).def

#
# Shorten up the location for some files
#

O  = $(OBJ)^\

U  = $(UTIL)^\

W  = $(WIN32)^\

#
# Utility Objects.
#

MAKESRC        = $(U)makedefs.c

SPLEVSRC       = $(U)lev_yacc.c	$(U)lev_$(LEX).c $(U)lev_main.c  $(U)panic.c

DGNCOMPSRC     = $(U)dgn_yacc.c	$(U)dgn_$(LEX).c $(U)dgn_main.c

MAKEOBJS       = $(O)makedefs.o $(O)monst.o $(O)objects.o

SPLEVOBJS      = $(O)lev_yacc.o	$(O)lev_$(LEX).o $(O)lev_main.o \
		 $(O)alloc.o	$(O)decl.o	$(O)drawing.o \
		 $(O)monst.o	$(O)objects.o	$(O)panic.o

DGNCOMPOBJS    = $(O)dgn_yacc.o	$(O)dgn_$(LEX).o $(O)dgn_main.o \
		 $(O)alloc.o	$(O)panic.o

RECOVOBJS      = $(O)recover.o

#
# Leave these commented for 3.2.1
#
TEXT_IO        = $(O)tiletext.o	$(O)tiletxt.o	$(O)drawing.o \
		 $(O)decl.o	$(O)monst.o	$(O)objects.o
#
#GIFREADERS     = $(O)gifread.o	$(O)alloc.o $(O)panic.o
#
#PPMWRITERS     = $(O)ppmwrite.o $(O)alloc.o $(O)panic.o
#
#TILEFILES      = $(WSHR)\monsters.txt $(WSHR)\objects.txt $(WSHR)\other.txt

#
#  Object files for the game itself.
#

VOBJ01 = $(O)allmain.o  $(O)alloc.o    $(RANDOM)      $(O)apply.o
VOBJ02 = $(O)artifact.o $(O)attrib.o   $(O)ball.o     $(O)bones.o 
VOBJ03 = $(O)botl.o     $(O)cmd.o      $(O)dbridge.o  $(O)decl.o
VOBJ04 = $(O)detect.o   $(O)display.o  $(O)do.o       $(O)do_name.o
VOBJ05 = $(O)do_wear.o  $(O)dog.o      $(O)dogmove.o  $(O)dokick.o
VOBJ06 = $(O)dothrow.o  $(O)drawing.o  $(O)dungeon.o  $(O)eat.o
VOBJ07 = $(O)end.o      $(O)engrave.o  $(O)exper.o    $(O)explode.o
VOBJ08 = $(O)extralev.o $(O)files.o    $(O)fountain.o $(O)hack.o
VOBJ09 = $(O)hacklib.o  $(O)invent.o   $(O)lock.o     $(O)mail.o
VOBJ10 = $(O)main.o     $(O)makemon.o  $(O)mcastu.o   $(O)mhitm.o
VOBJ11 = $(O)mhitu.o    $(O)minion.o   $(O)mkmap.o    $(O)mklev.o
VOBJ12 = $(O)mkmaze.o   $(O)mkobj.o    $(O)mkroom.o   $(O)mon.o
VOBJ13 = $(O)mondata.o  $(O)monmove.o  $(O)monst.o    $(O)monstr.o
VOBJ14 = $(O)mplayer.o  $(O)mthrowu.o  $(O)muse.o     $(O)music.o
VOBJ15 = $(O)o_init.o   $(O)objects.o  $(O)objnam.o   $(O)options.o
VOBJ16 = $(O)pickup.o   $(O)pline.o    $(O)polyself.o $(O)potion.o
VOBJ17 = $(O)quest.o    $(O)questpgr.o $(O)pager.o    $(O)pray.o
VOBJ18 = $(O)priest.o   $(O)read.o     $(O)rect.o     $(O)restore.o
VOBJ19 = $(O)rip.o      $(O)rnd.o      $(O)rumors.o   $(O)save.o
VOBJ20 = $(O)shk.o      $(O)shknam.o   $(O)sit.o      $(O)sp_lev.o
VOBJ21 = $(O)spell.o    $(O)steal.o    $(O)timeout.o  $(O)sounds.o
VOBJ22 = $(O)topten.o   $(O)track.o    $(O)trap.o     $(O)u_init.o
VOBJ23 = $(O)uhitm.o    $(O)vault.o    $(O)vision.o   $(O)vis_tab.o
VOBJ24 = $(O)weapon.o   $(O)were.o     $(O)wield.o    $(O)windows.o
VOBJ25 = $(O)wizard.o   $(O)worm.o     $(O)worn.o     $(O)dig.o
VOBJ26 = $(O)write.o    $(O)zap.o      $(O)light.o    $(O)teleport.o
VOBJ27 = $(O)jlib.o     $(O)jtrns.o    $(O)jconj.o
VOBJ28 = $(O)extension.o $(O)nhbuf.o   $(O)nhinet.o

DLBOBJ = $(O)dlb.o

TTYOBJ = $(O)topl.o     $(O)getline.o  $(O)wintty.o

#WOBJ  = $(O)nhprocs.o  $(O)winmain.o  $(O)win32msg.o
WOBJ   = $(O)w_main.o   $(O)w_procs.o  $(O)w_base.o   $(O)w_font.o    \
         $(O)w_map.o    $(O)w_stat.o   $(O)w_mesg.o   $(O)w_menu.o    \
         $(O)w_misc.o   $(O)w_gdi3d.o  $(O)w_gdi2d.o  $(O)w_dibtile.o \
         $(O)w_glyph.o  $(O)w_key.o    $(O)w_cmd.o    $(O)w_sound.o   \
		 $(O)w_dialog.o	$(O)w_common.o

SOBJ   = $(O)winnt.o    $(O)sys.o      $(O)nttty.o    $(O)unix.o     $(SOUND)

OBJS   = $(VOBJ01) $(VOBJ02) $(VOBJ03) $(VOBJ04) $(VOBJ05) \
         $(VOBJ06) $(VOBJ07) $(VOBJ08) $(VOBJ09) $(VOBJ10) \
         $(VOBJ11) $(VOBJ12) $(VOBJ13) $(VOBJ14) $(VOBJ15) \
         $(VOBJ16) $(VOBJ17) $(VOBJ18) $(VOBJ19) $(VOBJ20) \
         $(VOBJ21) $(VOBJ22) $(VOBJ23) $(VOBJ24) $(VOBJ25) \
         $(VOBJ26) $(VOBJ27) $(VOBJ28) $(DLBOBJ)

TILOBJ = $(TILEGAME)

VVOBJ  = $(O)version.o

NVOBJ  = $(OBJS) $(TTYOBJ) $(WOBJ) $(SOBJ) $(TILOBJ)

ALLOBJ = $(NVOBJ) $(VVOBJ)

#
# Header objects
#

#NTCONF_H    = $(INCL)\ntwarn.h $(INCL)\ntconf.h $(INCL)\micro.h \
NTCONF_H    = $(INCL)\ntconf.h $(INCL)\micro.h \
	      $(INCL)\system.h $(INCL)\config.h
PERMONST_H  = $(INCL)\monattk.h $(INCL)\monflag.h
YOUPROP_H   = $(INCL)\prop.h $(PERMONST_H) $(INCL)\pm.h
YOU_H       = $(INCL)\attrib.h $(INCL)\monst.h $(YOUPROP_H)
DECL_H      = $(INCL)\quest.h $(INCL)\spell.h $(INCL)\color.h \
              $(INCL)\obj.h $(YOU_H) $(INCL)\onames.h

CONFIG_H    = $(INCL)\tradstdc.h $(INCL)\coord.h $(NTCONF_H)

HACK_H      = $(CONFIG_H) $(INCL)\dungeon.h $(INCL)\align.h $(INCL)\monsym.h \
              $(INCL)\mkroom.h $(INCL)\objclass.h $(DECL_H) $(INCL)\trap.h \
              $(INCL)\flag.h $(INCL)\rm.h $(INCL)\vision.h $(INCL)\mondata.h \
              $(INCL)\wintype.h $(INCL)\engrave.h $(INCL)\rect.h \
              $(INCL)\winprocs.h $(INCL)\trampoli.h \
              $(INCL)\align.h 
TILE_H      = $(INCL)\tile.h $(TILEHDR)
ALIGN_H     = $(INCL)\align.h
ARTIFACT_H  = $(INCL)\artifact.h
ARTILIST_H  = $(INCL)\artilist.h
COLOR_H     = $(INCL)\color.h
DATE_H      = $(INCL)\date.h
DLB_H       = $(INCL)\dlb.h
DGN_FILE_H  = $(INCL)\dgn_file.h
EMIN_H      = $(INCL)\emin.h
EPRI_H      = $(INCL)\epri.h
ESHK_H      = $(INCL)\eshk.h
EDOG_H      = $(INCL)\edog.h
FUNC_TAB_H  = $(INCL)\func_tab.h
LEV_H       = $(INCL)\lev.h
LEV_COMP_H  = $(INCL)\lev_comp.h
MAIL_H      = $(INCL)\mail.h
MFNDPOS_H   = $(INCL)\mfndpos.h
MONSYM_H    = $(INCL)\monsym.h
OBJ_H       = $(INCL)\obj.h
OBJCLASS_H  = $(INCL)\objclass.h
OBJECTS_H   = $(INCL)\objects.h
PROP_H      = $(INCL)\prop.h
QTEXT_H     = $(INCL)\qtext.h
QUEST_H     = $(INCL)\quest.h
SP_LEV_H    = $(INCL)\sp_lev.h
TERMCAP_H   = $(INCL)\termcap.h
VAULT_H     = $(INCL)\vault.h
VIS_TAB_H   = $(INCL)\vis_tab.h
WINTTY_H    = $(INCL)\wintty.h
WIN32API_H  = $(INCL)\win32api.h
WIN32_H     = $(INCL)\nhwin32.h
PATCHLEVEL_H   = $(INCL)\patchlevel.h

WINMAIN_H   = $(WIN32)\w_main.h
WINDIB_H    = $(WIN32)\w_dibtile.h

DATABASE = $(DAT)\data.base

#
#  The name of the game.
#

GAMEFILE = $(GAMEDIR)\$(GAME).exe


#######################################################################
#
#  TARGETS

#
#  The main target.
#

$(GAME): pchmsg $(O)obj.tag $(U)utility.tag $(TILEBMP) envchk $(GAMEFILE)
	@echo $(GAME) is up to date.

#
#  Everything
#

all :	install

install: envchk $(GAME) install.tag
	 @echo Done.

install.tag: 	$(DAT)\data	$(DAT)\jrumors	 $(DAT)\dungeon \
	 	$(DAT)\joracles	$(DAT)\quest.dat $(DAT)\sp_lev.tag $(DLB)
! IF ("$(USE_DLB)"=="Y")
	copy nhdat                $(GAMEDIR)
	copy $(DAT)\license       $(GAMEDIR)
! ELSE
	copy $(DAT)\*.            $(GAMEDIR)
	copy $(DAT)\*.dat         $(GAMEDIR)
	copy $(DAT)\*.lev         $(GAMEDIR)
	if exist $(GAMEDIR)\makefile del $(GAMEDIR)\makefile
! ENDIF
	if exist $(DOC)\jguidebook.txt copy $(DOC)\jguidebook.txt $(GAMEDIR)\jGuidebook.txt
	if exist $(DOC)\nethack.txt copy $(DOC)\nethack.txt $(GAMEDIR)\NetHack.txt
	if exist $(DOC)\recover.txt copy $(DOC)\recover.txt $(GAMEDIR)\recover.txt
	copy $(NTSYS)\winnt.cnf   $(GAMEDIR)\NetHack.cnf
	copy $(U)recover.exe  $(GAMEDIR)
! IF ("$(TILEBMP)"!="")
        if exist $(TILEBMP) copy $(TILEBMP) $(GAMEDIR)
! ENDIF
	echo install done > $@

#	copy $(NTSYS)\winnt.hlp    $(GAMEDIR)

pchmsg:
! IF ("$(PRECOMPHEAD)"=="Y")
	@echo Use of precompiled headers turned on.
! ELSE
	@echo Use of precompiled headers turned off.
! ENDIF


$(DAT)\sp_lev.tag: $(U)utility.tag $(DAT)\bigroom.des  $(DAT)\castle.des \
	$(DAT)\endgame.des $(DAT)\gehennom.des $(DAT)\knox.des   \
	$(DAT)\medusa.des  $(DAT)\oracle.des   $(DAT)\tower.des  \
	$(DAT)\yendor.des  $(DAT)\arch.des     $(DAT)\barb.des   \
	$(DAT)\caveman.des $(DAT)\elf.des      $(DAT)\healer.des \
	$(DAT)\knight.des  $(DAT)\priest.des   $(DAT)\rogue.des  \
	$(DAT)\samurai.des $(DAT)\tourist.des  $(DAT)\valkyrie.des \
	$(DAT)\wizard.des  $(DAT)\fighter.des
	cd $(DAT)
	$(U)lev_comp bigroom.des
	$(U)lev_comp castle.des
	$(U)lev_comp endgame.des
	$(U)lev_comp gehennom.des
	$(U)lev_comp knox.des
	$(U)lev_comp mines.des
	$(U)lev_comp medusa.des
	$(U)lev_comp oracle.des
	$(U)lev_comp tower.des
	$(U)lev_comp yendor.des
	$(U)lev_comp arch.des
	$(U)lev_comp barb.des
	$(U)lev_comp caveman.des
	$(U)lev_comp elf.des
	$(U)lev_comp healer.des
	$(U)lev_comp knight.des
	$(U)lev_comp priest.des
	$(U)lev_comp rogue.des
	$(U)lev_comp samurai.des
	$(U)lev_comp tourist.des
	$(U)lev_comp valkyrie.des
	$(U)lev_comp wizard.des
	$(U)lev_comp fighter.des
	cd $(SRC)
	echo sp_levs done > $(DAT)\sp_lev.tag

$(U)utility.tag: $(INCL)\date.h $(INCL)\onames.h $(INCL)\pm.h \
		$(SRC)\monstr.c		$(SRC)\vis_tab.c  \
		$(U)lev_comp.exe	$(VIS_TAB_H) \
		$(U)dgn_comp.exe $(U)recover.exe  $(TILEUTIL)
             @echo utilities made >$@
	     @echo utilities made.

tileutil: $(U)gif2txt.exe $(U)txt2ppm.exe
	@echo Optional tile development utilities are up to date.

#  The section for linking the NetHack image looks a little strange at 
#  first, especially if you are used to UNIX makes, or NDMAKE.  It is 
#  Microsoft nmake specific, and it gets around the problem of the 
#  link command line being too long for the linker.  An "in-line" linker 
#  response file is generated temporarily.
#
#  It takes advantage of the following features of nmake:
#
#  Inline files : 
#			Specifying the "<<" means to start an inline file.
#                 	Another "<<" at the start of a line closes the 
#                 	inline file.
#
#  Substitution within Macros:
#                       $(mymacro:string1=string2) replaces every
#                       occurrence of string1 with string2 in the 
#                       macro mymacro.  Special ascii key codes may be 
#                       used in the substitution text by preceding it 
#                       with ^ as we have done below.  Every occurence
#                       of a <tab> in $(ALLOBJ) is replaced by 
#                       <+><return><tab>.
#
#  DO NOT INDENT THE << below!
#

#
#  The main target.
#

$(GAMEFILE) :  $(RESFILE) $(ALLOBJ)
	@echo Linking....
	$(link) $(LFLAGSG) -out:$@ @<<$(GAME).lnk
		$(ALLOBJ:^	=^
		) 
		$(PCHOBJ)
		$(RESFILE)
		$(conlibs)
<<
	@if exist install.tag del install.tag
	@if exist $(GAMEDIR)\$(GAME).bak del $(GAMEDIR)\$(GAME).bak

#$(GAME).res : $(GAME).rc $(GAME)_.ico $(WIN32API_H) $(INCL)\nhwin32.h
#	rc -r $(GAME).rc
#
#$(GAME).rc : $(WIN32)\nhwin32.rc
#	@copy $(WIN32)\nhwin32.rc $@
#
#$(GAME)_.ico : $(NTSYS)\$(GAME).ico
#	@copy $(NTSYS)\$(GAME).ico $@

$(GAME).res : $(WINRC)\$(GAME).rc $(GAME)_.ico $(WIN32API_H) $(WINRC)\resource.h
	rc -r $(WINRC)\$(GAME).rc

$(GAME)_.ico : $(WINRC)\$(GAME).ico
	@copy $(WINRC)\$(GAME).ico $@
    
#
# Makedefs Stuff
#

$(U)makedefs.exe:	$(MAKEOBJS)
	$(link) $(LFLAGSU) -out:$@ $(MAKEOBJS) $(conlibs)

$(O)makedefs.o:  $(CONFIG_H)	$(PERMONST_H)   $(OBJCLASS_H) \
		 $(MONSYM_H)    $(QTEXT_H)	$(PATCHLEVEL_H) \
		 $(U)makedefs.c
	@$(cc) $(CFLAGSU) $(NTSUB) -Fo$@ $(U)makedefs.c

#
#  date.h should be remade every time any of the source or include
#  files is modified.
#

$(INCL)\date.h : $(U)makedefs.exe
	$(U)makedefs -v

$(INCL)\onames.h : $(U)makedefs.exe
	$(U)makedefs -o

$(INCL)\pm.h : $(U)makedefs.exe
	$(U)makedefs -p

#$(INCL)\trap.h : $(U)makedefs.exe
#	$(U)makedefs -t

$(SRC)\monstr.c: $(U)makedefs.exe
	$(U)makedefs -m

$(INCL)\vis_tab.h: $(U)makedefs.exe
	$(U)makedefs -z

$(SRC)\vis_tab.c: $(U)makedefs.exe
	$(U)makedefs -z

$(INCL)\jdata.h: $(U)makedefs.exe $(DAT)\jtrnsobj.dat $(DAT)\jtrnsmon.dat
	$(U)makedefs -j

#
# Level Compiler Stuff
#

$(U)lev_comp.exe:  $(SPLEVOBJS)
	@echo Linking $@...
	$(link) $(LFLAGSU) -out:$@ @<<$(@B).lnk
 		$(SPLEVOBJS:^	=^
		)
		$(PCHOBJ)
		$(conlibs)
<<

$(O)lev_yacc.o:  $(HACK_H)   $(SP_LEV_H) $(INCL)\lev_comp.h $(U)lev_yacc.c
	@$(cc) $(CFLAGSU) -W0 $(NTSUB) -Fo$@ $(U)lev_yacc.c

$(O)lev_$(LEX).o:  $(HACK_H)   $(INCL)\lev_comp.h $(SP_LEV_H) \
               $(U)lev_$(LEX).c
	@$(cc) $(CFLAGSU) -W0 $(NTSUB) -Fo$@ $(U)lev_$(LEX).c

$(O)lev_main.o:	$(U)lev_main.c $(HACK_H)   $(SP_LEV_H)
	@$(cc) $(CFLAGSU) -W0 $(NTSUB) -Fo$@ $(U)lev_main.c


$(U)lev_yacc.c $(INCL)\lev_comp.h : $(U)lev_comp.y
!	IF "$(DO_YACC)"=="YACC_ACT"
	   chdir $(UTIL)
	   $(YACC) -d lev_comp.y
	   copy $(YTABC) lev_yacc.c
	   copy $(YTABH) $(INCL)\lev_comp.h
	   @del $(YTABC)
	   @del $(YTABH)
	   chdir $(SRC)
!	ELSE
	   @echo $(U)lev_comp.y has changed.
	   @echo To update $(U)lev_yacc.c and $(INCL)\lev_comp.h run $(YACC).
	   @echo ------
	   @echo For now, we will copy the prebuilt lev_yacc.c and 
	   @echo lev_comp.h from $(SYS) into $(UTIL) and use them.
	   @copy $(SYS)\lev_yacc.c $(U)lev_yacc.c >nul
	   @copy $(SYS)\lev_comp.h $(INCL)\lev_comp.h >nul
	   @echo /**/ >>$(U)lev_yacc.c
	   @echo /**/ >>$(INCL)\lev_comp.h
!	ENDIF

$(U)lev_$(LEX).c:  $(U)lev_comp.l
!	IF "$(DO_LEX)"=="LEX_ACT"
	   chdir $(UTIL)
	   $(LEX) $(FLEXSKEL) lev_comp.l
	   copy $(LEXYYC) $@
	   @del $(LEXYYC)
	   chdir $(SRC)
!	ELSE
	   @echo $(U)lev_comp.l has changed. To update $@ run $(LEX).
	   @echo -----
	   @echo For now, we will copy the prebuilt lev_lex.c 
	   @echo from $(SYS) into $(UTIL) and use it.
	   @copy $(SYS)\lev_lex.c $@ >nul
	   @echo /**/ >>$@
!	ENDIF

#
# Dungeon Stuff
#

$(U)dgn_comp.exe: $(DGNCOMPOBJS)
    @echo Linking $@...
	$(link) $(LFLAGSU) -out:$@ @<<$(@B).lnk
		$(DGNCOMPOBJS:^	=^
		)
		$(PCHOBJ)
		$(conlibs)
<<

$(O)dgn_yacc.o:	$(HACK_H)   $(DGN_FILE_H) $(INCL)\dgn_comp.h $(U)dgn_yacc.c
	@$(cc) $(CFLAGSU) -W0 $(NTSUB) -Fo$@ $(U)dgn_yacc.c

$(O)dgn_$(LEX).o: $(HACK_H)   $(DGN_FILE_H)  $(INCL)\dgn_comp.h \
	$(U)dgn_$(LEX).c
	@$(cc) $(CFLAGSU) -W0 $(NTSUB) -Fo$@ $(U)dgn_$(LEX).c

$(O)dgn_main.o:	$(HACK_H) $(U)dgn_main.c
	@$(cc) $(CFLAGSU) -W0 $(NTSUB) -Fo$@ $(U)dgn_main.c

$(U)dgn_yacc.c $(INCL)\dgn_comp.h : $(U)dgn_comp.y
!	IF "$(DO_YACC)"=="YACC_ACT"
	   chdir $(UTIL)
	   $(YACC) -d dgn_comp.y
	   copy $(YTABC) dgn_yacc.c
	   copy $(YTABH) $(INCL)\dgn_comp.h
	   @del $(YTABC)
	   @del $(YTABH)
	   chdir $(SRC)
!	ELSE
	   @echo $(U)dgn_comp.y has changed. To update dgn_yacc.c and 
	   @echo $(INCL)\dgn_comp.h run $(YACC).
	   @echo ----
	   @echo For now, we will copy the prebuilt $(U)dgn_yacc.c and 
	   @echo dgn_comp.h from $(SYS) into $(UTIL) and use them.
	   @copy $(SYS)\dgn_yacc.c $(U)dgn_yacc.c >nul
	   @copy $(SYS)\dgn_comp.h $(INCL)\dgn_comp.h >nul
	   @echo /**/ >>$(U)dgn_yacc.c
	   @echo /**/ >>$(INCL)\dgn_comp.h
!	ENDIF

$(U)dgn_$(LEX).c:  $(U)dgn_comp.l
!	IF "$(DO_LEX)"=="LEX_ACT"
	   chdir $(UTIL)
	   $(LEX) $(FLEXSKEL)  dgn_comp.l
	   copy $(LEXYYC) $@
	   @del $(LEXYYC)
	   chdir $(SRC)
!	ELSE
	   @echo $(U)dgn_comp.l has changed. To update $@ run $(LEX).
	   @echo ---
	   @echo For now, we will copy the prebuilt dgn_lex.c 
	   @echo from $(SYS) into $(UTIL) and use it.
	   @copy $(SYS)\dgn_lex.c $@ >nul
	   @echo /**/ >>$@
!	ENDIF


$(O)obj.tag:
	@if not exist $(O)*.* mkdir $(OBJ)
	@echo directory $(OBJ) created >$@

#
#
envchk:
!	IF "$(CL)"!=""
	   @echo Warning, the CL Environment variable is defined:
	   @echo CL=$(CL)
!	ENDIF
!	IF "$(TILEGAME)"!=""
	   @echo -------------------------------------------
	   @echo NOTE: This build will include tile support.
	   @echo -------------------------------------------
!	ENDIF

#
# SECONDARY TARGETS
#

#
# Header files NOT distributed in ..\include
#

$(INCL)\tile.h: $(WSHR)\tile.h
	copy $(WSHR)\tile.h $@

$(INCL)\nhwin32.h: $(WIN32)\nhwin32.h
	copy $(WIN32)\nhwin32.h $@

$(INCL)\win32api.h: $(NTSYS)\win32api.h
	copy $(NTSYS)\win32api.h $@

#$(INCL)\ntwarn.h: $(NTSYS)\ntwarn.h
#	copy $(NTSYS)\ntwarn.h $@

#$(INCL)\pctiles.h: $(NTSYS)\pctiles.h
#	copy $(NTSYS)\pctiles.h $@

#$(INCL)\pcvideo.h: $(NTSYS)\pcvideo.h
#	copy $(NTSYS)\pcvideo.h $@

#
#  Recover Utility
#

$(U)recover.exe: $(RECOVOBJS)
	$(link) $(LFLAGSU) -out:$@ $(RECOVOBJS) $(conlibs)

#
#  Tile Mapping
#

$(SRC)\tile.c: $(U)tilemap.exe
	@echo A new $@ has been created
	@$(U)tilemap

$(U)tilemap.exe: $(O)tilemap.o
	$(link) $(LFLAGSU) -out:$@ $(O)tilemap.o $(conlibs)

$(O)tilemap.o:  $(WSHR)\tilemap.c $(HACK_H)
	@$(cc) $(CFLAGSU) $(NTSUB) -Fo$@ $(WSHR)\tilemap.c


#
# Tile Utilities
#

#
#  Optional (for development)
#

$(U)gif2txt.exe: $(GIFREADERS) $(TEXT_IO)
    @echo Linking $@...
	$(link) $(LFLAGSU) -out:$@ @<<$(@B).lnk
		$(GIFREADERS:^	=^
		)
		$(TEXT_IO:^	=^
		)
		$(PCHOBJ)
		$(conlibs)
<<

$(U)txt2ppm.exe: $(PPMWRITERS) $(TEXT_IO)
    @echo Linking $@...
	$(link) $(LFLAGSU) -out:$@ @<<$(@B).lnk
		$(PPMWRITERS:^	=^
		)
		$(TEXT_IO:^	=^
		)
		$(PCHOBJ)
		$(conlibs)
<<

#
#  Required for tile support
#

! IF ("$(TILEBMP)"!="")

$(TILEBMP): $(TILEUTIL) $(TILEFILES)
	@echo Creating binary tile files (this may take some time)
	@$(U)tile2bmp $(TILEBMP)

$(U)tile2bmp.exe: $(O)tile2bmp.o $(TEXT_IO)
    @echo Linking $@...
	$(link) $(LFLAGSU) -out:$@ @<<$(@B).lnk
		$(O)tile2bmp.o
		$(TEXT_IO:^  =^
		)
		$(PCHOBJ)
		$(conlibs)
<<

$(O)tile2bmp.o:  $(WIN32)\tile2bmp.c $(HACK_H) $(TILE_H) $(WIN32API_H)
	@$(cc) $(CFLAGSG) $(NTSUB) /DPACKED_FILE /Fo$@ $(WIN32)\tile2bmp.c

! ENDIF
#
# DLB stuff
#
nhdat:	$(U)dlb_main.exe $(DAT)\data $(DAT)\joracles $(DAT)\options \
	$(DAT)\quest.dat $(DAT)\jrumors $(DAT)\jhelp $(DAT)\jhh $(DAT)\jcmdhelp \
	$(DAT)\jhistory $(DAT)\jopthelp $(DAT)\jwizhelp $(DAT)\dungeon \
	$(DAT)\license $(DAT)\jjj $(DAT)\sp_lev.tag
	cd $(DAT)
	echo data >dlb.lst
	echo joracles >>dlb.lst
	echo options >>dlb.lst
	echo quest.dat >>dlb.lst
	echo jrumors >>dlb.lst
	echo jhelp >>dlb.lst
	echo jhh >>dlb.lst
	echo jcmdhelp >>dlb.lst
	echo jhistory >>dlb.lst
	echo jopthelp >>dlb.lst
	echo jwizhelp >>dlb.lst
	echo dungeon >>dlb.lst
	echo license >>dlb.lst
	echo jjj >>dlb.lst
	for %%N in (*.lev) do echo %%N >>dlb.lst
	$(U)dlb_main cIf dlb.lst $(SRC)\nhdat
	cd $(SRC)

$(U)dlb_main.exe: $(DLBOBJ) $(O)dlb.o
	$(link) $(LFLAGSU) -out:$@ @<<$(@B).lnk
		$(O)dlb_main.o
		$(O)dlb.o
		$(O)alloc.o
		$(O)panic.o
		$(conlibs)
<<

$(O)dlb.o:	$(O)dlb_main.o $(O)alloc.o $(O)panic.o $(DLB_H)
	@$(cc) $(CFLAGSG) $(NTSUB) /Fo$@ $(SRC)\dlb.c
	
$(O)dlb_main.o: $(UTIL)\dlb_main.c $(INCL)\config.h $(DLB_H)
	@$(cc) $(CFLAGSG) $(NTSUB) /Fo$@ $(UTIL)\dlb_main.c

#
# Housekeeping
#

spotless: clean
	rmdir $(OBJ)
	if exist $(DATE_H)    del $(DATE_H)
	if exist $(INCL)\onames.h  del $(INCL)\onames.h
	if exist $(INCL)\pm.h      del $(INCL)\pm.h
	if exist $(VIS_TAB_H) del $(VIS_TAB_H)
	if exist $(SRC)\vis_tab.c  del $(SRC)\vis_tab.c
	if exist $(SRC)\tile.c     del $(SRC)\tile.c
	if exist $(U)*.lnk         del $(U)*.lnk
	if exist $(U)*.map         del $(U)*.map
	if exist $(DAT)\data       del $(DAT)\data
	if exist $(DAT)\rumors     del $(DAT)\rumors
	if exist $(DAT)\?-fill?.lev	del $(DAT)\?-fill?.lev
	if exist $(DAT)\?-goal.lev	del $(DAT)\?-goal.lev
	if exist $(DAT)\?-locate.lev	del $(DAT)\?-locate.lev
	if exist $(DAT)\?-start.lev	del $(DAT)\?-start.lev
	if exist $(DAT)\air.lev		del $(DAT)\air.lev
	if exist $(DAT)\asmodeus.lev	del $(DAT)\asmodeus.lev
	if exist $(DAT)\astral.lev	del $(DAT)\astral.lev
	if exist $(DAT)\baalz.lev	del $(DAT)\baalz.lev
	if exist $(DAT)\bigroom.lev	del $(DAT)\bigroom.lev
	if exist $(DAT)\castle.lev	del $(DAT)\castle.lev
	if exist $(DAT)\data		del $(DAT)\data
	if exist $(DAT)\dungeon		del $(DAT)\dungeon
	if exist $(DAT)\dungeon.pdf	del $(DAT)\dungeon.pdf
	if exist $(DAT)\earth.lev	del $(DAT)\earth.lev
	if exist $(DAT)\fakewiz?.lev	del $(DAT)\fakewiz?.lev
	if exist $(DAT)\fire.lev	del $(DAT)\fire.lev
	if exist $(DAT)\juiblex.lev	del $(DAT)\juiblex.lev
	if exist $(DAT)\knox.lev	del $(DAT)\knox.lev
	if exist $(DAT)\medusa-?.lev	del $(DAT)\medusa-?.lev
	if exist $(DAT)\mine*.lev	del $(DAT)\mine*.lev
	if exist $(DAT)\options		del $(DAT)\options
	if exist $(DAT)\oracle.lev	del $(DAT)\oracle.lev
	if exist $(DAT)\joracles	del $(DAT)\joracles
	if exist $(DAT)\orcus.lev	del $(DAT)\orcus.lev
	if exist $(DAT)\jrumors		del $(DAT)\jrumors
	if exist $(DAT)\quest.dat	del $(DAT)\quest.dat
	if exist $(DAT)\sanctum.lev	del $(DAT)\sanctum.lev
	if exist $(DAT)\tower?.lev	del $(DAT)\tower?.lev
	if exist $(DAT)\valley.lev	del $(DAT)\valley.lev
	if exist $(DAT)\water.lev	del $(DAT)\water.lev
	if exist $(DAT)\wizard?.lev	del $(DAT)\wizard?.lev
	if exist $(DAT)\sp_lev.tag	del $(DAT)\sp_lev.tag
	if exist $(SRC)\monstr.c   del $(SRC)\monstr.c
	if exist $(SRC)\vis_tab.c  del $(SRC)\vis_tab.c
	if exist $(U)recover.exe     del $(U)recover.exe
	if exist $(INCL)\jdata.h        del $(INCL)\jdata.h

clean:
	if exist $(O)*.o del $(O)*.o
	if exist $(U)utility.tag   del $(U)utility.tag
	if exist $(U)makedefs.exe  del $(U)makedefs.exe
	if exist $(U)lev_comp.exe  del $(U)lev_comp.exe
	if exist $(U)dgn_comp.exe  del $(U)dgn_comp.exe
	if exist $(SRC)\*.lnk      del $(SRC)\*.lnk
	if exist $(SRC)\*.map      del $(SRC)\*.map
! IF ("$(TILEBMP)"!="")
	if exist $(TILEBMP)        del $(TILEBMP)
! ENDIF

#
# OTHER DEPENDENCIES
#

#
# Precompiled header source file build
#
pch.c:
	@echo #include "hack.h" >pch.c
	@echo void fakefile(int argc, char *argv[]); >>pch.c
	@echo fakefile(int argc, char *argv[]) >>pch.c
	@echo { >>pch.c
	@echo } >>pch.c
	@echo /**/ >>pch.c

hack.pch: $(HACK_H) pch.c
	@echo Generating new precompiled header: hack.pch
	$(CC) $(CFLAGSG) $(PCHMAK) pch.c

#
# dat dependencies
#

$(DAT)\data: $(U)utility.tag    $(DATABASE)
	$(U)makedefs -d

$(DAT)\rumors: $(U)utility.tag    $(DAT)\rumors.tru   $(DAT)\rumors.fal
	$(U)makedefs -r

$(DAT)\jrumors: $(U)utility.tag    $(DAT)\jrumors.tru   $(DAT)\jrumors.fal
	$(U)makedefs -r

$(DAT)\quest.dat: $(U)utility.tag  $(DAT)\quest.txt
	$(U)makedefs -q

$(DAT)\oracles: $(U)utility.tag    $(DAT)\oracles.txt
	$(U)makedefs -h

$(DAT)\joracles: $(U)utility.tag    $(DAT)\joracles.txt
	$(U)makedefs -h

$(DAT)\dungeon: $(U)utility.tag  $(DAT)\dungeon.def
	$(U)makedefs -e
	cd $(DAT)
	$(U)dgn_comp dungeon.pdf
	cd $(SRC)

#
#  Util Dependencies.
#

$(O)panic.o:   $(U)panic.c $(CONFIG_H)
	@$(cc) $(CFLAGSG) $(NTSUB) -Fo$@ $(U)panic.c

$(O)recover.o: $(CONFIG_H) $(U)recover.c
	@$(cc) $(CFLAGSU) $(NTSUB) -Fo$@ $(U)recover.c

#
#  from win\share
#

$(O)tiletxt.o:  $(WSHR)\tilemap.c $(HACK_H)
	@$(cc) $(CFLAGSG) $(NTSUB) /DTILETEXT -Fo$@ $(WSHR)\tilemap.c

$(O)gifread.o:  $(WSHR)\gifread.c  $(CONFIG_H) $(INCL)\tile.h
	@$(cc) $(CFLAGSG) $(NTSUB) -Fo$@ $(WSHR)\gifread.c

$(O)ppmwrite.o: $(WSHR)\ppmwrite.c $(CONFIG_H) $(INCL)\tile.h
	@$(cc) $(CFLAGSG) $(NTSUB) -Fo$@ $(WSHR)\ppmwrite.c

$(O)tiletext.o:  $(WSHR)\tiletext.c  $(CONFIG_H) $(INCL)\tile.h
	@$(cc) $(CFLAGSG) $(NTSUB) -Fo$@ $(WSHR)\tiletext.c

#
#  from win\tty
#

$(O)wintty.o: $(CONFIG_H) $(TTY)\wintty.c $(PATCHLEVEL_H)
	@$(cc) $(CFLAGSG) $(NTSUB) -Fo$@ $(TTY)\wintty.c

$(O)getline.o:  $(PCH) $(TTY)\getline.c  $(HACK_H) $(WINTTY_H) $(FUNC_TAB_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(TTY)\getline.c

$(O)termcap.o:  $(PCH) $(TTY)\termcap.c  $(HACK_H) $(WINTTY_H) $(TERMCAP_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(TTY)\termcap.c

$(O)topl.o:     $(PCH) $(TTY)\topl.c     $(HACK_H) $(TERMCAP_H) $(WINTTY_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(TTY)\topl.c

#
#  from win\win32
#

#$(O)nhprocs.o:  $(PCH) $(WIN32)\nhprocs.c  $(HACK_H) $(WIN32_H) \
#		$(FUNC_TAB_H) $(WIN32API_H)
#	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(WIN32)\nhprocs.c
#
#$(O)winmain.o:  $(PCH) $(WIN32)\winmain.c  $(HACK_H) $(WIN32_H) $(WIN32API_H)
#	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(WIN32)\winmain.c
#
#$(O)win32msg.o:  $(PCH) $(WIN32)\win32msg.c  $(HACK_H) $(WIN32_H) $(WIN32API_H)
#	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(WIN32)\win32msg.c

$(O)w_procs.o:  $(PCH) $(WIN32)\w_procs.c  $(HACK_H) $(WIN32_H) $(WIN32API_H) $(WINMAIN_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(WIN32)\w_procs.c

$(O)w_main.o:  $(PCH) $(WIN32)\w_main.c  $(HACK_H) $(WIN32_H) $(WIN32API_H) $(WINMAIN_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(WIN32)\w_main.c

$(O)w_menu.o:  $(PCH) $(WIN32)\w_menu.c  $(HACK_H) $(WIN32_H) $(WIN32API_H) $(WINMAIN_H) $(WINDIB_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(WIN32)\w_menu.c

$(O)w_map.o:  $(PCH) $(WIN32)\w_map.c  $(HACK_H) $(WIN32_H) $(WIN32API_H) $(WINMAIN_H) $(WINDIB_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(WIN32)\w_map.c

$(O)w_base.o:  $(PCH) $(WIN32)\w_base.c  $(HACK_H) $(WIN32_H) $(WIN32API_H) $(WINMAIN_H) $(WINDIB_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(WIN32)\w_base.c

$(O)w_stat.o:  $(PCH) $(WIN32)\w_stat.c  $(HACK_H) $(WIN32_H) $(WIN32API_H) $(WINMAIN_H) $(WINDIB_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(WIN32)\w_stat.c

$(O)w_mesg.o:  $(PCH) $(WIN32)\w_mesg.c  $(HACK_H) $(WIN32_H) $(WIN32API_H) $(WINMAIN_H) $(WINDIB_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(WIN32)\w_mesg.c

$(O)w_misc.o:  $(PCH) $(WIN32)\w_misc.c  $(HACK_H) $(WIN32_H) $(WIN32API_H) $(WINMAIN_H) $(WINDIB_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(WIN32)\w_misc.c

$(O)w_key.o: $(PCH) $(WIN32)\w_key.c  $(HACK_H) $(WIN32_H) $(WIN32API_H) $(WINMAIN_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(WIN32)\w_key.c

$(O)w_dibtile.o: $(PCH) $(WIN32)\w_dibtile.c  $(HACK_H) $(WIN32_H) $(WIN32API_H) $(WINDIB_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(WIN32)\w_dibtile.c

$(O)w_gdi3d.o: $(PCH) $(WIN32)\w_gdi3d.c  $(HACK_H) $(WIN32_H) $(WIN32API_H) $(WINMAIN_H) $(WINDIB_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(WIN32)\w_gdi3d.c

$(O)w_gdi2d.o: $(PCH) $(WIN32)\w_gdi2d.c  $(HACK_H) $(WIN32_H) $(WIN32API_H) $(WINMAIN_H) $(WINDIB_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(WIN32)\w_gdi2d.c

$(O)w_glyph.o: $(PCH) $(WIN32)\w_glyph.c  $(HACK_H) $(WIN32_H) $(WIN32API_H) $(WINMAIN_H) $(WINDIB_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(WIN32)\w_glyph.c

$(O)w_font.o: $(PCH) $(WIN32)\w_font.c  $(HACK_H) $(WIN32_H) $(WIN32API_H) $(WINMAIN_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(WIN32)\w_font.c

$(O)w_cmd.o: $(PCH) $(WIN32)\w_cmd.c  $(HACK_H) $(WIN32_H) $(WIN32API_H) $(WINMAIN_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(WIN32)\w_cmd.c

$(O)w_sound.o: $(PCH) $(WIN32)\w_sound.c  $(HACK_H) $(WIN32_H) $(WIN32API_H) $(WINMAIN_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(WIN32)\w_sound.c

$(O)w_dialog.o: $(PCH) $(WIN32)\w_dialog.c  $(HACK_H) $(WIN32_H) $(WIN32API_H) $(WINMAIN_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(WIN32)\w_dialog.c

$(O)w_common.o: $(PCH) $(WIN32)\w_common.c  $(HACK_H) $(WIN32_H) $(WIN32API_H) $(WINMAIN_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(WIN32)\w_common.c

#
# from sys\share
#

$(O)main.o:   $(PCH) $(HACK_H) $(SYS)\pcmain.c $(WIN32API_H)
	@$(cc)  $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@ $(SYS)\pcmain.c

$(O)unix.o:   $(PCH) $(SYS)\pcunix.c   $(HACK_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(SYS)\pcunix.c

#$(O)tty.o:    $(PCH) $(HACK_H) $(WINTTY_H) $(SYS)\pctty.c
#	@$(cc)  $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@  $(SYS)\pctty.c

$(O)sys.o:    $(PCH) $(HACK_H) $(SYS)\pcsys.c
	@$(cc)  $(CFLAGSG) $(NTSUB) -Fo$@ $(SYS)\pcsys.c

$(O)random.o: $(PCH) $(HACK_H) $(SYS)\random.c
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@ $(SYS)\random.c

#
# from sys\winnt
#

$(O)nttty.o:    $(NTSYS)\nttty.c   $(HACK_H) $(WINTTY_H) \
                $(TILE_H) $(WIN32API_H)
	@$(cc) $(CFLAGSG) $(NTSUB) -Fo$@  $(NTSYS)\nttty.c

$(O)winnt.o:   $(NTSYS)\winnt.c   $(HACK_H) $(WIN32API_H)
	@$(cc) $(CFLAGSG) $(NTSUB) -Fo$@  $(NTSYS)\winnt.c

$(O)ntsound.o: $(PCH) $(NTSYS)\ntsound.c   $(HACK_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@ $(NTSYS)\ntsound.c

#
# from src
#

$(O)allmain.o:  $(PCH) $(SRC)\allmain.c  $(HACK_H)
$(O)alloc.o:           $(SRC)\alloc.c    $(CONFIG_H)
	@$(cc) $(CFLAGSG) $(NTSUB) -Fo$@ $(SRC)\alloc.c
$(O)apply.o:    $(PCH) $(SRC)\apply.c    $(HACK_H) $(EDOG_H)
$(O)artifact.o: $(PCH) $(SRC)\artifact.c $(HACK_H) $(ARTIFACT_H) $(ARTILIST_H)
$(O)attrib.o:   $(PCH) $(SRC)\attrib.c   $(HACK_H)
$(O)ball.o:     $(PCH) $(SRC)\ball.c     $(HACK_H)
$(O)bones.o:    $(PCH) $(SRC)\bones.c    $(HACK_H) $(LEV_H)
$(O)botl.o:     $(PCH) $(SRC)\botl.c     $(HACK_H)
$(O)cmd.o:      $(PCH) $(SRC)\cmd.c      $(HACK_H) $(FUNC_TAB_H)
$(O)dbridge.o:  $(PCH) $(SRC)\dbridge.c  $(HACK_H)
$(O)decl.o:     $(PCH) $(SRC)\decl.c     $(HACK_H) $(QUEST_H)
$(O)detect.o:   $(PCH) $(SRC)\detect.c   $(HACK_H) $(ARTIFACT_H)
$(O)dlb.o:      $(PCH) $(SRC)\dlb.c      $(HACK_H) $(DLB_H)
$(O)display.o:  $(PCH) $(SRC)\display.c  $(HACK_H)
$(O)dig.o:      $(PCH) $(SRC)\dig.c      $(HACK_H)
$(O)do.o:       $(PCH) $(SRC)\do.c       $(HACK_H) $(LEV_H)
$(O)do_name.o:  $(PCH) $(SRC)\do_name.c  $(HACK_H)
$(O)do_wear.o:  $(PCH) $(SRC)\do_wear.c  $(HACK_H)
$(O)dog.o:      $(PCH) $(SRC)\dog.c      $(HACK_H) $(EDOG_H)
$(O)dogmove.o:  $(PCH) $(SRC)\dogmove.c  $(HACK_H) $(MFNDPOS_H) $(EDOG_H)
$(O)dokick.o:   $(PCH) $(SRC)\dokick.c   $(HACK_H) $(ESHK_H)
$(O)dothrow.o:  $(PCH) $(SRC)\dothrow.c  $(HACK_H)
$(O)drawing.o:  $(PCH) $(SRC)\drawing.c  $(HACK_H) $(TERMCAP_H)
$(O)dungeon.o:  $(PCH) $(SRC)\dungeon.c  $(HACK_H) $(ALIGN_H) $(DGN_FILE_H)
$(O)eat.o:      $(PCH) $(SRC)\eat.c      $(HACK_H)
$(O)end.o:             $(SRC)\end.c      $(HACK_H) $(ESHK_H) $(DLB_H)
	@$(cc) $(CFLAGSG) $(NTSUB) -Fo$@ $(SRC)\end.c
$(O)engrave.o:  $(PCH) $(SRC)\engrave.c  $(HACK_H) $(LEV_H)
$(O)exper.o:    $(PCH) $(SRC)\exper.c    $(HACK_H)
$(O)explode.o:  $(PCH) $(SRC)\explode.c  $(HACK_H)
$(O)extralev.o: $(PCH) $(SRC)\extralev.c $(HACK_H)
$(O)files.o:    $(PCH) $(SRC)\files.c    $(HACK_H)
$(O)fountain.o: $(PCH) $(SRC)\fountain.c $(HACK_H)
$(O)hack.o:     $(PCH) $(SRC)\hack.c     $(HACK_H)
$(O)hacklib.o:  $(PCH) $(SRC)\hacklib.c  $(HACK_H)
$(O)invent.o:   $(PCH) $(SRC)\invent.c   $(HACK_H) $(ARTIFACT_H)
$(O)lock.o:     $(PCH) $(SRC)\lock.c     $(HACK_H)
$(O)mail.o:     $(PCH) $(SRC)\mail.c     $(HACK_H) $(MAIL_H)
$(O)makemon.o:  $(PCH) $(SRC)\makemon.c  $(HACK_H) $(EPRI_H) $(EMIN_H)
$(O)mcastu.o:   $(PCH) $(SRC)\mcastu.c   $(HACK_H)
$(O)mhitm.o:    $(PCH) $(SRC)\mhitm.c    $(HACK_H) $(ARTIFACT_H) $(EDOG_H)
$(O)minion.o:   $(PCH) $(SRC)\minion.c   $(HACK_H) $(EMIN_H) $(EPRI_H)
$(O)mklev.o:    $(PCH) $(SRC)\mklev.c    $(HACK_H)
$(O)mkmap.o:    $(PCH) $(SRC)\mkmap.c    $(HACK_H) $(SP_LEV_H)
$(O)mkmaze.o:   $(PCH) $(SRC)\mkmaze.c   $(HACK_H) $(SP_LEV_H)
$(O)mkobj.o:    $(PCH) $(SRC)\mkobj.c    $(HACK_H) $(ARTIFACT_H) $(PROP_H)
$(O)mkroom.o:   $(PCH) $(SRC)\mkroom.c   $(HACK_H)
$(O)mon.o:      $(PCH) $(SRC)\mon.c      $(HACK_H) $(MFNDPOS_H) $(EDOG_H)
$(O)mondata.o:  $(PCH) $(SRC)\mondata.c  $(HACK_H) $(ESHK_H) $(EPRI_H)
$(O)monmove.o:  $(PCH) $(SRC)\monmove.c  $(HACK_H) $(MFNDPOS_H) $(ARTIFACT_H)
$(O)monst.o:           $(SRC)\monst.c    $(CONFIG_H) $(PERMONST_H) $(MONSYM_H) \
                 $(ESHK_H) $(EPRI_H) $(VAULT_H) $(ALIGN_H)
	@$(cc) $(CFLAGSG) $(NTSUB) -Fo$@ $(SRC)\monst.c
$(O)monstr.o:          $(SRC)\monstr.c   $(CONFIG_H)
	@$(cc) $(CFLAGSG) $(NTSUB) -Fo$@ $(SRC)\monstr.c
$(O)mplayer.o:  $(PCH) $(SRC)\mplayer.c  $(HACK_H)
$(O)mthrowu.o:  $(PCH) $(SRC)\mthrowu.c  $(HACK_H)
$(O)muse.o:     $(PCH) $(SRC)\muse.c     $(HACK_H)
$(O)music.o:    $(PCH) $(SRC)\music.c    $(HACK_H)
$(O)o_init.o:   $(PCH) $(SRC)\o_init.c   $(HACK_H)
$(O)objects.o:  $(SRC)\objects.c  $(CONFIG_H) $(OBJ_H) $(OBJCLASS_H) \
                 $(PROP_H) $(COLOR_H)
	@$(cc) $(CFLAGSG) $(NTSUB) -Fo$@ $(SRC)\objects.c
$(O)objnam.o:   $(PCH) $(SRC)\objnam.c   $(HACK_H)
$(O)options.o:         $(SRC)\options.c  $(HACK_H) $(TERMCAP_H)
	@$(cc) $(CFLAGSG) $(NTSUB) -Fo$@ $(SRC)\options.c
$(O)pager.o:           $(SRC)\pager.c    $(HACK_H)
	@$(cc) $(CFLAGSG) -Od $(NTSUB) -Fo$@ $(SRC)\pager.c
$(O)pickup.o:   $(PCH) $(SRC)\pickup.c   $(HACK_H)
$(O)pline.o:           $(SRC)\pline.c    $(HACK_H) $(EPRI_H)
	@$(cc) $(CFLAGSG) $(NTSUB) -Fo$@ $(SRC)\pline.c
$(O)polyself.o: $(PCH) $(SRC)\polyself.c $(HACK_H)
$(O)potion.o:   $(PCH) $(SRC)\potion.c   $(HACK_H)
$(O)pray.o:     $(PCH) $(SRC)\pray.c     $(HACK_H) $(EPRI_H)
$(O)priest.o:   $(PCH) $(SRC)\priest.c   $(HACK_H) $(MFNDPOS_H) \
		$(ESHK_H) $(EPRI_H) $(EMIN_H)
$(O)quest.o:    $(PCH) $(SRC)\quest.c    $(HACK_H) $(QUEST_H) $(QTEXT_H)
$(O)questpgr.o: $(PCH) $(SRC)\questpgr.c $(HACK_H) $(QTEXT_H)
$(O)read.o:     $(PCH) $(SRC)\read.c     $(HACK_H)
$(O)rect.o:     $(PCH) $(SRC)\rect.c     $(HACK_H)
$(O)restore.o:  $(PCH) $(SRC)\restore.c  $(HACK_H) $(LEV_H) $(TERMCAP_H) $(QUEST_H)
$(O)rip.o:      $(PCH) $(SRC)\rip.c      $(HACK_H)
$(O)rnd.o:      $(PCH) $(SRC)\rnd.c      $(HACK_H)
$(O)rumors.o:   $(PCH) $(SRC)\rumors.c   $(HACK_H)
$(O)save.o:     $(PCH) $(SRC)\save.c     $(HACK_H) $(LEV_H) $(QUEST_H)
$(O)shk.o:      $(PCH) $(SRC)\shk.c      $(HACK_H) $(ESHK_H)
$(O)shknam.o:   $(PCH) $(SRC)\shknam.c   $(HACK_H) $(ESHK_H)
$(O)sit.o:      $(PCH) $(SRC)\sit.c      $(HACK_H) $(ARTIFACT_H)
$(O)sounds.o:   $(PCH) $(SRC)\sounds.c   $(HACK_H) $(EDOG_H)
$(O)sp_lev.o:   $(PCH) $(SRC)\sp_lev.c   $(HACK_H) $(SP_LEV_H)
$(O)spell.o:    $(PCH) $(SRC)\spell.c    $(HACK_H)
$(O)steal.o:    $(PCH) $(SRC)\steal.c    $(HACK_H)
$(O)teleport.o: $(PCH) $(SRC)\teleport.c $(HACK_H)
$(O)tile.o:     $(PCH) $(SRC)\tile.c     $(HACK_H)
$(O)timeout.o:  $(PCH) $(SRC)\timeout.c  $(HACK_H)
$(O)topten.o:   $(PCH) $(SRC)\topten.c   $(HACK_H) $(PATCHLEVEL_H)
$(O)track.o:    $(PCH) $(SRC)\track.c    $(HACK_H)
$(O)trap.o:     $(PCH) $(SRC)\trap.c     $(HACK_H)
$(O)u_init.o:   $(PCH) $(SRC)\u_init.c   $(HACK_H)
$(O)uhitm.o:    $(PCH) $(SRC)\uhitm.c    $(HACK_H)
$(O)vault.o:    $(PCH) $(SRC)\vault.c    $(HACK_H) $(VAULT_H)
$(O)version.o:         $(SRC)\version.c  $(HACK_H) $(DATE_H)  $(PATCHLEVEL_H)
	@$(cc) $(CFLAGSG) $(NTSUB) -Fo$@ $(SRC)\version.c
$(O)vis_tab.o:         $(SRC)\vis_tab.c  $(HACK_H) $(VIS_TAB_H)
	@$(cc) $(CFLAGSG) $(NTSUB) -Fo$@ $(SRC)\vis_tab.c
$(O)vision.o:   $(PCH) $(SRC)\vision.c   $(HACK_H) $(VIS_TAB_H)
$(O)weapon.o:   $(PCH) $(SRC)\weapon.c   $(HACK_H)
$(O)were.o:     $(PCH) $(SRC)\were.c     $(HACK_H)
$(O)wield.o:    $(PCH) $(SRC)\wield.c    $(HACK_H)
$(O)windows.o:  $(PCH) $(SRC)\windows.c  $(HACK_H) $(WINTTY_H)
$(O)wizard.o:   $(PCH) $(SRC)\wizard.c   $(HACK_H) $(QTEXT_H)
$(O)worm.o:     $(PCH) $(SRC)\worm.c     $(HACK_H) $(LEV_H)
$(O)worn.o:     $(PCH) $(SRC)\worn.c     $(HACK_H)
$(O)write.o:    $(PCH) $(SRC)\write.c    $(HACK_H)
$(O)zap.o:      $(PCH) $(SRC)\zap.c      $(HACK_H)

#
# from japanese
#

$(O)jlib.o:    $(PCH) $(JP)\jlib.c $(HACK_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@ $(JP)\jlib.c

$(O)jconj.o:   $(PCH) $(JP)\jconj.c $(HACK_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@ $(JP)\jconj.c

$(O)jtrns.o:   $(PCH) $(JP)\jtrns.c $(HACK_H) $(INCL)\jdata.h
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@ $(JP)\jtrns.c

#
# from extension
#

$(O)nhinet.o:  $(PCH) $(EXT)\nhinet.c $(HACK_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@ $(EXT)\nhinet.c

$(O)nhbuf.o:  $(PCH) $(EXT)\nhbuf.c $(HACK_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@ $(EXT)\nhbuf.c

$(O)extension.o:  $(PCH) $(EXT)\extension.c $(HACK_H)
	@$(cc) $(CFLAGSG) $(PCHUSE) $(NTSUB) -Fo$@ $(EXT)\extension.c

# end of file
