/*	SCCS Id: @(#)fountain.c	3.4	2003/03/23	*/
/*	Copyright Scott R. Turner, srt@ucla, 10/27/86 */
/* NetHack may be freely redistributed.  See license for details. */

/* Code for drinking from fountains. */

/*
**	Japanese version Copyright
**	(c) Issei Numata, Naoki Hamada, Shigehiro Miyashita, 1994-2000
**	For 3.4, Copyright (c) Kentaro Shirakata, 2002-2003
**	JNetHack may be freely redistributed.  See license for details. 
*/

#include "hack.h"

STATIC_DCL void NDECL(dowatersnakes);
STATIC_DCL void NDECL(dowaterdemon);
STATIC_DCL void NDECL(dowaternymph);
STATIC_PTR void FDECL(gush, (int,int,genericptr_t));
STATIC_DCL void NDECL(dofindgem);

void
floating_above(what)
const char *what;
{
/*JP
    You("are floating high above the %s.", what);
*/
    You("%s̗yɕĂD", what);
}

STATIC_OVL void
dowatersnakes() /* Fountain of snakes! */
{
    register int num = rn1(5,2);
    struct monst *mtmp;

    if (!(mvitals[PM_WATER_MOCCASIN].mvflags & G_GONE)) {
	if (!Blind)
#if 0 /*JP*/
	    pline("An endless stream of %s pours forth!",
		  Hallucination ? makeplural(rndmonnam()) : "snakes");
#else
	    pline("%sǂǂƗꂽI",
		  Hallucination ? makeplural(rndmonnam()) : "");
#endif
	else
/*JP
	    You_hear("%s hissing!", something);
*/
	    You_hear("V[bƂ𕷂I");
	while(num-- > 0)
	    if((mtmp = makemon(&mons[PM_WATER_MOCCASIN],
			u.ux, u.uy, NO_MM_FLAGS)) && t_at(mtmp->mx, mtmp->my))
		(void) mintrap(mtmp);
    } else
/*JP
	pline_The("fountain bubbles furiously for a moment, then calms.");
*/
	pline("͓ˑRAC₪ĐÂɂȂD");
}

STATIC_OVL
void
dowaterdemon() /* Water demon */
{
    register struct monst *mtmp;

    if(!(mvitals[PM_WATER_DEMON].mvflags & G_GONE)) {
	if((mtmp = makemon(&mons[PM_WATER_DEMON],u.ux,u.uy, NO_MM_FLAGS))) {
	    if (!Blind)
/*JP
		You("unleash %s!", a_monnam(mtmp));
*/
		You("%sI", a_monnam(mtmp));
	    else
/*JP
		You_feel("the presence of evil.");
*/
		You_feel("׈ȑ݂I");

	/* Give those on low levels a (slightly) better chance of survival */
	    if (rnd(100) > (80 + level_difficulty())) {
#if 0 /*JP*/
		pline("Grateful for %s release, %s grants you a wish!",
		      mhis(mtmp), mhe(mtmp));
#else
		pline("%s͉ƂĂӂĈ݂ȂĂ悤I",
		      mhis(mtmp));
#endif
		makewish();
		mongone(mtmp);
	    } else if (t_at(mtmp->mx, mtmp->my))
		(void) mintrap(mtmp);
	}
    } else
/*JP
	pline_The("fountain bubbles furiously for a moment, then calms.");
*/
	pline("͓ˑRAC₪ĐÂɂȂD");
}

STATIC_OVL void
dowaternymph() /* Water Nymph */
{
	register struct monst *mtmp;

	if(!(mvitals[PM_WATER_NYMPH].mvflags & G_GONE) &&
	   (mtmp = makemon(&mons[PM_WATER_NYMPH],u.ux,u.uy, NO_MM_FLAGS))) {
		if (!Blind)
/*JP
		   You("attract %s!", a_monnam(mtmp));
*/
		   pline("%sꂽI", a_monnam(mtmp));
		else
/*JP
		   You_hear("a seductive voice.");
*/
		   You_hear("fIȐ𕷂D");
		mtmp->msleeping = 0;
		if (t_at(mtmp->mx, mtmp->my))
		    (void) mintrap(mtmp);
	} else
		if (!Blind)
/*JP
		   pline("A large bubble rises to the surface and pops.");
*/
		   pline("傫ȖAoĂ͂D");
		else
/*JP
		   You_hear("a loud pop.");
*/
		   You_hear("傫Ȃ̂͂鉹𕷂D");
}

void
dogushforth(drinking) /* Gushing forth along LOS from (u.ux, u.uy) */
int drinking;
{
	int madepool = 0;

	do_clear_area(u.ux, u.uy, 7, gush, (genericptr_t)&madepool);
	if (!madepool) {
	    if (drinking)
/*JP
		Your("thirst is quenched.");
*/
		Your("͖ꂽD");
	    else
/*JP
		pline("Water sprays all over you.");
*/
		pline("ԂȂɂD");
	}
}

STATIC_PTR void
gush(x, y, poolcnt)
int x, y;
genericptr_t poolcnt;
{
	register struct monst *mtmp;
	register struct trap *ttmp;

	if (((x+y)%2) || (x == u.ux && y == u.uy) ||
	    (rn2(1 + distmin(u.ux, u.uy, x, y)))  ||
	    (levl[x][y].typ != ROOM) ||
	    (sobj_at(BOULDER, x, y)) || nexttodoor(x, y))
		return;

	if ((ttmp = t_at(x, y)) != 0 && !delfloortrap(ttmp))
		return;

	if (!((*(int *)poolcnt)++))
/*JP
	    pline("Water gushes forth from the overflowing fountain!");
*/
	    pline("򂩂琅ǂǂƈoI");

	/* Put a pool at x, y */
	levl[x][y].typ = POOL;
	/* No kelp! */
	del_engr_at(x, y);
	water_damage(level.objects[x][y], FALSE, TRUE);

	if ((mtmp = m_at(x, y)) != 0)
		(void) minliquid(mtmp);
	else
		newsym(x,y);
}

STATIC_OVL void
dofindgem() /* Find a gem in the sparkling waters. */
{
/*JP
	if (!Blind) You("spot a gem in the sparkling waters!");
*/
	if (!Blind) pline("߂̒ɕ΂I");
/*JP
	else You_feel("a gem here!");
*/
	else You_feel("΂悤I");
	(void) mksobj_at(rnd_class(DILITHIUM_CRYSTAL, LUCKSTONE-1),
			 u.ux, u.uy, FALSE, FALSE);
	SET_FOUNTAIN_LOOTED(u.ux,u.uy);
	newsym(u.ux, u.uy);
	exercise(A_WIS, TRUE);			/* a discovery! */
}

void
dryup(x, y, isyou)
xchar x, y;
boolean isyou;
{
	if (IS_FOUNTAIN(levl[x][y].typ) &&
	    (!rn2(3) || FOUNTAIN_IS_WARNED(x,y))) {
		if(isyou && in_town(x, y) && !FOUNTAIN_IS_WARNED(x,y)) {
			struct monst *mtmp;
			SET_FOUNTAIN_WARNED(x,y);
			/* Warn about future fountain use. */
			for(mtmp = fmon; mtmp; mtmp = mtmp->nmon) {
			    if (DEADMONSTER(mtmp)) continue;
			    if ((mtmp->data == &mons[PM_WATCHMAN] ||
				mtmp->data == &mons[PM_WATCH_CAPTAIN]) &&
			       couldsee(mtmp->mx, mtmp->my) &&
			       mtmp->mpeaceful) {
/*JP
				pline("%s yells:", Amonnam(mtmp));
*/
				pline("%s͋񂾁F", Amonnam(mtmp));
/*JP
				verbalize("Hey, stop using that fountain!");
*/
				verbalize("CȁI");
				break;
			    }
			}
			/* You can see or hear this effect */
/*JP
			if(!mtmp) pline_The("flow reduces to a trickle.");
*/
			if(!mtmp) pline("͂낿ɂȂD");
			return;
		}
#ifdef WIZARD
		if (isyou && wizard) {
/*JP
			if (yn("Dry up fountain?") == 'n')
*/
			if (yn("݂ق܂H") == 'n')
				return;
		}
#endif
		/* replace the fountain with ordinary floor */
		levl[x][y].typ = ROOM;
		levl[x][y].looted = 0;
		levl[x][y].blessedftn = 0;
/*JP
		if (cansee(x,y)) pline_The("fountain dries up!");
*/
		if (cansee(x,y)) pline("͊オI");
		/* The location is seen if the hero/monster is invisible */
		/* or felt if the hero is blind.			 */
		newsym(x, y);
		level.flags.nfountains--;
		if(isyou && in_town(x, y))
		    (void) angry_guards(FALSE);
	}
}

void
drinkfountain()
{
	/* What happens when you drink from a fountain? */
	register boolean mgkftn = (levl[u.ux][u.uy].blessedftn == 1);
	register int fate = rnd(30);

	if (Levitation) {
/*JP
		floating_above("fountain");
*/
		floating_above("");
		return;
	}

#ifdef MAKE_SOUND
	make_sound(SOUND_DRINK);
#endif
	if (mgkftn && u.uluck >= 0 && fate >= 10) {
		int i, ii, littleluck = (u.uluck < 4);

/*JP
		pline("Wow!  This makes you feel great!");
*/
		pline("HIƂĂC悭ȂI");
		/* blessed restore ability */
		for (ii = 0; ii < A_MAX; ii++)
		    if (ABASE(ii) < AMAX(ii)) {
			ABASE(ii) = AMAX(ii);
			flags.botl = 1;
		    }
		/* gain ability, blessed if "natural" luck is high */
		i = rn2(A_MAX);		/* start at a random attribute */
		for (ii = 0; ii < A_MAX; ii++) {
		    if (adjattrib(i, 1, littleluck ? -1 : 0) && littleluck)
			break;
		    if (++i >= A_MAX) i = 0;
		}
		display_nhwindow(WIN_MESSAGE, FALSE);
/*JP
		pline("A wisp of vapor escapes the fountain...");
*/
		pline("̂܂肪򂩂瓦DDD");
		exercise(A_WIS, TRUE);
		levl[u.ux][u.uy].blessedftn = 0;
		return;
	}

	if (fate < 10) {
/*JP
		pline_The("cool draught refreshes you.");
*/
		pline("₽tłς肵D");
		u.uhunger += rnd(10); /* don't choke on water */
		newuhs(FALSE);
		if(mgkftn) return;
	} else {
	    switch (fate) {

		case 19: /* Self-knowledge */

/*JP
			You_feel("self-knowledgeable...");
*/
			You("g悤ȋCDDD");
			display_nhwindow(WIN_MESSAGE, FALSE);
			enlightenment(0);
			exercise(A_WIS, TRUE);
/*JP
			pline_The("feeling subsides.");
*/
			pline("̊͂ȂȂD");
			break;

		case 20: /* Foul water */

/*JP
			pline_The("water is foul!  You gag and vomit.");
*/
			pline("͂ЂǂsȖIȂ͓f߂D");
			morehungry(rn1(20, 11));
			vomit();
			break;

		case 21: /* Poisonous */

/*JP
			pline_The("water is contaminated!");
*/
			pline("͉ĂI");
			if (Poison_resistance) {
#if 0 /*JP*/
			   pline(
			      "Perhaps it is runoff from the nearby %s farm.",
				 fruitname(FALSE));
#else
			   pline(
			      "ԂC͋߂%s̔_ꂩ痬ĂD",
				 fruitname(FALSE));
#endif
/*JP
			   losehp(rnd(4),"unrefrigerated sip of juice",
*/
			   losehp(rnd(4),"ʏ`̂",
				KILLED_BY_AN);
			   break;
			}
			losestr(rn1(4,3));
/*JP
			losehp(rnd(10),"contaminated water", KILLED_BY);
*/
			losehp(rnd(10),"ꂽ", KILLED_BY);
			exercise(A_CON, FALSE);
			break;

		case 22: /* Fountain of snakes! */

			dowatersnakes();
			break;

		case 23: /* Water demon */
			dowaterdemon();
			break;

		case 24: /* Curse an item */ {
			register struct obj *obj;

/*JP
			pline("This water's no good!");
*/
			pline("̐͂ƂĂ܂I");
			morehungry(rn1(20, 11));
			exercise(A_CON, FALSE);
			for(obj = invent; obj ; obj = obj->nobj)
				if (!rn2(5))	curse(obj);
			break;
			}

		case 25: /* See invisible */

			if (Blind) {
			    if (Invisible) {
/*JP
			    You("feel transparent.");
*/
			    You("ɂȂCD");
			    } else {
/*JP
			    	You("feel very self-conscious.");
*/
			    	You("ӎߏɊD");
/*JP
			    	pline("Then it passes.");
*/
			    	pline("̊͏D");
			    }
			} else {
/*JP
			   You("see an image of someone stalking you.");
*/
			   You("̌ĂfD");
/*JP
			   pline("But it disappears.");
*/
			   pline("C͏Ă܂D");
			}
			HSee_invisible |= FROMOUTSIDE;
			newsym(u.ux,u.uy);
			exercise(A_WIS, TRUE);
			break;

		case 26: /* See Monsters */

			(void) monster_detect((struct obj *)0, 0);
			exercise(A_WIS, TRUE);
			break;

		case 27: /* Find a gem in the sparkling waters. */

			if (!FOUNTAIN_IS_LOOTED(u.ux,u.uy)) {
				dofindgem();
				break;
			}

		case 28: /* Water Nymph */

			dowaternymph();
			break;

		case 29: /* Scare */ {
			register struct monst *mtmp;

/*JP
			pline("This water gives you bad breath!");
*/
			pline("񂾂瑧LȂI");
			for(mtmp = fmon; mtmp; mtmp = mtmp->nmon)
			    if(!DEADMONSTER(mtmp))
				monflee(mtmp, 0, FALSE, FALSE);
			}
			break;

		case 30: /* Gushing forth in this room */

			dogushforth(TRUE);
			break;

		default:

/*JP
			pline("This tepid water is tasteless.");
*/
			pline("̂Ȃ܂ʂ邢͖ȂD");
			break;
	    }
	}
	dryup(u.ux, u.uy, TRUE);
}

void
dipfountain(obj)
register struct obj *obj;
{
	if (Levitation) {
/*JP
		floating_above("fountain");
*/
		floating_above("");
		return;
	}

	/* Don't grant Excalibur when there's more than one object.  */
	/* (quantity could be > 1 if merged daggers got polymorphed) */
	if (obj->otyp == LONG_SWORD && obj->quan == 1L
	    && u.ulevel >= 5 && !rn2(6)
	    && !obj->oartifact
	    && !exist_artifact(LONG_SWORD, artiname(ART_EXCALIBUR))) {

		if (u.ualign.type != A_LAWFUL) {
			/* Ha!  Trying to cheat her. */
/*JP
			pline("A freezing mist rises from the water and envelopes the sword.");
*/
			pline("X̖痧C񂾁D");
/*JP
			pline_The("fountain disappears!");
*/
			pline("͏Ă܂I");
			curse(obj);
			if (obj->spe > -6 && !rn2(3)) obj->spe--;
			obj->oerodeproof = FALSE;
			exercise(A_WIS, FALSE);
		} else {
			/* The lady of the lake acts! - Eric Backus */
			/* Be *REAL* nice */
/*JP
	  pline("From the murky depths, a hand reaches up to bless the sword.");
*/
	  pline("ɂ[݂CjƎ肪LтĂD");
/*JP
			pline("As the hand retreats, the fountain disappears!");
*/
			pline("肪ނƁC͏Ă܂I");
			obj = oname(obj, artiname(ART_EXCALIBUR));
			discover_artifact(ART_EXCALIBUR);
			bless(obj);
			obj->oeroded = obj->oeroded2 = 0;
			obj->oerodeproof = TRUE;
			exercise(A_WIS, TRUE);
		}
		update_inventory();
		levl[u.ux][u.uy].typ = ROOM;
		levl[u.ux][u.uy].looted = 0;
		newsym(u.ux, u.uy);
		level.flags.nfountains--;
		if(in_town(u.ux, u.uy))
		    (void) angry_guards(FALSE);
		return;
	} else if (get_wet(obj) && !rn2(2))
		return;

	/* Acid and water don't mix */
	if (obj->otyp == POT_ACID) {
	    useup(obj);
	    return;
	}

	switch (rnd(30)) {
		case 16: /* Curse the item */
			curse(obj);
			break;
		case 17:
		case 18:
		case 19:
		case 20: /* Uncurse the item */
			if(obj->cursed) {
			    if (!Blind)
/*JP
				pline_The("water glows for a moment.");
*/
				pline("͋PD");
			    uncurse(obj);
			} else {
/*JP
			    pline("A feeling of loss comes over you.");
*/
			    pline("ȒE͊ȂD");
			}
			break;
		case 21: /* Water Demon */
			dowaterdemon();
			break;
		case 22: /* Water Nymph */
			dowaternymph();
			break;
		case 23: /* an Endless Stream of Snakes */
			dowatersnakes();
			break;
		case 24: /* Find a gem */
			if (!FOUNTAIN_IS_LOOTED(u.ux,u.uy)) {
				dofindgem();
				break;
			}
		case 25: /* Water gushes forth */
			dogushforth(FALSE);
			break;
		case 26: /* Strange feeling */
/*JP
			pline("A strange tingling runs up your %s.",
*/
			pline("ȂтꂪȂ%sɑD",
							body_part(ARM));
			break;
		case 27: /* Strange feeling */
/*JP
			You_feel("a sudden chill.");
*/
			You("ˑRD");
			break;
		case 28: /* Strange feeling */
/*JP
			pline("An urge to take a bath overwhelms you.");
*/
			pline("Cɓ肽Ƃ~]ɂꂽD");
#ifndef GOLDOBJ
			if (u.ugold > 10) {
			    u.ugold -= somegold() / 10;
/*JP
			    You("lost some of your gold in the fountain!");
*/
			    You("݂𐔖CɗƂĂ܂I");
			    CLEAR_FOUNTAIN_LOOTED(u.ux,u.uy);
			    exercise(A_WIS, FALSE);
			}
#else
			{
			    long money = money_cnt(invent);
			    struct obj *otmp;
                            if (money > 10) {
				/* Amount to loose.  Might get rounded up as fountains don't pay change... */
			        money = somegold(money) / 10; 
			        for (otmp = invent; otmp && money > 0; otmp = otmp->nobj) if (otmp->oclass == COIN_CLASS) {
				    int denomination = objects[otmp->otyp].oc_cost;
				    long coin_loss = (money + denomination - 1) / denomination;
                                    coin_loss = min(coin_loss, otmp->quan);
				    otmp->quan -= coin_loss;
				    money -= coin_loss * denomination;				  
				    if (!otmp->quan) delobj(otmp);
				}
/*JP
			        You("lost some of your money in the fountain!");
*/
			        You("݂𐔖CɗƂĂ܂I");
				CLEAR_FOUNTAIN_LOOTED(u.ux,u.uy);
			        exercise(A_WIS, FALSE);
                            }
			}
#endif
			break;
		case 29: /* You see coins */

		/* We make fountains have more coins the closer you are to the
		 * surface.  After all, there will have been more people going
		 * by.	Just like a shopping mall!  Chris Woodbury  */

		    if (FOUNTAIN_IS_LOOTED(u.ux,u.uy)) break;
		    SET_FOUNTAIN_LOOTED(u.ux,u.uy);
		    (void) mkgold((long)
			(rnd((dunlevs_in_dungeon(&u.uz)-dunlev(&u.uz)+1)*2)+5),
			u.ux, u.uy);
		    if (!Blind)
/*JP
		pline("Far below you, you see coins glistening in the water.");
*/
		You("y̐ɋ݂̋P݂D");
		    exercise(A_WIS, TRUE);
		    newsym(u.ux,u.uy);
		    break;
	}
	update_inventory();
	dryup(u.ux, u.uy, TRUE);
}

#ifdef SINKS
void
breaksink(x,y)
int x, y;
{
    if(cansee(x,y) || (x == u.ux && y == u.uy))
/*JP
	pline_The("pipes break!  Water spurts out!");
*/
	pline("zǂꐅoI");
    level.flags.nsinks--;
    levl[x][y].doormask = 0;
    levl[x][y].typ = FOUNTAIN;
    level.flags.nfountains++;
    newsym(x,y);
}

void
drinksink()
{
	struct obj *otmp;
	struct monst *mtmp;

	if (Levitation) {
/*JP
		floating_above("sink");
*/
		floating_above("");
		return;
	}
#ifdef MAKE_SOUND
	make_sound(SOUND_DRINK);
#endif
	switch(rn2(20)) {
/*JP
		case 0: You("take a sip of very cold water.");
*/
		case 0: You("ƂĂ₽񂾁D");
			break;
/*JP
		case 1: You("take a sip of very warm water.");
*/
		case 1: You("ƂĂʂ邢񂾁D");
			break;
/*JP
		case 2: You("take a sip of scalding hot water.");
*/
		case 2: You("ƂĂM񂾁D");
			if (Fire_resistance)
/*JP
				pline("It seems quite tasty.");
*/
				pline("ƂĂD");
/*JP
			else losehp(rnd(6), "sipping boiling water", KILLED_BY);
*/
			else losehp(rnd(6), "", KILLED_BY);
			break;
		case 3: if (mvitals[PM_SEWER_RAT].mvflags & G_GONE)
/*JP
				pline_The("sink seems quite dirty.");
*/
				pline("͂ƂĂȂ炵D");
			else {
				mtmp = makemon(&mons[PM_SEWER_RAT],
						u.ux, u.uy, NO_MM_FLAGS);
#if 0 /*JP*/
				if (mtmp) pline("Eek!  There's %s in the sink!",
					(Blind || !canspotmon(mtmp)) ?
					"something squirmy" :
					a_monnam(mtmp));
#else
				if (mtmp) pline("I%sI",
					(Blind || !canspotmon(mtmp)) ?
					"g悤Ȃ" :
					a_monnam(mtmp));
#endif
			}
			break;
		case 4: do {
				otmp = mkobj(POTION_CLASS,FALSE);
				if (otmp->otyp == POT_WATER) {
					obfree(otmp, (struct obj *)0);
					otmp = (struct obj *) 0;
				}
			} while(!otmp);
			otmp->cursed = otmp->blessed = 0;
#if 0 /*JP*/
			pline("Some %s liquid flows from the faucet.",
			      Blind ? "odd" :
			      hcolor(OBJ_DESCR(objects[otmp->otyp])));
#else
			pline("֌%st̂ꂽD",
			      Blind ? "" :
			      hcolor(jtrns_obj('!',OBJ_DESCR(objects[otmp->otyp]))));
#endif
			otmp->dknown = !(Blind || Hallucination);
			otmp->quan++; /* Avoid panic upon useup() */
			otmp->fromsink = 1; /* kludge for docall() */
			(void) dopotion(otmp);
			obfree(otmp, (struct obj *)0);
			break;
		case 5: if (!(levl[u.ux][u.uy].looted & S_LRING)) {
/*JP
			    You("find a ring in the sink!");
*/
			    You("Ɏwւ݂I");
			    (void) mkobj_at(RING_CLASS, u.ux, u.uy, TRUE);
			    levl[u.ux][u.uy].looted |= S_LRING;
			    exercise(A_WIS, TRUE);
			    newsym(u.ux,u.uy);
/*JP
			} else pline("Some dirty water backs up in the drain.");
*/
			} else pline("ȂrɗꂽD");
			break;
		case 6: breaksink(u.ux,u.uy);
			break;
/*JP
		case 7: pline_The("water moves as though of its own will!");
*/
		case 7: pline("ӎvĂ邩̂悤ɓI");
			if ((mvitals[PM_WATER_ELEMENTAL].mvflags & G_GONE)
			    || !makemon(&mons[PM_WATER_ELEMENTAL],
					u.ux, u.uy, NO_MM_FLAGS))
/*JP
				pline("But it quiets down.");
*/
				pline("CÂɂȂD");
			break;
/*JP
		case 8: pline("Yuk, this water tastes awful.");
*/
		case 8: pline("IFCƂĂЂǂD");
			more_experienced(1,0);
			newexplevel();
			break;
/*JP
		case 9: pline("Gaggg... this tastes like sewage!  You vomit.");
*/
		case 9: pline("QF[D̂悤ȖIȂ͓f߂D");
			morehungry(rn1(30-ACURR(A_CON), 11));
			vomit();
			break;
/*JP
		case 10: pline("This water contains toxic wastes!");
*/
		case 10: pline("̐͗LłȔr܂łI");
			if (!Unchanging) {
/*JP
				You("undergo a freakish metamorphosis!");
*/
				You("`ȕῶ߂I");
				polyself(FALSE);
			}
			break;
		/* more odd messages --JJB */
/*JP
		case 11: You_hear("clanking from the pipes...");
*/
		case 11: You_hear("zǂ̃J`Ƃ𕷂DDD");
			break;
/*JP
		case 12: You_hear("snatches of song from among the sewers...");
*/
		case 12: You_hear("̒ƂƂ̉̂𕷂DDD");
			break;
		case 19: if (Hallucination) {
/*JP
		   pline("From the murky drain, a hand reaches up... --oops--");
*/
		   pline("Âr肪LтĂDD----");
				break;
			}
#if 0 /*JP*/
		default: You("take a sip of %s water.",
			rn2(3) ? (rn2(2) ? "cold" : "warm") : "hot");
#else
		default: You("%s񂾁D",
			rn2(3) ? (rn2(2) ? "₢" : "ʂ邢") : "M");
#endif
	}
}
#endif /* SINKS */

/*fountain.c*/
