/*
 * w_dibtile.h : Windows Device Independent Bitmap tile related header
 *
 * Copyright (c) Yukihiko Aoki 1998, 2005
 * NetHack may be freely redistributed.  See license for details.
 *
 */

#ifndef W_DIBTILE_H
#define W_DIBTILE_H

/*
 * some definition
 */
#define COLOR_BITCOUNT          8       /* this version support only 8bit bitmaps */
#define COLOR_PALSIZE           256     /* pallet size */
#define COLOR_TRANSPARENT       255     /* transparent color entry of palette */
#define MAX_TILEWIDTH           256     /* tile width must smaller than this value */
#define MAX_TILEHEIGHT          256     /* tile height must smaller than this value */

 /*
 * Offscreen_blt mode
 */
#define BLTMODE_COPY            0x01000000
#define BLTMODE_MASK            0x02000000
#define BLTMODE_MESH            0x04000000
#define BLTMODE_FLASH           0x08000000

/*#define COMPRESS_TILE*/                   /* RLE? */
#ifdef COMPRESS_TILE
typedef WORD TBIT;
#else
typedef BYTE TBIT;
#endif

/*
 * single tile data
 */
typedef struct TILEDATA {
    TBIT **data;                        /* byte array for tile */
    char   cx;                          /* width */
    char   cy;                          /* height */
    WORD   size;                        /* normal=0, big=1 */
}TILEDATA;

/*
 * tile list data
 */
typedef struct TILELIST {
    BYTE      width;                    /* width of single tile */
    BYTE      height;                   /* height of single tile */
    INT       numtiles;                 /* number of tiles containing */
    TILEDATA *tiles;                    /* tile array */
    HPALETTE  hpal;                     /* palette for this tile */
    INT       xcount;                   /* number of tiles in vertical align */
    RECT      defrc;                    /* default valid rectangle size */
}TILELIST;

/*
 * offscreen buffer structure
 */
typedef struct OFFSCREEN {
    BYTE              bkidx;            /* background color index(black) */
    HBITMAP           hbmp;             /* bitmap handle */
    BYTE             *bits;             /* offscreen bits */
    BITMAPINFOHEADER *info;             /* header information */
}OFFSCREEN;

/*
 * function declaretion
 */
TILELIST*  FDECL(Tile_load, (HINSTANCE,char *,BYTE,BYTE,RECT*,void (*procCallback)(int,int)));
void       FDECL(Tile_free, (TILELIST *));
OFFSCREEN* FDECL(Offscreen_create, (int,int,HPALETTE));
void       FDECL(Offscreen_free, (OFFSCREEN *));
void       FDECL(Offscreen_clear, (OFFSCREEN *));
void       FDECL(Offscreen_blackness, (OFFSCREEN *,int,int,int,int));
void       FDECL(Offscreen_blt, (OFFSCREEN *,int,int,int,int,TILEDATA *,int,int,DWORD));
void       FDECL(Offscreen_copy, (OFFSCREEN *,int,int,int,int,OFFSCREEN *,int,int));
HPALETTE   FDECL(CreateBitmapPalette, (HBITMAP));

#endif /* W_DIBTILE_H */
