/*
 * w_font.c : Font operation
 *
 * Copyright (c) Yukihiko Aoki 1999, 2005
 * NetHack may be freely redistributed.  See license for details.
 *
 */

#include "hack.h"

#ifdef NH2K_EXTENDS

#include "win32api.h"
#include "w_main.h"

/***************************************************************************************
 * Display font dialog
 ***************************************************************************************/
void Font_select(HWND hwnd, FONTINFO *info, BOOL fixed_flg, BOOL color_flg, BOOL size_flg)
{
    HFONT       newfont = NULL;
    CHOOSEFONT  cf;
    LOGFONT     lf;
    DWORD       additional;

    additional = fixed_flg ? CF_FIXEDPITCHONLY : 0;
    additional |= color_flg ? CF_EFFECTS : 0;
    additional |= size_flg ? 0 : CF_NOSIZESEL;
    GetObject(info->font_handle, sizeof(LOGFONT), &lf);
    ZeroMemory(&cf, sizeof(CHOOSEFONT));
    cf.lStructSize = sizeof(CHOOSEFONT);
    cf.hwndOwner   = hwnd;
    cf.lpLogFont   = &lf;
    cf.rgbColors   = info->font_color;
    cf.hInstance   = g_hInstance;
    cf.lpTemplateName = "HACK_FONT";
    cf.Flags       = CF_INITTOLOGFONTSTRUCT|CF_SCREENFONTS|CF_NOVERTFONTS|CF_FORCEFONTEXIST
                     |CF_NOSCRIPTSEL|CF_ENABLETEMPLATE|additional;

    if (ChooseFont(&cf)) {
        DeleteObject(info->font_handle);
        info->font_height = lf.lfHeight;
        info->font_width  = lf.lfWidth;
        info->font_weight = lf.lfWeight;
        info->font_color  = cf.rgbColors;
        info->font_italic = lf.lfItalic;
        strcpy(info->font_name, lf.lfFaceName);
        info->font_handle = CreateFontIndirect(&lf);
    }
}

/***************************************************************************************
 * Set default font
 ***************************************************************************************/
void Font_default(FONTINFO *info)
{
    HFONT   hfont;
    LOGFONT lf;

    hfont = GetStockObject(OEM_FIXED_FONT);
    if (!hfont) {
        hfont = GetStockObject(SYSTEM_FIXED_FONT);
    }

    GetObject(hfont, sizeof(LOGFONT), &lf);
    info->font_height = lf.lfHeight;
    info->font_width  = lf.lfWidth;
    info->font_weight = lf.lfWeight;
    info->font_color  = colormap[CLR_WHITE];
    info->font_bgcolor = RGB(0, 0, 0);
    info->font_italic = lf.lfItalic;
    strcpy(info->font_name, lf.lfFaceName);
    info->font_handle = CreateFontIndirect(&lf);
}

/***************************************************************************************
 * Create font
 ***************************************************************************************/
void Font_create(FONTINFO *info)
{
    LOGFONT lf;

    lf.lfHeight         = info->font_height;
    lf.lfWidth          = info->font_width;
    lf.lfEscapement     = 0;
    lf.lfOrientation    = 0;
    lf.lfWeight         = info->font_weight;
    lf.lfItalic         = info->font_italic;
    lf.lfUnderline      = FALSE;
    lf.lfStrikeOut      = 0;
    lf.lfCharSet        = DEFAULT_CHARSET;
    lf.lfOutPrecision   = OUT_DEFAULT_PRECIS;
    lf.lfClipPrecision  = CLIP_DEFAULT_PRECIS;
    lf.lfQuality        = DRAFT_QUALITY;
    lf.lfPitchAndFamily = DEFAULT_PITCH|FF_DONTCARE;
    strcpy(lf.lfFaceName, info->font_name);

    if (info->font_handle) {
        DeleteObject(info->font_handle);
    }
    info->font_handle = CreateFontIndirect(&lf);
}

/***************************************************************************************
 * Save font settings
 ***************************************************************************************/
void Font_save(FONTINFO *info, char *filename, char *section)
{
    WritePrivateProfileStruct(
        section, "Font", info, sizeof(FONTINFO), filename);
}

/***************************************************************************************
 * Load font settings
 ***************************************************************************************/
void Font_load(FONTINFO *info, char *filename, char *section)
{
    BOOL result;

    result = GetPrivateProfileStruct(
        section, "Font", info, sizeof(FONTINFO), filename);
    if (result) {
        Font_create(info);
    } else {
        /* failed to load, set default values */
        Font_default(info);
    }
}

/***************************************************************************************
 * Delete font
 ***************************************************************************************/
void Font_delete(FONTINFO *info)
{
    DeleteObject(info->font_handle);
}

/***************************************************************************************
 * Font width
 ***************************************************************************************/
int Font_width(FONTINFO *info, HDC hdc)
{
    TEXTMETRIC tm; 
    HFONT oldFont;
    int width;

    if (info->font_width <= 0) {
        oldFont = SelectObject(hdc, info->font_handle);
        GetTextMetrics(hdc, &tm);
        width = tm.tmAveCharWidth;
        SelectObject(hdc, oldFont);
    } else {
        width = info->font_width;
    }

    return width;
}

/***************************************************************************************
 * Font height
 ***************************************************************************************/
int Font_height(FONTINFO *info, HDC hdc)
{
    TEXTMETRIC tm; 
    HFONT oldFont;
    int height;

    if (info->font_height <= 0) {
        oldFont = SelectObject(hdc, info->font_handle);
        GetTextMetrics(hdc, &tm);
        height = tm.tmHeight;
        SelectObject(hdc, oldFont);
    } else {
        height = info->font_height;
    }

    return height;
}

#endif /* NH2K_EXTENDS */