/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.jetty.gui;

import java.util.logging.Logger;
import netjfwatcher.jetty.control.JettyException;
import netjfwatcher.jetty.control.JettyServerCheckTimerProcessor;
import netjfwatcher.jetty.control.JettyServerThread;
import netjfwatcher.jetty.gui.AbstractEditorView;
import netjfwatcher.jetty.preference.JettyConfig;
import netjfwatcher.jetty.preference.JettyConfigFileParse;
import netjfwatcher.webbrowser.model.UrlEditorInput;
import netjfwatcher.webbrowser.view.BrowserEditors;
import netjfwatcher.webbrowser.view.BrowserEditorsManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class JettyEditorView
extends AbstractEditorView {
    public static final String JETTY_STATUS_UNREADY = "unready";
    public static final String JETTY_STATUS_READY = "ready";
    private static Color RED_COLOR = new Color(null, 255, 0, 0);
    public static final int WAR_FILE_PATH_TEXT_WIDTH = 500;
    public static final int LONG_TEXT_WIDTH = 250;
    public static final int TEXT_WIDTH1 = 120;
    private static final int[] SCROLL_COMPOSITE_SIZE = new int[]{600, 400};
    private static final int HORIZONTAL_SPAN3 = 3;
    private static Logger logger;
    private Text webAppContextWarText;
    private Text connectorPortText;
    private Text contextPathText;
    private Text userRealmNameText;
    private Text userRealmPathText;
    private Text tempDirectoryText;
    private Button fileButton;
    private Button startButton;
    private Button stopButton;
    private Button browserButton;
    private Text jettyServerStatusText;
    private Text jettyServerRunningText;
    private Text jettyServerStartingText;
    private Text jettyServerStartedText;
    private Text jettyServerFailedText;
    private Text jettyServerStoppingText;
    private Color textBackColor;
    private JettyServerCheckTimerProcessor timerProcessor;
    private SubStatusLineManager statusLineManager;
    private Display display;

    public JettyEditorView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.textBackColor = Display.getCurrent().getSystemColor(1);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout0 = new GridLayout(1, true);
        Composite composite0 = new Composite((Composite)scrollComposite, 0);
        composite0.setLayout((Layout)gridLayout0);
        composite0.setLayoutData((Object)new GridData(272));
        GridLayout gridLayout = new GridLayout(3, false);
        Composite composite1 = new Composite(composite0, 0);
        composite1.setLayout((Layout)gridLayout);
        composite1.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        Label label = new Label(composite1, 0);
        label.setText("Web app context war file");
        label.setLayoutData((Object)new GridData());
        this.webAppContextWarText = new Text(composite1, 2048);
        this.webAppContextWarText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 500;
        this.webAppContextWarText.setLayoutData((Object)gridData);
        this.fileButton = new Button(composite1, 0);
        this.fileButton.setText("File");
        label = new Label(composite1, 0);
        label.setText("Connector port");
        label.setLayoutData((Object)new GridData());
        this.connectorPortText = new Text(composite1, 2048);
        this.connectorPortText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.connectorPortText.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = 120;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("Context path name");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.contextPathText = new Text(composite1, 2048);
        this.contextPathText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 250;
        this.contextPathText.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = 120;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("User realm name");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.userRealmNameText = new Text(composite1, 2048);
        this.userRealmNameText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 250;
        this.userRealmNameText.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = 120;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("User realm path");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.userRealmPathText = new Text(composite1, 2048);
        this.userRealmPathText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 250;
        this.userRealmPathText.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = 120;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("War temp directory");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.tempDirectoryText = new Text(composite1, 2048);
        this.tempDirectoryText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 500;
        this.tempDirectoryText.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = 120;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.startButton = new Button(composite1, 0);
        this.startButton.setText("Start");
        this.stopButton = new Button(composite1, 0);
        this.stopButton.setText("Stop");
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = 120;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("Jetty server status");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.jettyServerStatusText = new Text(composite1, 2056);
        this.jettyServerStatusText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.jettyServerStatusText.setLayoutData((Object)gridData);
        this.browserButton = new Button(composite1, 0);
        this.browserButton.setText("Browser start");
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = 120;
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("Jetty server isRunning");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.jettyServerRunningText = new Text(composite1, 2056);
        this.jettyServerRunningText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.jettyServerRunningText.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = 120;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("Jetty server isStarting");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.jettyServerStartingText = new Text(composite1, 2056);
        this.jettyServerStartingText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.jettyServerStartingText.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = 120;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("Jetty server isStarted");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.jettyServerStartedText = new Text(composite1, 2056);
        this.jettyServerStartedText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.jettyServerStartedText.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = 120;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = 120;
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("Jetty server isFailed");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.jettyServerFailedText = new Text(composite1, 2056);
        this.jettyServerFailedText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.jettyServerFailedText.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = 120;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("Jetty server isStopping");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.jettyServerStoppingText = new Text(composite1, 2056);
        this.jettyServerStoppingText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.jettyServerStoppingText.setLayoutData((Object)gridData);
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = 120;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        GridLayout gridLayout2 = new GridLayout(5, false);
        Composite composite2 = new Composite(composite0, 0);
        composite2.setLayoutData((Object)new GridData(256));
        composite2.setLayout((Layout)gridLayout2);
        scrollComposite.setContent((Control)composite0);
        scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.setText();
        this.fileButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                JettyEditorView.this.fileButton.setEnabled(false);
                FileDialog openDialog = new FileDialog(JettyEditorView.this.getEditorSite().getShell(), 4096);
                String[] fileExt = new String[]{"*.war"};
                openDialog.setFilterExtensions(fileExt);
                openDialog.setFilterPath("./");
                String openFileName = openDialog.open();
                if (openFileName != null) {
                    JettyEditorView.this.webAppContextWarText.setText(openFileName);
                }
                JettyEditorView.this.fileButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.startButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                JettyEditorView.this.startButton.setEnabled(false);
                JettyEditorView.this.startTimer();
                JettyEditorView.this.startJetty();
                JettyEditorView.this.stopButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.stopButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                JettyEditorView.this.stopButton.setEnabled(false);
                JettyEditorView.this.stopJetty();
                JettyEditorView.this.stopTimer();
                JettyEditorView.this.startButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.browserButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                JettyEditorView.this.browserButton.setEnabled(false);
                JettyEditorView.this.setBrowserButton();
                JettyEditorView.this.browserButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private void setBrowserButton() {
        JettyConfigFileParse jettyConf = JettyConfig.getInstance().getResourceFileParse();
        final String accessURL = "http://localhost:" + jettyConf.getConnector_port() + "/" + jettyConf.getContextPath() + "/start.jsp";
        final IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    IEditorPart editorPart = activePage.openEditor((IEditorInput)new UrlEditorInput(accessURL, accessURL), BrowserEditors.class.getName());
                    BrowserEditorsManager.getInstance().setBrowserEditors(accessURL, editorPart);
                }
                catch (PartInitException e) {
                    logger.warning("Browser open error : " + e.getMessage());
                    e.printStackTrace();
                }
            }
        });
    }

    private void setText() {
        this.browserButton.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.jettyServerStatusText.setText(JETTY_STATUS_UNREADY);
        this.jettyServerStatusText.setForeground(RED_COLOR);
        JettyConfigFileParse jettyConf = JettyConfig.getInstance().getResourceFileParse();
        this.webAppContextWarText.setText(jettyConf.getWebAppContext_War());
        this.connectorPortText.setText(jettyConf.getConnector_port());
        this.contextPathText.setText(jettyConf.getContextPath());
        this.userRealmNameText.setText(jettyConf.getUserRealmName());
        this.userRealmPathText.setText(jettyConf.getUserRealmPath());
        this.tempDirectoryText.setText(jettyConf.getTempDirectory());
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.textBackColor != null) {
            this.textBackColor.dispose();
        }
        this.display.timerExec(-1, (Runnable)this.timerProcessor);
    }

    private void startJetty() {
        this.jettyServerStatusText.setText(JETTY_STATUS_UNREADY);
        this.jettyServerStatusText.setForeground(RED_COLOR);
        JettyConfigFileParse jetConf = JettyConfig.getInstance().getResourceFileParse();
        jetConf.setWebAppContext_War(this.webAppContextWarText.getText());
        jetConf.setConnector_port(this.connectorPortText.getText());
        jetConf.setContextPath(this.contextPathText.getText());
        jetConf.setUserRealmName(this.userRealmNameText.getText());
        jetConf.setUserRealmPath(this.userRealmPathText.getText());
        jetConf.setTempDirectory(this.tempDirectoryText.getText());
        JettyServerThread jet = JettyServerThread.getInstance();
        try {
            jet.startJettyServerThread();
        }
        catch (JettyException e) {
            logger.warning("Abort Jetty start " + e.getMessage());
            MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)"Abort Jetty start", (String)e.getMessage());
        }
    }

    private void stopJetty() {
        this.jettyServerStatusText.setText(JETTY_STATUS_UNREADY);
        this.jettyServerStatusText.setForeground(RED_COLOR);
        JettyServerThread jet = JettyServerThread.getInstance();
        try {
            jet.stopJettyServerThread();
        }
        catch (JettyException e) {
            MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)"Abort Jetty stop", (String)e.getMessage());
        }
    }

    private void startTimer() {
        JettyServerCheckTimerProcessor.getInstance().setDisplay(this.display);
        this.timerProcessor = JettyServerCheckTimerProcessor.getInstance();
        this.timerProcessor.setEditorSite(this.getEditorSite());
        this.timerProcessor.setText(this.jettyServerStatusText, this.jettyServerRunningText, this.jettyServerStartingText, this.jettyServerStartedText, this.jettyServerFailedText, this.jettyServerStoppingText);
        this.timerProcessor.setButton(this.startButton, this.stopButton, this.browserButton);
        this.display.timerExec(1000, (Runnable)this.timerProcessor);
    }

    private void stopTimer() {
        this.display.timerExec(-1, (Runnable)this.timerProcessor);
    }
}

