/*
 * Created on 2006/08/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.jetty.control;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;

import javax.xml.parsers.FactoryConfigurationError;

import netjfwatcher.jetty.preference.JettyConfig;
import netjfwatcher.jetty.preference.JettyConfigFileParse;

import org.apache.log4j.BasicConfigurator;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.webapp.WebAppContext;

/**
 * Jetty𐧌䂷NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class JettyControl {
    // MO
    private static Logger logger = null;
    private org.mortbay.jetty.Server jettyServer;

    private JettyControl() {
        logger = Logger.getLogger(this.getClass().getName());
        initLog4j();
    }

    public void setJettyServerConf() throws JettyException {
        if ((jettyServer != null) && jettyServer.isRunning()) {
            throw new JettyException("Already run Jetty server.");
        }

        JettyConfigFileParse jettyConf =
            JettyConfig.getInstance().getResourceFileParse();

        jettyServer = new Server();

        org.mortbay.jetty.nio.SelectChannelConnector connector =
            new SelectChannelConnector();
        int connectorPort = Integer.parseInt(jettyConf.getConnector_port());
        connector.setPort(connectorPort);
        jettyServer.setConnectors(new Connector[] { connector });

        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setContextPath(jettyConf.getContextPath());
        webAppContext.setWar(jettyConf.getWebAppContext_War());

        File tmpDir = new File(jettyConf.getTempDirectory());

        try {
            webAppContext.setTempDirectory(tmpDir);
        } catch (IllegalArgumentException e) {
            logger.warning("IllegalArgumentException " + e.getMessage());
        } catch (Exception e) {
            logger.warning("Exception " + e.getMessage());
        }

        HashUserRealm userRealm = new HashUserRealm();
        userRealm.setName(jettyConf.getUserRealmName());

        try {
            userRealm.setConfig(jettyConf.getUserRealmPath());
        } catch (IOException e1) {
            logger.warning("IOException " + e1.getMessage());
            throw new JettyException("IOException " + e1.getMessage());
        }

        jettyServer.setUserRealms(new UserRealm[] { userRealm });

        HandlerCollection handlers = new HandlerCollection(); // org.mortbay.jetty.handler.HandlerCollection 
        handlers.setHandlers(new Handler[] { webAppContext });
        jettyServer.setHandler(handlers);
    }

    public void startJettyServer() throws JettyException {
        try {
            jettyServer.start();
            jettyServer.join();
        } catch (FileNotFoundException e) {
            logger.warning("FileNotFoundException " + e.getMessage());
            throw new JettyException("FileNotFoundException " + e.getMessage());
        } catch (Exception e) {
            logger.warning("Exception " + e.getMessage());
            throw new JettyException("Exception " + e.getMessage());
        }
    }

    public void stopJettyServer() throws JettyException {
        try {
            jettyServer.stop();
        } catch (Exception e) {
            logger.warning("Exception " + e.getMessage());
            throw new JettyException("Exception " + e.getMessage());
        }
    }

    private void initLog4j() throws FactoryConfigurationError {
        // PreferenceStore`t@CƂĂēǂݍ
        BasicConfigurator.configure();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        jettyServer.stop();
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static JettyControl getInstance() {
        return SingletonResource.RESOURCE;
    }

    public org.mortbay.jetty.Server getJettyServer() {
        return jettyServer;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final JettyControl RESOURCE = new JettyControl();
    }
}
