/*
 * Created on 2006/08/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.jetty.gui;

import java.util.logging.Logger;

import netjfwatcher.jetty.control.JettyException;
import netjfwatcher.jetty.control.JettyServerCheckTimerProcessor;
import netjfwatcher.jetty.control.JettyServerThread;
import netjfwatcher.jetty.preference.JettyConfig;
import netjfwatcher.jetty.preference.JettyConfigFileParse;
import netjfwatcher.webbrowser.model.UrlEditorInput;
import netjfwatcher.webbrowser.view.BrowserEditors;
import netjfwatcher.webbrowser.view.BrowserEditorsManager;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/**
 * Jetty\\Editor ViewNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class JettyEditorView extends AbstractEditorView {
    public static final String JETTY_STATUS_UNREADY = "unready";
    public static final String JETTY_STATUS_READY = "ready";
    private static Color RED_COLOR = new Color(null, 255, 0, 0);

    /** eLXg\ */
    public static final int WAR_FILE_PATH_TEXT_WIDTH = 500;

    /** eLXg\ */
    public static final int LONG_TEXT_WIDTH = 250;

    /** eLXg\ */
    public static final int TEXT_WIDTH1 = 120;

    /* Scroll CompositeTCY */
    private static final int[] SCROLL_COMPOSITE_SIZE = { 600, 400 };

    /* Horizontal Span 3 */
    private static final int HORIZONTAL_SPAN3 = 3;

    /* Logging */
    private static Logger logger;
    private Text webAppContextWarText;
    private Text connectorPortText;
    private Text contextPathText;
    private Text userRealmNameText;
    private Text userRealmPathText;
    private Text tempDirectoryText;
    private Button fileButton;
    private Button startButton;
    private Button stopButton;
    private Button browserButton;
    private Text jettyServerStatusText;
    private Text jettyServerRunningText;
    private Text jettyServerStartingText;
    private Text jettyServerStartedText;
    private Text jettyServerFailedText;
    private Text jettyServerStoppingText;

    /* m[heLXg\BackGroundFi[ */
    private Color textBackColor;

    /* TrapMe[uTimer */
    private JettyServerCheckTimerProcessor timerProcessor;

    /* Xe[^XC}l[W */
    private SubStatusLineManager statusLineManager;

    /* Display */
    private Display display;

    /**
     * EditorEBhEɃuEU\邽߂̃CX^X
     * 𐶐܂B
     *
     */
    public JettyEditorView() {
        logger = Logger.getLogger(this.getClass().getName());

        textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
     */
    public boolean isSaveAsAllowed() {
        return false;
    }

    /**
     * EditorEBhE𐶐܂B
     *
     * @param parent Composite
     */
    public void createPartControl(Composite parent) {
        display = parent.getDisplay();

        /*
         * ViewCAEg
         */
        ScrolledComposite scrollComposite =
            new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);

        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout(layout);

        GridData gridData = null;

        GridLayout gridLayout0 = new GridLayout(1, true);
        Composite composite0 = new Composite(scrollComposite, SWT.NONE);
        composite0.setLayout(gridLayout0);
        composite0.setLayoutData(
            new GridData(
                GridData.HORIZONTAL_ALIGN_FILL | GridData.VERTICAL_ALIGN_FILL));

        GridLayout gridLayout = new GridLayout(HORIZONTAL_SPAN3, false);
        Composite composite1 = new Composite(composite0, SWT.NULL);
        composite1.setLayout(gridLayout);
        composite1.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        gridData = new GridData();

        Label label = new Label(composite1, SWT.NONE);
        label.setText("Web app context war file");
        label.setLayoutData(new GridData());
        webAppContextWarText = new Text(composite1, SWT.BORDER);
        webAppContextWarText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = WAR_FILE_PATH_TEXT_WIDTH;
        webAppContextWarText.setLayoutData(gridData);

        /* Button */
        fileButton = new Button(composite1, SWT.NONE);
        fileButton.setText("File");

        label = new Label(composite1, SWT.NONE);
        label.setText("Connector port");
        label.setLayoutData(new GridData());
        connectorPortText = new Text(composite1, SWT.BORDER);
        connectorPortText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        connectorPortText.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = TEXT_WIDTH1;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("Context path name");
        gridData = new GridData();
        label.setLayoutData(gridData);

        contextPathText = new Text(composite1, SWT.BORDER);
        contextPathText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = LONG_TEXT_WIDTH;
        contextPathText.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = TEXT_WIDTH1;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("User realm name");
        gridData = new GridData();
        label.setLayoutData(gridData);

        userRealmNameText = new Text(composite1, SWT.BORDER);
        userRealmNameText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = LONG_TEXT_WIDTH;
        userRealmNameText.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = TEXT_WIDTH1;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("User realm path");
        gridData = new GridData();
        label.setLayoutData(gridData);

        userRealmPathText = new Text(composite1, SWT.BORDER);
        userRealmPathText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = LONG_TEXT_WIDTH;
        userRealmPathText.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = TEXT_WIDTH1;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("War temp directory");
        gridData = new GridData();
        label.setLayoutData(gridData);

        tempDirectoryText = new Text(composite1, SWT.BORDER);
        tempDirectoryText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = WAR_FILE_PATH_TEXT_WIDTH;
        tempDirectoryText.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = TEXT_WIDTH1;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        /* Button */
        startButton = new Button(composite1, SWT.NONE);
        startButton.setText("Start");

        /* Button */
        stopButton = new Button(composite1, SWT.NONE);
        stopButton.setText("Stop");

        label = new Label(composite1, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = TEXT_WIDTH1;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("Jetty server status");
        gridData = new GridData();
        label.setLayoutData(gridData);

        jettyServerStatusText =
            new Text(composite1, SWT.BORDER | SWT.READ_ONLY);
        jettyServerStatusText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        jettyServerStatusText.setLayoutData(gridData);

        /* Button */
        browserButton = new Button(composite1, SWT.NONE);
        browserButton.setText("Browser start");

        label = new Label(composite1, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = TEXT_WIDTH1;
        gridData.horizontalSpan = HORIZONTAL_SPAN3;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("Jetty server isRunning");
        gridData = new GridData();
        label.setLayoutData(gridData);

        jettyServerRunningText =
            new Text(composite1, SWT.BORDER | SWT.READ_ONLY);
        jettyServerRunningText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        jettyServerRunningText.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = TEXT_WIDTH1;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("Jetty server isStarting");
        gridData = new GridData();
        label.setLayoutData(gridData);

        jettyServerStartingText =
            new Text(composite1, SWT.BORDER | SWT.READ_ONLY);
        jettyServerStartingText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        jettyServerStartingText.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = TEXT_WIDTH1;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("Jetty server isStarted");
        gridData = new GridData();
        label.setLayoutData(gridData);

        jettyServerStartedText =
            new Text(composite1, SWT.BORDER | SWT.READ_ONLY);
        jettyServerStartedText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        jettyServerStartedText.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = TEXT_WIDTH1;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = TEXT_WIDTH1;
        gridData.horizontalSpan = HORIZONTAL_SPAN3;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("Jetty server isFailed");
        gridData = new GridData();
        label.setLayoutData(gridData);

        jettyServerFailedText =
            new Text(composite1, SWT.BORDER | SWT.READ_ONLY);
        jettyServerFailedText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        jettyServerFailedText.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = TEXT_WIDTH1;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("Jetty server isStopping");
        gridData = new GridData();
        label.setLayoutData(gridData);

        jettyServerStoppingText =
            new Text(composite1, SWT.BORDER | SWT.READ_ONLY);
        jettyServerStoppingText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH1;
        jettyServerStoppingText.setLayoutData(gridData);

        label = new Label(composite1, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.widthHint = TEXT_WIDTH1;
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        GridLayout gridLayout2 = new GridLayout(5, false);
        Composite composite2 = new Composite(composite0, SWT.NONE);
        composite2.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        composite2.setLayout(gridLayout2);

        scrollComposite.setContent(composite0);
        scrollComposite.setMinSize(
            SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);

        setText();

        fileButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    fileButton.setEnabled(false);

                    FileDialog openDialog =
                        new FileDialog(getEditorSite().getShell(), SWT.OPEN);
                    String[] fileExt = new String[1];
                    fileExt[0] = "*.war";
                    openDialog.setFilterExtensions(fileExt);
                    openDialog.setFilterPath("./");

                    String openFileName = openDialog.open();

                    if (openFileName != null) {
                        webAppContextWarText.setText(openFileName);
                    }

                    fileButton.setEnabled(true);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        startButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    startButton.setEnabled(false);

                    startTimer();
                    startJetty();
                    stopButton.setEnabled(true);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
        stopButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    stopButton.setEnabled(false);

                    stopJetty();
                    stopTimer();

                    startButton.setEnabled(true);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        browserButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    browserButton.setEnabled(false);

                    setBrowserButton();
                    browserButton.setEnabled(true);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
    }

    private void setBrowserButton() {
        JettyConfigFileParse jettyConf =
            JettyConfig.getInstance().getResourceFileParse();
        final String accessURL =
            "http://localhost:" + jettyConf.getConnector_port() + "/"
            + jettyConf.getContextPath() + "/start.jsp";
        final IWorkbenchPage activePage;
        activePage =
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        BusyIndicator.showWhile(
            PlatformUI.getWorkbench().getDisplay(),
            new Runnable() {
                public void run() {
                    try {
                        IEditorPart editorPart =
                            activePage.openEditor(
                                new UrlEditorInput(accessURL, accessURL),
                                BrowserEditors.class.getName());

                        BrowserEditorsManager.getInstance().setBrowserEditors(
                            accessURL, editorPart);
                    } catch (PartInitException e) {
                        logger.warning(
                            "Browser open error : " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            });
    }

    private void setText() {
        browserButton.setEnabled(false);
        stopButton.setEnabled(false);
        jettyServerStatusText.setText(JETTY_STATUS_UNREADY);
        jettyServerStatusText.setForeground(RED_COLOR);

        JettyConfigFileParse jettyConf =
            JettyConfig.getInstance().getResourceFileParse();
        webAppContextWarText.setText(jettyConf.getWebAppContext_War());

        connectorPortText.setText(jettyConf.getConnector_port());

        contextPathText.setText(jettyConf.getContextPath());

        userRealmNameText.setText(jettyConf.getUserRealmName());

        userRealmPathText.setText(jettyConf.getUserRealmPath());
        tempDirectoryText.setText(jettyConf.getTempDirectory());
    }

    /**
     * Xe[^XC\Zbg܂B
     */
    protected void setStatusLine() {
        /* Xe[^XC\L */
        statusLineManager =
            (SubStatusLineManager) (getEditorSite().getActionBars()
                                        .getStatusLineManager());
        statusLineManager.setVisible(true);
    }

    /**
     * Colorj܂B
     *
     * @see java.lang.Object#finalize()
     */
    protected void finalize() throws Throwable {
        super.finalize();

        if (textBackColor != null) {
            textBackColor.dispose();
        }

        display.timerExec(
            JettyServerCheckTimerProcessor.TIMER_STOP, timerProcessor);
    }

    private void startJetty() {
        jettyServerStatusText.setText(JETTY_STATUS_UNREADY);
        jettyServerStatusText.setForeground(RED_COLOR);

        JettyConfigFileParse jetConf =
            JettyConfig.getInstance().getResourceFileParse();
        jetConf.setWebAppContext_War(webAppContextWarText.getText());
        jetConf.setConnector_port(connectorPortText.getText());
        jetConf.setContextPath(contextPathText.getText());
        jetConf.setUserRealmName(userRealmNameText.getText());
        jetConf.setUserRealmPath(userRealmPathText.getText());
        jetConf.setTempDirectory(tempDirectoryText.getText());

        JettyServerThread jet = JettyServerThread.getInstance();

        try {
            jet.startJettyServerThread();
        } catch (JettyException e) {
            logger.warning("Abort Jetty start " + e.getMessage());
            MessageDialog.openError(
                getEditorSite().getShell(), "Abort Jetty start", e.getMessage());
        }
    }

    private void stopJetty() {
        jettyServerStatusText.setText(JETTY_STATUS_UNREADY);
        jettyServerStatusText.setForeground(RED_COLOR);

        JettyServerThread jet = JettyServerThread.getInstance();

        try {
            jet.stopJettyServerThread();
        } catch (JettyException e) {
            MessageDialog.openError(
                getEditorSite().getShell(), "Abort Jetty stop", e.getMessage());
        }
    }

    private void startTimer() {
        JettyServerCheckTimerProcessor.getInstance().setDisplay(display);

        timerProcessor = JettyServerCheckTimerProcessor.getInstance();
        timerProcessor.setEditorSite(getEditorSite());
        timerProcessor.setText(
            jettyServerStatusText, jettyServerRunningText,
            jettyServerStartingText, jettyServerStartedText,
            jettyServerFailedText, jettyServerStoppingText);
        timerProcessor.setButton(startButton, stopButton, browserButton);
        display.timerExec(JettyServerCheckTimerProcessor.TIMER, timerProcessor);
    }

    private void stopTimer() {
        /* TrapMf[^\^C}[~ */
        display.timerExec(
            JettyServerCheckTimerProcessor.TIMER_STOP, timerProcessor);
    }
}
