/*
 * Decompiled with CFR 0.152.
 */
package netWatcherRCPSound.alarmcheck;

import java.util.logging.Logger;
import netWatcherRCPSound.alarmcheck.AlarmSoundFilter;
import netWatcherRCPSound.jmfcontrol.JMFException;
import netWatcherRCPSound.jmfcontrol.JMFSoundControlThread;
import netWatcherRCPSound.jmfcontrol.SoundControlInfo;
import netjfwatcher.engine.alarm.AlarmCodeInformation;
import netjfwatcher.engine.alarm.AlarmMessageQueue;

public final class AlarmCheckThread
implements Runnable {
    private static final int WAIT_SLEEP_TIME = 1000;
    private static Logger logger;
    private Thread alarmCheckThread;
    private int readPoint = 0;

    private AlarmCheckThread() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public boolean checkThread() {
        return this.alarmCheckThread != null && this.alarmCheckThread.isAlive();
    }

    public boolean startAlarmCheckThread() throws JMFException {
        this.readPoint = AlarmMessageQueue.getInstance().getWritePoint();
        if (this.alarmCheckThread == null || !this.alarmCheckThread.isAlive()) {
            if (SoundControlInfo.getInstance().isMp3Sound()) {
                JMFSoundControlThread.getInstance().setPlayer();
            }
            this.alarmCheckThread = new Thread(this);
            if (this.alarmCheckThread != null) {
                this.alarmCheckThread.start();
            }
            return true;
        }
        return false;
    }

    public void stopAlarmCheckThread() {
        if (this.alarmCheckThread == null) {
            return;
        }
        this.alarmCheckThread.interrupt();
        while (this.alarmCheckThread != null && this.alarmCheckThread.isAlive()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warning(e.getMessage());
                break;
            }
        }
        this.alarmCheckThread = null;
    }

    public void run() {
        while (this.alarmCheckThread != null && !this.alarmCheckThread.isInterrupted()) {
            try {
                int writePoint = AlarmMessageQueue.getInstance().getWritePoint();
                if (this.readPoint != writePoint) {
                    AlarmCodeInformation alarmInfo = AlarmMessageQueue.getInstance().popAlarmData(this.readPoint);
                    if (alarmInfo != null) {
                        if (!AlarmSoundFilter.getInstance().checkAlarmLevelFilter(alarmInfo.getLevel()) || !AlarmSoundFilter.getInstance().checkMessageFilter(alarmInfo.getMessage())) continue;
                        if (SoundControlInfo.getInstance().isMp3Sound()) {
                            if (!JMFSoundControlThread.getInstance().checkThread()) {
                                try {
                                    JMFSoundControlThread.getInstance().startSoundControlThread();
                                }
                                catch (JMFException e) {
                                    logger.warning("JMFException : " + e.getMessage());
                                }
                            }
                        } else {
                            SoundControlInfo.getInstance().setBeepSound(true);
                        }
                    }
                    ++this.readPoint;
                    if (this.readPoint >= 10) {
                        this.readPoint = 0;
                    }
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warning(e.getMessage());
                break;
            }
        }
    }

    public static AlarmCheckThread getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ AlarmCheckThread(AlarmCheckThread alarmCheckThread) {
        this();
    }

    private static class SingletonResource {
        static final AlarmCheckThread RESOURCE = new AlarmCheckThread(null);

        private SingletonResource() {
        }
    }
}

