/*
 * Created on 2006/08/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netWatcherRCPSound.actions;

import netWatcherRCPSound.alarmcheck.AlarmCheckThread;
import netWatcherRCPSound.jmfcontrol.SoundControlInfo;
import netWatcherRCPSound.timer.AlarmConfirmDialogTimerProcessor;
import netWatcherRCPSound.timer.BeepTimerProcessor;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

/**
 * Our sample action implements workbench action delegate. The action proxy will
 * be created by the workbench and shown in the UI. When the user tries to use
 * the action, this delegate will be created and execution will be delegated to
 * it.
 * 
 * @see IWorkbenchWindowActionDelegate
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AlarmCheckStopAction implements IWorkbenchWindowActionDelegate {
	private IWorkbenchWindow window;

	/**
	 * The constructor.
	 */
	public AlarmCheckStopAction() {
	}

	/**
	 * The action has been activated. The argument of the method represents the
	 * 'real' action sitting in the workbench UI.
	 * 
	 * @see IWorkbenchWindowActionDelegate#run
	 */
	public void run(IAction action) {
		if (SoundControlInfo.getInstance().isMp3Sound()) {
			try {
				AlarmCheckThread.getInstance().stopAlarmCheckThread();
			} catch (NoClassDefFoundError e) {
				MessageDialog.openError(window.getShell(),
						AlarmCheckStartAction.JMF_DIALOG_TITLE_MESSAGE,
						AlarmCheckStartAction.JMF_ERROR_MESSAGE
								+ " NoClassDefFoundError " + e.getMessage());

				return;
			}
		} else {
			try {
				AlarmCheckThread.getInstance().stopAlarmCheckThread();
			} catch (Exception e) {
				MessageDialog.openError(window.getShell(),
						AlarmCheckStartAction.JMF_DIALOG_TITLE_MESSAGE,
						AlarmCheckStartAction.JMF_ERROR_MESSAGE
								+ " NoClassDefFoundError " + e.getMessage());

				return;
			}
		}
		AlarmConfirmDialogTimerProcessor timerProcessor;
		timerProcessor = AlarmConfirmDialogTimerProcessor.getInstance();
		timerProcessor.setTimerConf(window.getShell());
		timerProcessor.stopAlarmConfirmDialogTimerProcessor();
		timerProcessor.startAlarmConfirmDialogTimerProcessor();

		BeepTimerProcessor.getInstance().setBeepTimerProcessor(
				window.getShell().getDisplay());
		BeepTimerProcessor.getInstance().stopBeepTimerProcessor();
	}

	/**
	 * Selection in the workbench has been changed. We can change the state of
	 * the 'real' action here if we want, but this can only happen after the
	 * delegate has been created.
	 * 
	 * @see IWorkbenchWindowActionDelegate#selectionChanged
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * We can use this method to dispose of any system resources we previously
	 * allocated.
	 * 
	 * @see IWorkbenchWindowActionDelegate#dispose
	 */
	public void dispose() {
	}

	/**
	 * We will cache window object in order to be able to provide parent shell
	 * for the message dialog.
	 * 
	 * @see IWorkbenchWindowActionDelegate#init
	 */
	public void init(IWorkbenchWindow window) {
		this.window = window;
	}
}
