/*
 * Created on 2006/08/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netWatcherRCPSound.gui;

import java.util.logging.Logger;

import netWatcherRCPSound.actions.AlarmCheckStartAction;
import netWatcherRCPSound.alarmcheck.AlarmCheckThread;
import netWatcherRCPSound.alarmcheck.AlarmSoundFilter;
import netWatcherRCPSound.alarmcheck.FilePreference;
import netWatcherRCPSound.jmfcontrol.JMFException;
import netWatcherRCPSound.jmfcontrol.JMFSoundControlThread;
import netWatcherRCPSound.jmfcontrol.SoundControlInfo;
import netWatcherRCPSound.timer.AlarmConfirmDialogTimerProcessor;
import netWatcherRCPSound.timer.BeepTimerProcessor;
import netjfwatcher.engine.preferance.AlarmFilterPreferencePage;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * TEh̍\\Editor ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SoundConfigEditorView extends AbstractEditorNodeView {
	/* eLXg\ */
	private static final int LARGE_TEXT_WIDTH = 500;

	/* eLXg\ */
	private static final int TEXT_WIDTH1 = 120;

	/* Combo */
	private static final int COMBO_WIDTH = 120;

	public static final String ACTIVE = "Active";

	public static final String INACTIVE = "Inactive";

	/* Scroll CompositeTCY */
	private static final int[] SCROLL_COMPOSITE_SIZE = { 600, 400 };

	/* Horizontal Span 3 */
	private static final int HORIZONTAL_SPAN2 = 2;

	/* Horizontal Span 3 */
	private static final int HORIZONTAL_SPAN3 = 3;

	/* Horizontal Span 4 */
	private static final int HORIZONTAL_SPAN4 = 4;

	/* Logging */
	private static Logger logger;

	private Display display;

	private Text mp3SoundFileText;

	private Text alarmCheckStatusText;

	private Text mp3SoundPlayerStatusText;

	private Button fileButton;

	private Button soundTestButton;

	private Button soundStopButton;

	private Button alarmCheckStartButton;

	private Button alarmCheckStopButton;

	private Button soundBeepCheckButton;

	/* Mail Filter Alarmx */
	private Combo alarmLevelCombo;

	/* Mail bZ[WFilter `FbNBox */
	private Button messageFilterCheckButton;

	/* Mail bZ[WFilter bZ[WText */
	private Text mailCheckStringText;

	/* m[heLXg\BackGroundFi[ */
	private Color textBackColor;

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public SoundConfigEditorView() {
		logger = Logger.getLogger(this.getClass().getName());

		textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		/*
		 * ViewCAEg
		 */
		ScrolledComposite scrollComposite = new ScrolledComposite(parent,
				SWT.H_SCROLL | SWT.V_SCROLL);

		GridLayout layout = new GridLayout(1, false);
		scrollComposite.setLayout(layout);

		GridData gridData = null;

		GridLayout gridLayout0 = new GridLayout(1, true);
		Composite composite0 = new Composite(scrollComposite, SWT.NONE);
		composite0.setLayout(gridLayout0);
		composite0.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL
				| GridData.VERTICAL_ALIGN_FILL));

		GridLayout gridLayout = new GridLayout(HORIZONTAL_SPAN3, false);
		Composite composite1 = new Composite(composite0, SWT.NULL);
		composite1.setLayout(gridLayout);
		composite1.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		gridData = new GridData();

		Label label = new Label(composite1, SWT.NONE);
		label.setText("Sound MP3 file");
		label.setLayoutData(new GridData());
		mp3SoundFileText = new Text(composite1, SWT.BORDER);
		mp3SoundFileText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = LARGE_TEXT_WIDTH;
		mp3SoundFileText.setLayoutData(gridData);

		fileButton = new Button(composite1, SWT.NONE);
		fileButton.setText("File");

		soundBeepCheckButton = new Button(composite1, SWT.CHECK);
		soundBeepCheckButton.setText("Select beep for alarm sound");
		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.widthHint = TEXT_WIDTH1;
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("MP3 Player status");
		label.setLayoutData(new GridData());
		mp3SoundPlayerStatusText = new Text(composite1, SWT.BORDER);
		mp3SoundPlayerStatusText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		mp3SoundPlayerStatusText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.widthHint = TEXT_WIDTH1;
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Alarm Check status");
		label.setLayoutData(new GridData());
		alarmCheckStatusText = new Text(composite1, SWT.BORDER);
		alarmCheckStatusText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		alarmCheckStatusText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.widthHint = TEXT_WIDTH1;
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.widthHint = TEXT_WIDTH1;
		gridData.horizontalSpan = HORIZONTAL_SPAN4;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		soundTestButton = new Button(composite1, SWT.NONE);
		soundTestButton.setText("Sound test");

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.widthHint = TEXT_WIDTH1;
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		soundStopButton = new Button(composite1, SWT.NONE);
		soundStopButton.setText("Sound stop");

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.widthHint = TEXT_WIDTH1;
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		alarmCheckStartButton = new Button(composite1, SWT.NONE);
		alarmCheckStartButton.setText("Alarm check start");

		alarmCheckStopButton = new Button(composite1, SWT.NONE);
		alarmCheckStopButton.setText("Alarm check stop");

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.widthHint = TEXT_WIDTH1;
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		GridLayout gridLayout2 = new GridLayout(4, false);
		Composite composite2 = new Composite(composite0, SWT.NONE);
		composite2.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		composite2.setLayout(gridLayout2);

		label = new Label(composite2, SWT.NONE);
		label.setText("Alarm level filter");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		alarmLevelCombo = new Combo(composite2, SWT.BORDER | SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = COMBO_WIDTH;
		alarmLevelCombo.setLayoutData(gridData);
		alarmLevelCombo.add(AlarmFilterPreferencePage.ALARM_LEVEL_INFO);
		alarmLevelCombo.add(AlarmFilterPreferencePage.ALARM_LEVEL_WARNING);
		alarmLevelCombo.add(AlarmFilterPreferencePage.ALARM_LEVEL_ERROR);

		alarmLevelCombo.select(0);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		messageFilterCheckButton = new Button(composite2, SWT.CHECK);
		messageFilterCheckButton.setText("Message filter");

		mailCheckStringText = new Text(composite2, SWT.BORDER | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = LARGE_TEXT_WIDTH;
		mailCheckStringText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		scrollComposite.setContent(composite0);
		scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0],
				SCROLL_COMPOSITE_SIZE[1]);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

		setInitilaText();
		display = getEditorSite().getShell().getDisplay();
		AlarmConfirmDialogTimerProcessor timerProcessor;
		timerProcessor = AlarmConfirmDialogTimerProcessor.getInstance();
		timerProcessor.setTimerConf(getEditorSite().getShell());
		timerProcessor.setMp3SoundPlayerStatusText(alarmCheckStatusText,
				mp3SoundPlayerStatusText, alarmCheckStartButton,
				alarmCheckStopButton);
		BeepTimerProcessor.getInstance().setBeepTimerProcessor(display);

		setListener();

	}

	private void setListener() {
		fileButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				fileButton.setEnabled(false);

				FileDialog openDialog = new FileDialog(getEditorSite()
						.getShell(), SWT.OPEN);
				String[] fileExt = new String[1];
				fileExt[0] = "*.mp3";
				openDialog.setFilterExtensions(fileExt);
				openDialog.setFilterPath(FilePreference.DEFAULT_MP3_FILE_PATH);

				String openFileName = openDialog.open();

				if (openFileName != null) {
					try {
						JMFSoundControlThread.getInstance()
								.stopSoundControlThread();

						mp3SoundFileText.setText(openFileName);
						JMFSoundControlThread.getInstance().setMp3FileName(
								openFileName);

						JMFSoundControlThread.getInstance().setPlayer();
					} catch (JMFException e) {
						MessageDialog.openError(getEditorSite().getShell(),
								AlarmCheckStartAction.JMF_DIALOG_TITLE_MESSAGE,
								AlarmCheckStartAction.JMF_ERROR_MESSAGE + " "
										+ e.getMessage());
					} catch (NoClassDefFoundError e) {
						MessageDialog.openError(getEditorSite().getShell(),
								AlarmCheckStartAction.JMF_DIALOG_TITLE_MESSAGE,
								AlarmCheckStartAction.JMF_ERROR_MESSAGE + " "
										+ "NoClassDefFoundError "
										+ e.getMessage());

						return;
					}
				}

				setText();
				fileButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		soundTestButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				soundTestButton.setEnabled(false);

				if (SoundControlInfo.getInstance().isMp3Sound()) {
					try {
						JMFSoundControlThread.getInstance().setPlayer();
						JMFSoundControlThread.getInstance()
								.startSoundControlThread();
					} catch (JMFException e) {
						MessageDialog.openError(getEditorSite().getShell(),
								AlarmCheckStartAction.JMF_DIALOG_TITLE_MESSAGE,
								AlarmCheckStartAction.JMF_ERROR_MESSAGE + " "
										+ e.getMessage());
						soundTestButton.setEnabled(true);

						return;
					} catch (NoClassDefFoundError e) {
						MessageDialog.openError(getEditorSite().getShell(),
								AlarmCheckStartAction.JMF_DIALOG_TITLE_MESSAGE,
								AlarmCheckStartAction.JMF_ERROR_MESSAGE + " "
										+ "NoClassDefFoundError "
										+ e.getMessage());
						soundTestButton.setEnabled(true);

						return;
					}
				} else {

					display.beep();

				}
				setText();

				soundTestButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		soundStopButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				soundStopButton.setEnabled(false);
				if (SoundControlInfo.getInstance().isMp3Sound()) {
					try {

						JMFSoundControlThread.getInstance()
								.stopSoundControlThread();

					} catch (JMFException e) {
						MessageDialog.openError(getEditorSite().getShell(),
								AlarmCheckStartAction.JMF_DIALOG_TITLE_MESSAGE,
								AlarmCheckStartAction.JMF_ERROR_MESSAGE + " "
										+ e.getMessage());

						return;
					} catch (NoClassDefFoundError e) {
						MessageDialog.openError(getEditorSite().getShell(),
								AlarmCheckStartAction.JMF_DIALOG_TITLE_MESSAGE,
								AlarmCheckStartAction.JMF_ERROR_MESSAGE
										+ " NoClassDefFoundError "
										+ e.getMessage());

						return;
					} finally {
						soundStopButton.setEnabled(true);
					}
				} else {
					try {

						JMFSoundControlThread.getInstance()
								.stopSoundControlThread();

					} catch (Exception e) {
						MessageDialog.openError(getEditorSite().getShell(),
								AlarmCheckStartAction.JMF_DIALOG_TITLE_MESSAGE,
								AlarmCheckStartAction.JMF_ERROR_MESSAGE + " "
										+ e.getMessage());

						return;

					} finally {
						soundStopButton.setEnabled(true);
					}
				}
				setText();

			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		alarmCheckStartButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				setAlarmCheckStart();
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		alarmCheckStopButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				alarmCheckStopButton.setEnabled(false);
				if (SoundControlInfo.getInstance().isMp3Sound()) {
					try {
						AlarmCheckThread.getInstance().stopAlarmCheckThread();
						BeepTimerProcessor.getInstance()
								.stopBeepTimerProcessor();

					} catch (NoClassDefFoundError e) {
						MessageDialog.openError(getEditorSite().getShell(),
								AlarmCheckStartAction.JMF_DIALOG_TITLE_MESSAGE,
								AlarmCheckStartAction.JMF_ERROR_MESSAGE
										+ " NoClassDefFoundError "
										+ e.getMessage());
					}
				} else {
					try {
						AlarmCheckThread.getInstance().stopAlarmCheckThread();
						BeepTimerProcessor.getInstance()
								.stopBeepTimerProcessor();

					} catch (Exception e) {
						MessageDialog.openError(getEditorSite().getShell(),
								AlarmCheckStartAction.JMF_DIALOG_TITLE_MESSAGE,
								AlarmCheckStartAction.JMF_ERROR_MESSAGE
										+ " NoClassDefFoundError "
										+ e.getMessage());
					}
				}
				setText();
				alarmCheckStopButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		soundBeepCheckButton.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent event) {
			}

			public void widgetSelected(SelectionEvent event) {
				Button bChk = (Button) event.widget;

				if (bChk.getSelection()) {

					SoundControlInfo.getInstance().setMp3Sound(false);
					mp3SoundFileText.setEnabled(false);
					fileButton.setEnabled(false);
					mp3SoundPlayerStatusText.setEnabled(false);
				} else {

					SoundControlInfo.getInstance().setMp3Sound(true);
					mp3SoundFileText.setEnabled(true);
					fileButton.setEnabled(true);
					mp3SoundPlayerStatusText.setEnabled(true);
				}
			}
		});

		messageFilterCheckButton.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent event) {
			}

			public void widgetSelected(SelectionEvent event) {
				Button bChk = (Button) event.widget;

				if (bChk.getSelection()) {

					mailCheckStringText.setEnabled(true);
				} else {

					mailCheckStringText.setEnabled(false);
				}
			}
		});
	}

	private void setInitilaText() {
		alarmCheckStartButton.setEnabled(true);
		alarmCheckStopButton.setEnabled(false);
		soundBeepCheckButton.setSelection(true);
		SoundControlInfo.getInstance().setMp3Sound(false);
		mp3SoundFileText.setEnabled(false);
		fileButton.setEnabled(false);
		mp3SoundPlayerStatusText.setEnabled(false);
		setText();

		if (messageFilterCheckButton.getSelection()) {
			mailCheckStringText.setEnabled(true);
		} else {
			mailCheckStringText.setEnabled(false);
		}
	}

	private void setAlarmCheckStart() {
		alarmCheckStartButton.setEnabled(false);
		if (SoundControlInfo.getInstance().isMp3Sound()) {
			try {
				AlarmCheckThread.getInstance().startAlarmCheckThread();

			} catch (JMFException e) {
				MessageDialog.openError(getEditorSite().getShell(),
						AlarmCheckStartAction.JMF_DIALOG_TITLE_MESSAGE,
						AlarmCheckStartAction.JMF_ERROR_MESSAGE + " "
								+ e.getMessage());
				alarmCheckStartButton.setEnabled(true);

				return;
			} catch (NoClassDefFoundError e) {
				MessageDialog.openError(getEditorSite().getShell(),
						AlarmCheckStartAction.JMF_DIALOG_TITLE_MESSAGE,
						AlarmCheckStartAction.JMF_ERROR_MESSAGE
								+ " NoClassDefFoundError " + e.getMessage());
				alarmCheckStartButton.setEnabled(true);

				return;
			}
		} else {
			try {
				AlarmCheckThread.getInstance().startAlarmCheckThread();

			} catch (Exception e) {
				MessageDialog.openError(getEditorSite().getShell(),
						AlarmCheckStartAction.JMF_DIALOG_TITLE_MESSAGE,
						AlarmCheckStartAction.JMF_ERROR_MESSAGE + " "
								+ e.getMessage());
				alarmCheckStartButton.setEnabled(true);

				return;
			}
		}

		AlarmSoundFilter.getInstance().setMessageFilterString(
				messageFilterCheckButton.getSelection(),
				alarmLevelCombo.getText(), mailCheckStringText.getText());

		BeepTimerProcessor.getInstance().startBeepTimerProcessor();
		AlarmConfirmDialogTimerProcessor timerProcessor;

		timerProcessor = AlarmConfirmDialogTimerProcessor.getInstance();
		timerProcessor.setTimerConf(getEditorSite().getShell());
		timerProcessor.setMp3SoundPlayerStatusText(alarmCheckStatusText,
				mp3SoundPlayerStatusText, alarmCheckStartButton,
				alarmCheckStopButton);
		timerProcessor.stopAlarmConfirmDialogTimerProcessor();
		timerProcessor.startAlarmConfirmDialogTimerProcessor();

		setText();
		alarmCheckStartButton.setEnabled(true);
	}

	private void setText() {
		boolean isJMFThread = false;

		try {
			isJMFThread = JMFSoundControlThread.getInstance().checkThread();
			mp3SoundFileText.setText(JMFSoundControlThread.getInstance()
					.getMp3FileName());
		} catch (NoClassDefFoundError e) {
			mp3SoundFileText.setText(FilePreference.DEFAULT_MP3_FILE);
		}

		if (isJMFThread) {
			mp3SoundPlayerStatusText.setText(ACTIVE);
		} else {
			mp3SoundPlayerStatusText.setText(INACTIVE);
		}

		if (AlarmCheckThread.getInstance().checkThread()) {
			alarmCheckStatusText.setText(ACTIVE);
		} else {
			alarmCheckStatusText.setText(INACTIVE);
		}
	}

	/**
	 * Xe[^XC\Zbg܂B
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}

	/**
	 * Colorj܂B
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		if (textBackColor != null) {
			textBackColor.dispose();
		}
	}
}
