package netWatcherRCPSound.timer;

import netWatcherRCPSound.jmfcontrol.SoundControlInfo;

import org.eclipse.swt.widgets.Display;

public class BeepTimerProcessor implements Runnable {
	public static final int TIMER = 2000;

	public static final int TIMER_STOP = -1;

	private Display display;

	private BeepTimerProcessor() {
		// nothing
	}

	public void run() {

		if (!display.isDisposed()) {

			if (!SoundControlInfo.getInstance().isMp3Sound()
					&& SoundControlInfo.getInstance().isBeepSound()) {

				display.beep();

			}

			// ^C}[p
			display.timerExec(TIMER, this);
		}
	}

	public void setBeepTimerProcessor(Display display) {

		this.display = display;
	}

	public void startBeepTimerProcessor() {
		if (display != null) {
			display.timerExec(TIMER, this);
		}
	}

	public void stopBeepTimerProcessor() {
		if (display != null) {
			// ^C}[~
			display.timerExec(TIMER_STOP, this);
		}
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static BeepTimerProcessor getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final BeepTimerProcessor RESOURCE = new BeepTimerProcessor();
	}

	protected void finalize() throws java.lang.Throwable {
		stopBeepTimerProcessor();
		super.finalize();

	}
}
