/*
 * Decompiled with CFR 0.152.
 */
package netwatcher.ssh2.gui.treeview;

import java.util.logging.Logger;
import netwatcher.ssh2.gui.editor.EditorInputSSHNodeView;
import netwatcher.ssh2.gui.editor.EditorSSHCommandView;
import netwatcher.ssh2.gui.editor.EditorSSHKnownHostsFileView;
import netwatcher.ssh2.gui.editor.EditorSSHNodeFileView;
import netwatcher.ssh2.gui.treenode.SSHNodeTree;
import netwatcher.ssh2.gui.treenode.SSHNodeTreeGroup;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class SSHNodeTreeListener
implements ISelectionChangedListener {
    private static IWorkbenchPage activePage;
    private IEditorPart editorPart;
    private static Logger logger;

    static {
        logger = null;
    }

    public SSHNodeTreeListener() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection ss = (StructuredSelection)event.getSelection();
        if (!(ss.getFirstElement() instanceof SSHNodeTreeGroup) && !(ss.getFirstElement() instanceof SSHNodeTree)) {
            return;
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (this.editorPart != null) {
            activePage.closeEditor(this.editorPart, false);
            this.editorPart = null;
        }
        try {
            if (ss.getFirstElement() instanceof SSHNodeTree) {
                SSHNodeTree entry = (SSHNodeTree)ss.getFirstElement();
                this.editorPart = entry.getParent() != null && entry.getParent().getName() != null && entry.getParent().getName().equals("command") ? activePage.openEditor((IEditorInput)new EditorInputSSHNodeView(entry.getName(), entry.getTarget(), entry.getFile(), true), EditorSSHCommandView.class.getName()) : (entry.getName().equals("known_hosts") ? activePage.openEditor((IEditorInput)new EditorInputSSHNodeView(entry.getName(), entry.getTarget(), entry.getFile(), true), EditorSSHKnownHostsFileView.class.getName()) : activePage.openEditor((IEditorInput)new EditorInputSSHNodeView(entry.getName(), entry.getTarget(), entry.getFile(), true), EditorSSHNodeFileView.class.getName()));
            }
        }
        catch (PartInitException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }
}

