/*
 * Decompiled with CFR 0.152.
 */
package netwatcher.ssh2.model;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import java.io.File;
import java.util.logging.Logger;

public class JSchControl {
    private JSch jsch;
    private static Logger logger;

    private JSchControl() {
        logger = Logger.getLogger(this.getClass().getName());
        this.jsch = new JSch();
        try {
            this.setKnownHostsFile(this.jsch);
        }
        catch (JSchException e) {
            logger.warning("JSchException : " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void setKnownHostsFile(JSch jsch) throws JSchException {
        File sshDir = null;
        File knownHostsFile = new File("resources/ssh2/known_hosts");
        if (knownHostsFile != null) {
            logger.info("knownHostsFile.getAbsolutePath " + knownHostsFile.getAbsolutePath());
            jsch.setKnownHosts(knownHostsFile.getAbsolutePath());
        } else {
            if (sshDir == null) {
                sshDir = JSchControl.findSshDir();
            }
            if ((knownHostsFile = new File(sshDir, "known_hosts")).isFile() && knownHostsFile.canRead()) {
                jsch.setKnownHosts(knownHostsFile.getAbsolutePath());
            }
        }
    }

    private static File findSshDir() {
        File sshDir = new File("resources/ssh2/");
        if (sshDir.exists()) {
            return sshDir;
        }
        return new File("");
    }

    public static JSchControl getInstance() {
        return SingletonResource.RESOURCE;
    }

    public JSch getJsch() {
        return this.jsch;
    }

    /* synthetic */ JSchControl(JSchControl jSchControl) {
        this();
    }

    private static class SingletonResource {
        static final JSchControl RESOURCE = new JSchControl(null);

        private SingletonResource() {
        }
    }
}

