/*
 * Decompiled with CFR 0.152.
 */
package netwatcher.ssh2.model;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UserInfo;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import netwatcher.ssh2.info.Credentials;
import netwatcher.ssh2.info.SSHNodeInfoControl;
import netwatcher.ssh2.model.JSchControl;
import netwatcher.ssh2.model.SSHCommandMessageQueue;
import netwatcher.ssh2.model.SimpleSocketFactory;

public final class SSHCommandThread
implements Runnable {
    private static Logger logger = null;
    private int CHANNEL_INPUTSTREAM_BYTE_SIZE = 1024;
    private static final int TIMEOUT = 10000;
    private static final int SLEEP_TIME = 1000;
    private static Map ourSessionsPool = new Hashtable();
    private String userName;
    private String host;
    private Thread sshCommandThread;
    private ArrayList commandList;

    public SSHCommandThread() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void setUserHost(String userName, String host) {
        this.userName = userName;
        this.host = host;
    }

    public void setCommandList(ArrayList commandList) {
        this.commandList = commandList;
    }

    public void startTCPPortScanReceiveServer() {
        this.sshCommandThread = new Thread(this);
        this.sshCommandThread.setDaemon(true);
        this.sshCommandThread.start();
    }

    public void stopTCPPortScanReceiveServer() {
        if (this.sshCommandThread == null) {
            return;
        }
        this.sshCommandThread.interrupt();
    }

    public void run() {
        this.getSession(String.valueOf(this.userName) + "@" + this.host);
    }

    /*
     * Unable to fully structure code
     */
    public Session getSession(String target) {
        block19: {
            sshNodeInfo = SSHNodeInfoControl.getInstance().getSSHInfo(target);
            userName = sshNodeInfo.getSessionInfo().getUserName();
            host = sshNodeInfo.getSessionInfo().getHost();
            password = sshNodeInfo.getSshUserInfo().getPassword();
            port = sshNodeInfo.getSessionInfo().getPort();
            SSHCommandThread.logger.info("userName : " + userName);
            SSHCommandThread.logger.info("host : " + host);
            SSHCommandThread.logger.info("password : " + password);
            SSHCommandThread.logger.info("port : " + port);
            credentials = sshNodeInfo.getCredentials();
            key = String.valueOf(userName) + ":" + host + ":" + port;
            session = (Session)SSHCommandThread.ourSessionsPool.get(key);
            if (session != null && !session.isConnected()) {
                SSHCommandThread.ourSessionsPool.remove(key);
                SSHCommandThread.logger.info("SESSION " + key + " disposed");
                session = null;
            }
            try {
                if (session == null) {
                    jsch = JSchControl.getInstance().getJsch();
                    this.setCredentials(jsch, credentials);
                    session = jsch.getSession(userName, host, port);
                    table = new Hashtable<String, String>();
                    table.put("StrictHostKeyChecking", "no");
                    if (credentials.getIdRSAKeyFile() != null) {
                        table.put("server_host_key", "ssh-rsa");
                    } else if (credentials.getIdDSAKeyFile() != null) {
                        table.put("server_host_key", "ssh-dss");
                    }
                    session.setConfig(table);
                    userInfo = sshNodeInfo.getSshUserInfo();
                    session.setUserInfo((UserInfo)userInfo);
                    session.setSocketFactory((SocketFactory)SimpleSocketFactory.getInstance());
                    SSHCommandThread.logger.info("SESSION " + key + " created");
                    session.setTimeout(10000);
                    session.connect();
                    session.setTimeout(0);
                    SSHCommandThread.ourSessionsPool.put(key, session);
                    SSHCommandThread.logger.info("SESSION " + key + " connected");
                    this.execCommand(session, this.commandList);
                    SSHCommandThread.logger.info("ClientVersion : " + session.getClientVersion());
                    SSHCommandThread.logger.info("ServerVersion : " + session.getServerVersion());
                    SSHCommandThread.logger.info("Host : " + session.getHost());
                    SSHCommandThread.logger.info("UserName : " + session.getUserName());
                    hostKey = session.getHostKey();
                    SSHCommandThread.logger.info("Type : " + hostKey.getType());
                    SSHCommandThread.logger.info("Host : " + hostKey.getHost());
                    session.disconnect();
                } else {
                    SSHCommandThread.logger.info("SESSION " + key + " reused");
                }
                var15_15 = session;
                return var15_15;
            }
            catch (JSchException e) {
                SSHCommandThread.logger.warning("JSchException : " + e.getMessage());
                SSHCommandMessageQueue.getInstance().pushSSHCommandMessage("JSchException : " + e.getMessage() + System.getProperty("line.separator"));
                if (session != null && session.isConnected()) {
                    session.disconnect();
                    SSHCommandThread.logger.info("DISCONNECTING: " + session);
                }
                SSHCommandThread.logger.info("SESSION " + key + " diconnected");
                SSHCommandThread.ourSessionsPool.remove(key);
                SSHCommandThread.logger.info("SESSION " + key + " disposed");
                e.printStackTrace();
            }
            finally {
                if (SSHCommandThread.ourSessionsPool.size() <= 0) break block19;
                ** for (session : SSHCommandThread.ourSessionsPool.values())
            }
lbl-1000:
            // 1 sources

            {
                try {
                    session.disconnect();
                    SSHCommandThread.logger.info("DISCONNECTING: " + session);
                }
                catch (Exception ee) {
                    SSHCommandThread.logger.warning("Exception : " + ee.getMessage());
                }
                continue;
            }
lbl79:
            // 1 sources

            SSHCommandThread.ourSessionsPool.clear();
        }
        return null;
    }

    private void execCommand(Session session, ArrayList commandList) throws JSchException {
        int commandNo = 0;
        while (commandNo < commandList.size()) {
            ChannelExec channel = (ChannelExec)session.openChannel("exec");
            channel.setCommand((String)commandList.get(commandNo));
            channel.connect();
            SSHCommandMessageQueue.getInstance().pushSSHCommandMessage((String)commandList.get(commandNo));
            SSHCommandMessageQueue.getInstance().pushSSHCommandMessage(System.getProperty("line.separator"));
            SSHCommandMessageQueue.getInstance().pushSSHCommandMessage(System.getProperty("line.separator"));
            try {
                InputStream in = channel.getInputStream();
                byte[] tmp = new byte[this.CHANNEL_INPUTSTREAM_BYTE_SIZE];
                while (true) {
                    if (in.available() > 0) {
                        int i = in.read(tmp, 0, this.CHANNEL_INPUTSTREAM_BYTE_SIZE);
                        if (i >= 0) {
                            String message = new String(tmp, 0, i);
                            SSHCommandMessageQueue.getInstance().pushSSHCommandMessage(message);
                            continue;
                        }
                    }
                    if (channel.isClosed()) {
                        logger.info("exit-status: " + channel.getExitStatus());
                        break;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception ee) {
                        SSHCommandMessageQueue.getInstance().pushSSHCommandMessage(String.valueOf(ee.getMessage()) + System.getProperty("line.separator"));
                        logger.warning(ee.getMessage());
                        ee.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                SSHCommandMessageQueue.getInstance().pushSSHCommandMessage(String.valueOf(e.getMessage()) + System.getProperty("line.separator"));
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            SSHCommandMessageQueue.getInstance().pushSSHCommandMessage(System.getProperty("line.separator"));
            if (channel != null) {
                channel.disconnect();
            }
            ++commandNo;
        }
    }

    private void setCredentials(JSch jsch, Credentials credentials) throws JSchException {
        String passphrase = credentials.getPassphrase();
        if (credentials.getIdRSAKeyFile() != null) {
            String id_rsaKey = credentials.getIdRSAKeyFile().getAbsolutePath();
            logger.info("private id_rsaKey : " + id_rsaKey);
            logger.info("passphrase : " + passphrase);
            if (id_rsaKey != null && passphrase != null) {
                jsch.addIdentity(id_rsaKey, passphrase);
            } else if (id_rsaKey != null) {
                jsch.addIdentity(id_rsaKey);
            }
        }
        if (credentials.getIdDSAKeyFile() != null) {
            String id_dsaKey = credentials.getIdDSAKeyFile().getAbsolutePath();
            logger.info("private id_dsaKey : " + id_dsaKey);
            logger.info("passphrase : " + passphrase);
            if (id_dsaKey != null && passphrase != null) {
                jsch.addIdentity(id_dsaKey, passphrase);
            } else if (id_dsaKey != null) {
                jsch.addIdentity(id_dsaKey);
            }
        }
    }

    public static void shutdown() {
        if (ourSessionsPool.size() > 0) {
            for (Session session : ourSessionsPool.values()) {
                try {
                    session.disconnect();
                }
                catch (Exception exception) {}
            }
            ourSessionsPool.clear();
        }
    }
}

