/*
 * Decompiled with CFR 0.152.
 */
package netwatcher.ssh2.model;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UserInfo;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import netwatcher.ssh2.info.Credentials;
import netwatcher.ssh2.info.NetWatcherUserInfo;
import netwatcher.ssh2.info.SSHNodeInfo;
import netwatcher.ssh2.info.SSHNodeInfoControl;
import netwatcher.ssh2.model.JSchControl;
import netwatcher.ssh2.model.SimpleSocketFactory;

public class SshTest {
    private static final int TIMEOUT = 10000;
    private static Map ourSessionsPool = new Hashtable();
    private static Logger logger;

    public SshTest() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public Session getSession(String ip) {
        SSHNodeInfo sshNodeInfo = SSHNodeInfoControl.getInstance().getSSHInfo(ip);
        String userName = sshNodeInfo.getSessionInfo().getUserName();
        String host = sshNodeInfo.getSessionInfo().getHost();
        String password = sshNodeInfo.getSshUserInfo().getPassword();
        int port = sshNodeInfo.getSessionInfo().getPort();
        logger.info("userName : " + userName);
        logger.info("host : " + host);
        logger.info("password : " + password);
        logger.info("port : " + port);
        Credentials credentials = sshNodeInfo.getCredentials();
        String key = String.valueOf(userName) + ":" + host + ":" + port;
        Session session = (Session)ourSessionsPool.get(key);
        if (session != null && !session.isConnected()) {
            ourSessionsPool.remove(key);
            logger.info("SESSION " + key + " disposed");
            session = null;
        }
        try {
            if (session == null) {
                JSch jsch = JSchControl.getInstance().getJsch();
                this.test(jsch, credentials);
                session = jsch.getSession(userName, host, port);
                NetWatcherUserInfo userInfo = sshNodeInfo.getSshUserInfo();
                session.setUserInfo((UserInfo)userInfo);
                session.setSocketFactory((SocketFactory)SimpleSocketFactory.getInstance());
                logger.info("SESSION " + key + " created");
                session.setTimeout(10000);
                session.connect();
                session.setTimeout(0);
                ourSessionsPool.put(key, session);
                logger.info("SESSION " + key + " connected");
                ArrayList commandList = sshNodeInfo.getCommandList();
                this.execCommand(session, commandList);
                session.disconnect();
            } else {
                logger.info("SESSION " + key + " reused");
            }
            return session;
        }
        catch (JSchException e) {
            logger.warning(e.getMessage());
            if (session != null && session.isConnected()) {
                session.disconnect();
                logger.info("DISCONNECTING: " + session);
            }
            logger.info("SESSION " + key + " diconnected");
            ourSessionsPool.remove(key);
            logger.info("SESSION " + key + " disposed");
            return null;
        }
    }

    private void execCommand(Session session, ArrayList commandList) throws JSchException {
        int commandNo = 0;
        while (commandNo < commandList.size()) {
            ChannelExec channel = (ChannelExec)session.openChannel("exec");
            channel.setCommand((String)commandList.get(commandNo));
            channel.connect();
            System.out.println("command : " + commandNo + "  " + (String)commandList.get(commandNo));
            try {
                InputStream in = channel.getInputStream();
                byte[] tmp = new byte[1024];
                while (true) {
                    if (in.available() > 0) {
                        int i = in.read(tmp, 0, 1024);
                        if (i >= 0) {
                            System.out.print(new String(tmp, 0, i));
                            continue;
                        }
                    }
                    if (channel.isClosed()) {
                        System.out.println("exit-status: " + channel.getExitStatus());
                        break;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            if (channel != null) {
                channel.disconnect();
            }
            ++commandNo;
        }
    }

    private void test(JSch jsch, Credentials credentials) throws JSchException {
        String privateKey = null;
        String passphrase = null;
        if (credentials.getIdRSAKeyFile() != null) {
            privateKey = credentials.getIdRSAKeyFile().getAbsolutePath();
            passphrase = credentials.getPassphrase();
            logger.info("privateKey : " + privateKey);
            logger.info("passphrase : " + passphrase);
            if (privateKey != null && passphrase != null) {
                jsch.addIdentity(privateKey, passphrase);
            } else if (privateKey != null) {
                jsch.addIdentity(privateKey);
            }
        }
    }

    public static void shutdown() {
        if (ourSessionsPool.size() > 0) {
            for (Session session : ourSessionsPool.values()) {
                try {
                    session.disconnect();
                }
                catch (Exception exception) {}
            }
            ourSessionsPool.clear();
        }
    }
}

