/*
 * Decompiled with CFR 0.152.
 */
package netwatcher.ssh2.preference;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PassphraseDialog
extends Dialog {
    protected Text passphraseField;
    protected String passphrase = null;
    protected String message = null;

    public PassphraseDialog(Shell parentShell, String message) {
        super(parentShell);
        this.message = message;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.message);
    }

    public void create() {
        super.create();
        this.passphraseField.setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        if (this.message != null) {
            Label messageLabel = new Label(main, 64);
            messageLabel.setText(this.message);
            GridData data = new GridData(768);
            data.horizontalSpan = 3;
            messageLabel.setLayoutData((Object)data);
        }
        this.createPassphraseFields(main);
        return main;
    }

    protected void createPassphraseFields(Composite parent) {
        new Label(parent, 0).setText("Passphrase:");
        this.passphraseField = new Text(parent, 2048);
        GridData data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.passphraseField.setLayoutData((Object)data);
        this.passphraseField.setEchoChar('*');
        new Label(parent, 0);
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    protected void okPressed() {
        String _passphrase = this.passphraseField.getText();
        if (_passphrase == null || _passphrase.length() == 0) {
            return;
        }
        this.passphrase = _passphrase;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.passphrase = null;
        super.cancelPressed();
    }
}

