/*
 * Decompiled with CFR 0.152.
 */
package netwatcher.ssh2.preference;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class SSH2UserAuthManager {
    public static final String XML_FILE_VALUE = "value";
    public static final String ROOT = "root";
    public static final String TARGET = "target";
    public static final String PASSWORD = "password";
    public static final String PASSPHRASE = "passphrase";
    private static Logger logger = null;
    private String target;
    private String password;
    private String passphrase;

    public SSH2UserAuthManager() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void getSystemResourceFileParse(String filePath) throws FileNotFoundException {
        Document doc = null;
        doc = this.getResourceFileDocumentPath(filePath);
        if (doc == null) {
            logger.severe("Resource File Doc null " + filePath);
            return;
        }
        try {
            Element root = doc.getRootElement();
            Element targetEl = root.getChild(TARGET);
            if (targetEl != null) {
                this.target = root.getChild(TARGET).getAttributeValue(XML_FILE_VALUE);
                this.password = root.getChild(PASSWORD).getAttributeValue(XML_FILE_VALUE);
                this.passphrase = root.getChild(PASSPHRASE).getAttributeValue(XML_FILE_VALUE);
            } else {
                logger.warning("target not found");
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public BufferedWriter getResourceFileWriter(String filePath) {
        File f = new File(filePath);
        if (f == null) {
            return null;
        }
        BufferedWriter bufferedWriter = null;
        try {
            FileWriter fi = new FileWriter(filePath);
            bufferedWriter = new BufferedWriter(fi);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        return bufferedWriter;
    }

    public Document getResourceFileDocumentPath(String file) throws FileNotFoundException {
        Document doc = null;
        File f = new File(file);
        if (f == null) {
            logger.warning("Abort create File : " + f.getAbsolutePath());
            return null;
        }
        BufferedReader d = null;
        try {
            FileReader fi = new FileReader(file);
            d = new BufferedReader(fi);
        }
        catch (FileNotFoundException e1) {
            logger.warning("FileNotFoundException : " + f.getPath() + " : " + e1.getMessage());
            throw e1;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build((Reader)d);
        }
        catch (JDOMException e) {
            logger.warning("JDOMException : " + e.getMessage());
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            logger.warning("NullPointerException : " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.warning("IOException : " + e.getMessage());
            e.printStackTrace();
        }
        return doc;
    }

    public Document updateDocument(String target, String password, String passphrase) {
        Element confElement = new Element(ROOT);
        Document doc = new Document(confElement);
        Element targetEl = new Element(TARGET);
        Element passwordEl = new Element(PASSWORD);
        Element passphraseEl = new Element(PASSPHRASE);
        confElement.addContent((Content)targetEl);
        confElement.addContent((Content)passwordEl);
        confElement.addContent((Content)passphraseEl);
        targetEl.setAttribute(new Attribute(XML_FILE_VALUE, target));
        passwordEl.setAttribute(new Attribute(XML_FILE_VALUE, password));
        passphraseEl.setAttribute(new Attribute(XML_FILE_VALUE, passphrase));
        return doc;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTarget() {
        return this.target;
    }
}

