/*
 * Decompiled with CFR 0.152.
 */
package netwatcher.ssh2.preference;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.logging.Logger;
import netjfwatcher.engine.resource.XMLOutputterFormat;
import netwatcher.ssh2.preference.SSH2UserAuthManager;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class SSH2UserAuthManagerOutputControl {
    private static Logger logger;

    private SSH2UserAuthManagerOutputControl() {
    }

    public void outputXMLFile(BufferedWriter bufWriter, Document dom) {
        logger = Logger.getLogger(this.getClass().getName());
        XMLOutputter outputter = XMLOutputterFormat.getInstance().getXMLOutputterFormat();
        OutputStreamWriter writer = null;
        try {
            try {
                outputter.output(dom, (OutputStream)System.out);
                outputter.output(dom, (Writer)bufWriter);
            }
            catch (IOException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
    }

    protected void saveResourceXMLInfo(String filePath, String target, String password, String passphrase) {
        Document dom = null;
        BufferedWriter bufWriter = null;
        SSH2UserAuthManager manager = new SSH2UserAuthManager();
        dom = this.updateResource(manager, target, password, passphrase);
        bufWriter = manager.getResourceFileWriter(filePath);
        this.outputXMLFile(bufWriter, dom);
        if (bufWriter != null) {
            try {
                bufWriter.close();
            }
            catch (IOException e) {
                logger.warning("Abort close BufferedWriter for snmp resource : " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected Document updateResource(SSH2UserAuthManager manager, String target, String password, String passphrase) {
        Document dom = manager.updateDocument(target, password, passphrase);
        return dom;
    }

    public static SSH2UserAuthManagerOutputControl getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ SSH2UserAuthManagerOutputControl(SSH2UserAuthManagerOutputControl sSH2UserAuthManagerOutputControl) {
        this();
    }

    private static class SingletonResource {
        static final SSH2UserAuthManagerOutputControl RESOURCE = new SSH2UserAuthManagerOutputControl(null);

        private SingletonResource() {
        }
    }
}

