package netwatcher.ssh2.gui.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Pattern;

import netjfwatcher.snmpmanager.model.ActionBuilderTrapReceiveTable;
import netwatcher.ssh2.info.Credentials;
import netwatcher.ssh2.info.NetWatcherUserInfo;
import netwatcher.ssh2.info.SSHNodeInfo;
import netwatcher.ssh2.info.SSHNodeInfoControl;
import netwatcher.ssh2.info.SessionInfo;
import netwatcher.ssh2.model.CommandFileParse;
import netwatcher.ssh2.model.SSHCommandThread;
import netwatcher.ssh2.preference.SSH2Preference;
import netwatcher.ssh2.preference.SSH2UserAuthManager;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class EditorSSHCommandView extends AbstractEditorSSH {
	/** View^CgSuffix */
	public static final String TITLE_SUFFIX = " Node View";

	/** f[^\eLXg */
	public static final int DATE_TEXT_WIDTH = 250;

	/** eLXg\ */
	public static final int TEXT_WIDTH1 = 120;

	/* Scroll CompositeTCY */
	private static final int[] SCROLL_COMPOSITE_SIZE = { 800, 800 };

	/* Horizontal Span 4 */
	private static final int HORIZONTAL_SPAN4 = 4;

	/* Horizontal Span 6 */
	private static final int HORIZONTAL_SPAN6 = 6;

	/* Port Scan f[^\^C}[ */
	private static final int PORT_SCAN_TABLE_TIMER = 1000;

	private EditorSSHCommandTimerProcessor timerProcessor;

	/* Display */
	private Display display;

	private Button commandResetButton;

	private Button commandLoadButton;

	private Text commandText;

	private Text moniterText;

	private Button commandButton;

	private Button monitorResetButton;

	private String target;

	private File commandFile;

	/* Logging */
	private static Logger logger;



	public EditorSSHCommandView() {
		logger = Logger.getLogger(this.getClass().getName());

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {

		display = parent.getDisplay();

		/* ͐ݒlm[hĎ擾 */
		EditorInputSSHNodeView nodeViewEditorInput = (EditorInputSSHNodeView) getEditorInput();

		commandFile = nodeViewEditorInput.getFile();
		target = nodeViewEditorInput.getTarget();

		/*
		 * ViewCAEg
		 */
		ScrolledComposite scrollComposite = new ScrolledComposite(parent,
				SWT.H_SCROLL | SWT.V_SCROLL);

		GridLayout layout = new GridLayout(1, false);
		scrollComposite.setLayout(layout);

		GridData gridData = null;

		GridLayout gridLayout0 = new GridLayout(1, true);
		Composite composite0 = new Composite(scrollComposite, SWT.NONE);
		composite0.setLayout(gridLayout0);
		composite0.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL
				| GridData.VERTICAL_ALIGN_FILL));

		GridLayout gridLayout = new GridLayout(1, false);
		Composite composite1 = new Composite(composite0, SWT.NULL);
		composite1.setLayout(gridLayout);
		composite1.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		gridData = new GridData();

		Label label;

		GridLayout gridLayout2 = new GridLayout(HORIZONTAL_SPAN6, true);
		Composite composite2 = new Composite(composite0, SWT.NONE);
		composite2.setLayoutData(new GridData(GridData.BEGINNING));

		composite2.setLayout(gridLayout2);

		commandResetButton = new Button(composite2, SWT.NULL);
		commandResetButton.setText("Command reset");
		GridData gd = new GridData();
		gd.horizontalSpan = 1;
		commandResetButton.setLayoutData(gd);

		commandLoadButton = new Button(composite2, SWT.NULL);
		commandLoadButton.setText("Command load");
		gd = new GridData();
		gd.horizontalSpan = 1;
		commandLoadButton.setLayoutData(gd);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		GridData gridData2 = new GridData();
		gridData2.horizontalSpan = HORIZONTAL_SPAN4;
		gridData2.verticalSpan = 1;
		label.setLayoutData(gridData2);

		commandText = new Text(composite2, SWT.MULTI | SWT.BORDER
				| SWT.V_SCROLL | SWT.WRAP);
		commandText.setText("");

		// gridData = new GridData(GridData.FILL_BOTH);
		gridData = new GridData(GridData.FILL_HORIZONTAL);

		// gridData.horizontalAlignment = GridData.FILL;
		// gridData.verticalAlignment = 10;
		// gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN6;
		// gridData.verticalSpan = 7;
		gridData.widthHint = 600;
		gridData.heightHint = 100;

		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;

		commandText.setLayoutData(gridData);

		commandButton = new Button(composite2, SWT.NULL);
		commandButton.setText("Command exec");
		gd = new GridData();
		gd.horizontalSpan = 1;
		commandButton.setLayoutData(gd);

		monitorResetButton = new Button(composite2, SWT.NULL);
		monitorResetButton.setText("Monitor reset");
		gd = new GridData();
		gd.horizontalSpan = 1;
		monitorResetButton.setLayoutData(gd);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData2 = new GridData();
		gridData2.horizontalSpan = HORIZONTAL_SPAN4;
		gridData2.verticalSpan = 1;
		label.setLayoutData(gridData2);

		moniterText = new Text(composite2, SWT.MULTI | SWT.BORDER
				| SWT.V_SCROLL | SWT.WRAP);
		moniterText.setText("");

		// gridData = new GridData(GridData.FILL_BOTH);
		gridData = new GridData(GridData.FILL_HORIZONTAL);

		// gridData.horizontalAlignment = GridData.FILL;
		// gridData.verticalAlignment = 10;

		gridData.horizontalSpan = HORIZONTAL_SPAN6;
		// gridData.verticalSpan = 4;
		// gridData.widthHint = 200;
		gridData.widthHint = 600;
		gridData.heightHint = 400;

		moniterText.setLayoutData(gridData);

		scrollComposite.setContent(composite0);
		scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0],
				SCROLL_COMPOSITE_SIZE[1]);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

		try {
			parseCommandFile(commandFile.getPath());
		} catch (IOException e) {
			logger.warning("IOException : " + e.getMessage());
		}		
		setSelectionListener();
	}

	private void setSelectionListener() {
		commandResetButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				commandText.setText("");

			}
		});
		commandLoadButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				commandText.setText("");
				try {
					parseCommandFile(commandFile.getPath());
				} catch (IOException e2) {
					MessageDialog.openError(getSite().getShell(),
							"Error", "IOException " + e2.getMessage() + " " + commandFile.getPath());
					return;
				}				

			}
		});

		monitorResetButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				moniterText.setText("");

			}
		});

		commandButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {

				commandButton.setEnabled(false);
				String commandString = commandText.getText();

				Pattern pattern;
				String[] mibLineItemArray;
				pattern = Pattern.compile(System.getProperty("line.separator"));
				mibLineItemArray = pattern.split(commandString);
				ArrayList commandList = new ArrayList();

				if (mibLineItemArray != null) {
					for (int i = 0; i < mibLineItemArray.length; i++) {
						System.out.println("command " + i + " : "
								+ mibLineItemArray[i]);
						commandList.add(mibLineItemArray[i]);
						// commandList.add("uname");
					}
				}

				System.out.println("target " + target);

				SSH2UserAuthManager manager = new SSH2UserAuthManager();

				try {
					manager
							.getSystemResourceFileParse(SSH2Preference.RESOURCE_SSH2_DIR
									+ target
									+ "/"
									+ SSH2Preference.USER_HOST_AUTH);
				} catch (IOException e1) {
					MessageDialog.openError(getSite().getShell(),
							"Error", "IOException " + e1.getMessage() + " " + SSH2Preference.RESOURCE_SSH2_DIR
							+ target
							+ "/"
							+ SSH2Preference.USER_HOST_AUTH);
					commandButton.setEnabled(true);
					return;
				}				
				String userHost = manager.getTarget();

				String user = "";
				String host = "";

				if (target.indexOf('@') > 0) {
					user = userHost.substring(0, userHost.indexOf('@'));
					host = userHost.substring(userHost.indexOf('@') + 1);
				}

				System.out.println("user " + user);
				System.out.println("host " + host);
				System.out.println("Password " + manager.getPassword());
				System.out.println("Passphrase " + manager.getPassphrase());

				setSSHInfo(user, host, manager.getPassword(), manager
						.getPassphrase());

				SSHCommandThread thread = new SSHCommandThread();
				thread.setUserHost(user, host);
				thread.setCommandList(commandList);
				thread.startTCPPortScanReceiveServer();

				startTimer();
			}
		});
	}

	public void parseCommandFile(String file) throws IOException {

		BufferedReader buffReader = null;
		FileReader fi = null;
		try {
			fi = new FileReader(file);
			buffReader = new BufferedReader(fi);
		} catch (FileNotFoundException e1) {
			throw e1;
		}

		try {

			String message;

			while ((message = buffReader.readLine()) != null) {
				commandText.append(message
						+ System.getProperty("line.separator"));
			}

		} catch (FileNotFoundException e1) {
			e1.printStackTrace();
			throw e1;
		} catch (IOException e) {
			e.printStackTrace();
			throw e;
		} finally {
			if (buffReader != null) {
				try {
					buffReader.close();
				} catch (IOException e2) {
					logger.warning(e2.getMessage());
					e2.printStackTrace();
				}
			}

			if (fi != null) {
				try {
					fi.close();
				} catch (IOException e2) {
					logger.warning(e2.getMessage());
					e2.printStackTrace();
				}
			}
		}

	}

	public void setSSHInfo(String userName, String host, String password,
			String passphrase) {

		Credentials cred = new Credentials();
		cred.setPassphrase(passphrase);
		File id_dsa_keyFile = new File(SSH2Preference.RESOURCE_SSH2_DIR + userName
				+ "@" + host + "/" + SSH2Preference.ID_DSA_FILE);




		if (id_dsa_keyFile == null) {
			logger.warning("resources/id_dsa null");
		} else {
			if (!id_dsa_keyFile.exists()) {
				logger.warning("resources/id_dsa no exists");
			} else {
				cred.setIdDSAKeyFile(id_dsa_keyFile);

			}
		}

		
		File id_rsa_keyFile = new File(SSH2Preference.RESOURCE_SSH2_DIR + userName
				+ "@" + host + "/" + SSH2Preference.ID_RSA_FILE);


		ArrayList commandList = new ArrayList();

		if (id_rsa_keyFile == null) {
			logger.warning("resources/id_rsa null");
		} else {
			if (!id_rsa_keyFile.exists()) {
				logger.warning("resources/id_rsa no exists");
			} else {
				cred.setIdRSAKeyFile(id_rsa_keyFile);

			}

		}

		
		
		SessionInfo sessionInfo = new SessionInfo();
		sessionInfo.setHost(host);
		sessionInfo.setPort(SSH2Preference.SSH_PORT);
		sessionInfo.setUserName(userName);

		NetWatcherUserInfo userInfo = new NetWatcherUserInfo(password,
				passphrase);

		SSHNodeInfo sshNodeInfo = new SSHNodeInfo();
		sshNodeInfo.setCredentials(cred);
		sshNodeInfo.setSshUserInfo(userInfo);
		sshNodeInfo.setSessionInfo(sessionInfo);
		sshNodeInfo.setCommandList(commandList);

		SSHNodeInfoControl.getInstance().setSSHInfo(userName + "@" + host, sshNodeInfo);

	}

	/**
	 * Xe[^XC\Zbg܂B
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}

	private void startTimer() {

		EditorSSHCommandTimerProcessor.getInstance().setDisplay(display);
		EditorSSHCommandTimerProcessor.getInstance().setMonitorText(
				getEditorSite(), moniterText, commandButton);
		timerProcessor = EditorSSHCommandTimerProcessor.getInstance();
		display.timerExec(PORT_SCAN_TABLE_TIMER, timerProcessor);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		/* TrapMf[^\^C}[~ */
		display.timerExec(ActionBuilderTrapReceiveTable.TIMER_STOP,
				timerProcessor);
	}

}
