/*
 * Created on 2005/04/14
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.gui.treeview;

import java.util.logging.Logger;

import netwatcher.ssh2.gui.editor.EditorInputSSHNodeView;
import netwatcher.ssh2.gui.editor.EditorSSHCommandView;
import netwatcher.ssh2.gui.editor.EditorSSHKnownHostsFileView;
import netwatcher.ssh2.gui.editor.EditorSSHNodeFileView;
import netwatcher.ssh2.gui.treenode.SSHNodeTree;
import netwatcher.ssh2.gui.treenode.SSHNodeTreeGroup;
import netwatcher.ssh2.preference.SSH2Preference;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/**
 * m[hTreeIXi[NXłB m[hTreeIɂAm[hViewuEUŕ\܂B
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SSHNodeTreeListener implements ISelectionChangedListener {
	/* IWorkbenchPage */
	private static IWorkbenchPage activePage;

	private IEditorPart editorPart;

	/* MO */
	private static Logger logger = null;
	public SSHNodeTreeListener() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * e[uViewɃtB[hꗗőIGg͒lƂĐݒ ̃Cxg_@ƂWebɃANZX
	 * 
	 * @param event
	 *            SelectionChangedEvent
	 */
	public void selectionChanged(SelectionChangedEvent event) {
		

		StructuredSelection ss = (StructuredSelection) event.getSelection();


		if (!(ss.getFirstElement() instanceof SSHNodeTreeGroup)
				&& !(ss.getFirstElement() instanceof SSHNodeTree)) {

			return;
		}

		IWorkbenchPage activePage = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage();

		if (editorPart != null) {

			activePage.closeEditor(editorPart, false);
			editorPart = null;
		}

		try {

			if (ss.getFirstElement() instanceof SSHNodeTree) {
				final SSHNodeTree entry = (SSHNodeTree) ss.getFirstElement();
				
				if (entry.getParent() != null && entry.getParent().getName() != null && entry.getParent().getName().equals(SSH2Preference.COMMAND_DIR)) {
					editorPart = activePage.openEditor(
							new EditorInputSSHNodeView(entry.getName(), entry.getTarget(), entry
									.getFile(), true),
							EditorSSHCommandView.class.getName());
				} else if (entry.getName().equals(SSH2Preference.KNOWN_HOSTS_FILE)) {
					editorPart = activePage.openEditor(
							new EditorInputSSHNodeView(entry.getName(), entry.getTarget(), entry
									.getFile(), true),
							EditorSSHKnownHostsFileView.class.getName());
					
				} else {
					editorPart = activePage.openEditor(
							new EditorInputSSHNodeView(entry.getName(), entry.getTarget(), entry
									.getFile(), true),
									EditorSSHNodeFileView.class.getName());
					
				}
			}
		} catch (PartInitException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();
		}

	}
}
